/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.util.XMLWriter;

public class MapXMLWriter
extends XMLWriter {
    public static final String MAP_TAG = "map";
    public static final String KEY_TAG = "key";
    public static final String VALUE_TAG = "value";
    public static final String NAME_TAG = "name";

    public MapXMLWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        super(outputStream);
    }

    public void writeMap(Map map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = map.keySet().iterator();
        this.startTag(MAP_TAG, null);
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            hashMap.put(NAME_TAG, k.toString());
            this.startTag(KEY_TAG, hashMap);
            if (k != null) {
                if (v instanceof List) {
                    Iterator iterator2 = ((List)v).iterator();
                    while (iterator2.hasNext()) {
                        this.printSimpleTag(VALUE_TAG, iterator2.next());
                    }
                } else if (v != null) {
                    this.printSimpleTag(VALUE_TAG, v.toString());
                }
            }
            this.endTag(KEY_TAG);
        }
        this.endTag(MAP_TAG);
        this.flush();
    }
}

