/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.VariableContextBuilder;
import org.eclipse.php.internal.core.phpModel.phpElementData.BasicPHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlockImp;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPTask;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.util.ICachable;

public class SerializationUtil {
    private static String currentFileName;

    public static void serialize(ICachable[] iCachableArray, DataOutputStream dataOutputStream) throws IOException {
        if (iCachableArray != null) {
            dataOutputStream.writeInt(iCachableArray.length);
            int n = 0;
            while (n < iCachableArray.length) {
                SerializationUtil.serialize((PHPFileData)iCachableArray[n], dataOutputStream);
                ++n;
            }
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    private static void serialize(PHPFileData pHPFileData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPFileData != null) {
            currentFileName = pHPFileData.getName();
            SerializationUtil.writeString(currentFileName, dataOutputStream);
            SerializationUtil.serialize(pHPFileData.getUserData(), dataOutputStream);
            SerializationUtil.serialize(pHPFileData.getClasses(), dataOutputStream);
            SerializationUtil.serialize(pHPFileData.getFunctions(), dataOutputStream);
            SerializationUtil.serialize(pHPFileData.getVariableTypeManager(), dataOutputStream);
            SerializationUtil.serialize(pHPFileData.getIncludeFiles(), dataOutputStream);
            SerializationUtil.serialize(pHPFileData.getConstants(), dataOutputStream);
            SerializationUtil.serialize(pHPFileData.getMarkers(), dataOutputStream);
            SerializationUtil.serialize(pHPFileData.getPHPBlocks(), dataOutputStream);
            SerializationUtil.serialize(pHPFileData.getDocBlock(), dataOutputStream);
            dataOutputStream.writeLong(pHPFileData.getCreationTimeLastModified());
        }
    }

    private static void serialize(UserData userData, DataOutputStream dataOutputStream) throws IOException {
        if (userData != null) {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeInt(userData.getStartPosition());
            dataOutputStream.writeInt(userData.getEndPosition());
            dataOutputStream.writeInt(userData.getStopPosition());
            dataOutputStream.writeInt(userData.getStopLine());
        } else {
            dataOutputStream.writeBoolean(false);
        }
    }

    private static void serialize(PHPClassData[] pHPClassDataArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPClassDataArray != null) {
            dataOutputStream.writeInt(pHPClassDataArray.length);
            int n = 0;
            while (n < pHPClassDataArray.length) {
                SerializationUtil.serialize(pHPClassDataArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPClassData pHPClassData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPClassData != null) {
            SerializationUtil.writeString(pHPClassData.getName(), dataOutputStream);
            dataOutputStream.writeInt(pHPClassData.getModifiers());
            SerializationUtil.serialize(pHPClassData.getDocBlock(), dataOutputStream);
            SerializationUtil.serialize(pHPClassData.getUserData(), dataOutputStream);
            SerializationUtil.serialize(pHPClassData.getSuperClassData(), dataOutputStream);
            SerializationUtil.serialize(pHPClassData.getInterfacesNamesData(), dataOutputStream);
            SerializationUtil.serialize(pHPClassData.getVars(), dataOutputStream);
            SerializationUtil.serialize(pHPClassData.getConsts(), dataOutputStream);
            SerializationUtil.serialize(pHPClassData.getFunctions(), dataOutputStream);
        }
    }

    private static void serialize(PHPClassConstData[] pHPClassConstDataArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPClassConstDataArray != null) {
            dataOutputStream.writeInt(pHPClassConstDataArray.length);
            int n = 0;
            while (n < pHPClassConstDataArray.length) {
                SerializationUtil.serialize(pHPClassConstDataArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPClassConstData pHPClassConstData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPClassConstData != null) {
            SerializationUtil.writeString(pHPClassConstData.getName(), dataOutputStream);
            SerializationUtil.serialize(pHPClassConstData.getDocBlock(), dataOutputStream);
            SerializationUtil.serialize(pHPClassConstData.getUserData(), dataOutputStream);
        }
    }

    private static void serialize(PHPClassVarData[] pHPClassVarDataArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPClassVarDataArray != null) {
            dataOutputStream.writeInt(pHPClassVarDataArray.length);
            int n = 0;
            while (n < pHPClassVarDataArray.length) {
                SerializationUtil.serialize(pHPClassVarDataArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPClassVarData pHPClassVarData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPClassVarData != null) {
            SerializationUtil.writeString(pHPClassVarData.getName(), dataOutputStream);
            dataOutputStream.writeInt(pHPClassVarData.getModifiers());
            SerializationUtil.writeString(pHPClassVarData.getClassType(), dataOutputStream);
            SerializationUtil.serialize(pHPClassVarData.getDocBlock(), dataOutputStream);
            SerializationUtil.serialize(pHPClassVarData.getUserData(), dataOutputStream);
        }
    }

    private static void serialize(PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPInterfaceNameDataArray != null) {
            dataOutputStream.writeInt(pHPInterfaceNameDataArray.length);
            int n = 0;
            while (n < pHPInterfaceNameDataArray.length) {
                SerializationUtil.serialize(pHPInterfaceNameDataArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPClassData.PHPInterfaceNameData pHPInterfaceNameData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPInterfaceNameData != null) {
            SerializationUtil.writeString(pHPInterfaceNameData.getName(), dataOutputStream);
            SerializationUtil.serialize(pHPInterfaceNameData.getUserData(), dataOutputStream);
        }
    }

    private static void serialize(PHPClassData.PHPSuperClassNameData pHPSuperClassNameData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPSuperClassNameData != null) {
            SerializationUtil.writeString(pHPSuperClassNameData.getName(), dataOutputStream);
            SerializationUtil.serialize(pHPSuperClassNameData.getUserData(), dataOutputStream);
        }
    }

    private static void serialize(PHPDocBlock pHPDocBlock, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(pHPDocBlock != null);
        if (pHPDocBlock != null) {
            SerializationUtil.writeString(pHPDocBlock.getShortDescription(), dataOutputStream);
            SerializationUtil.writeString(pHPDocBlock.getLongDescription(), dataOutputStream);
            SerializationUtil.serialize(pHPDocBlock.getTagsAsArray(), dataOutputStream);
            dataOutputStream.writeInt(pHPDocBlock.getType());
            dataOutputStream.writeInt(pHPDocBlock.getStartPosition());
            dataOutputStream.writeInt(pHPDocBlock.getEndPosition());
        }
    }

    private static void serialize(PHPConstantData[] pHPConstantDataArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPConstantDataArray != null) {
            dataOutputStream.writeInt(pHPConstantDataArray.length);
            int n = 0;
            while (n < pHPConstantDataArray.length) {
                SerializationUtil.serialize(pHPConstantDataArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPConstantData pHPConstantData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPConstantData != null) {
            SerializationUtil.writeString(pHPConstantData.getName(), dataOutputStream);
            SerializationUtil.writeString(pHPConstantData.getValue(), dataOutputStream);
            SerializationUtil.serialize(pHPConstantData.getUserData(), dataOutputStream);
            SerializationUtil.serialize(pHPConstantData.getDocBlock(), dataOutputStream);
        }
    }

    private static void serialize(PHPDocTag[] pHPDocTagArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPDocTagArray != null) {
            dataOutputStream.writeInt(pHPDocTagArray.length);
            int n = 0;
            while (n < pHPDocTagArray.length) {
                SerializationUtil.serialize(pHPDocTagArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPDocTag pHPDocTag, DataOutputStream dataOutputStream) throws IOException {
        if (pHPDocTag != null) {
            dataOutputStream.writeInt(pHPDocTag.getID());
            SerializationUtil.writeString(pHPDocTag.getValue(), dataOutputStream);
        }
    }

    private static void serialize(PHPBlock[] pHPBlockArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPBlockArray != null) {
            dataOutputStream.writeInt(pHPBlockArray.length);
            int n = 0;
            while (n < pHPBlockArray.length) {
                SerializationUtil.serialize(pHPBlockArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPBlock pHPBlock, DataOutputStream dataOutputStream) throws IOException {
        if (pHPBlock != null) {
            SerializationUtil.serialize(pHPBlock.getPHPStartTag(), dataOutputStream);
            SerializationUtil.serialize(pHPBlock.getPHPEndTag(), dataOutputStream);
        }
    }

    private static void serialize(IPHPMarker[] iPHPMarkerArray, DataOutputStream dataOutputStream) throws IOException {
        if (iPHPMarkerArray != null) {
            dataOutputStream.writeInt(iPHPMarkerArray.length);
            int n = 0;
            while (n < iPHPMarkerArray.length) {
                SerializationUtil.serialize(iPHPMarkerArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(IPHPMarker iPHPMarker, DataOutputStream dataOutputStream) throws IOException {
        if (iPHPMarker != null) {
            SerializationUtil.writeString(iPHPMarker.getDescription(), dataOutputStream);
            SerializationUtil.writeString(iPHPMarker.getType(), dataOutputStream);
            if (iPHPMarker instanceof PHPTask) {
                SerializationUtil.writeString(((PHPTask)iPHPMarker).getTaskName(), dataOutputStream);
            }
            SerializationUtil.serialize(iPHPMarker.getUserData(), dataOutputStream);
        }
    }

    private static void serialize(PHPVariablesTypeManager pHPVariablesTypeManager, DataOutputStream dataOutputStream) throws IOException {
        Object object;
        Object object2;
        Map map = pHPVariablesTypeManager.getContextsToVariables();
        Iterator iterator = map.keySet().iterator();
        dataOutputStream.writeInt(map.size());
        while (iterator.hasNext()) {
            object2 = (PHPCodeContext)iterator.next();
            object = (PHPVariableData[])map.get(object2);
            SerializationUtil.serialize((PHPCodeContext)object2, dataOutputStream);
            dataOutputStream.writeInt(((PHPVariableData[])object).length);
            int n = 0;
            while (n < ((PHPVariableData[])object).length) {
                SerializationUtil.serialize(object[n], dataOutputStream);
                ++n;
            }
        }
        object2 = pHPVariablesTypeManager.getVariablesInstansiation();
        iterator = object2.keySet().iterator();
        dataOutputStream.writeInt(object2.size());
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            List list = (List)object2.get(object);
            SerializationUtil.writeString((String)object, dataOutputStream);
            dataOutputStream.writeInt(list.size());
            int n = 0;
            while (n < list.size()) {
                PHPVariableTypeData pHPVariableTypeData = (PHPVariableTypeData)list.get(n);
                SerializationUtil.serialize(pHPVariableTypeData, dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPVariableTypeData pHPVariableTypeData, DataOutputStream dataOutputStream) throws IOException {
        SerializationUtil.writeString(pHPVariableTypeData.getType(), dataOutputStream);
        dataOutputStream.writeInt(pHPVariableTypeData.getLine());
        dataOutputStream.writeInt(pHPVariableTypeData.getPosition());
        dataOutputStream.writeBoolean(pHPVariableTypeData.isUserDocumentation());
    }

    private static void serialize(PHPCodeContext pHPCodeContext, DataOutputStream dataOutputStream) throws IOException {
        SerializationUtil.writeString(pHPCodeContext.getContainerClassName(), dataOutputStream);
        SerializationUtil.writeString(pHPCodeContext.getContainerFunctionName(), dataOutputStream);
    }

    private static void serialize(PHPIncludeFileData[] pHPIncludeFileDataArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPIncludeFileDataArray != null) {
            dataOutputStream.writeInt(pHPIncludeFileDataArray.length);
            int n = 0;
            while (n < pHPIncludeFileDataArray.length) {
                SerializationUtil.serialize(pHPIncludeFileDataArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPIncludeFileData pHPIncludeFileData, DataOutputStream dataOutputStream) throws IOException {
        SerializationUtil.serialize((PHPCodeData)pHPIncludeFileData, dataOutputStream);
    }

    private static void serialize(PHPVariableData pHPVariableData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPVariableData != null) {
            SerializationUtil.writeString(pHPVariableData.getName(), dataOutputStream);
            dataOutputStream.writeBoolean(pHPVariableData.isGlobal());
            SerializationUtil.serialize(pHPVariableData.getDocBlock(), dataOutputStream);
            SerializationUtil.serialize(pHPVariableData.getUserData(), dataOutputStream);
        }
    }

    private static void serialize(PHPCodeData pHPCodeData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPCodeData != null) {
            SerializationUtil.writeString(pHPCodeData.getName(), dataOutputStream);
            SerializationUtil.serialize(pHPCodeData.getDocBlock(), dataOutputStream);
            SerializationUtil.serialize(pHPCodeData.getUserData(), dataOutputStream);
        }
    }

    private static void serialize(PHPFunctionData[] pHPFunctionDataArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPFunctionDataArray != null) {
            dataOutputStream.writeInt(pHPFunctionDataArray.length);
            int n = 0;
            while (n < pHPFunctionDataArray.length) {
                SerializationUtil.serialize(pHPFunctionDataArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPFunctionData pHPFunctionData, DataOutputStream dataOutputStream) throws IOException {
        if (pHPFunctionData != null) {
            SerializationUtil.writeString(pHPFunctionData.getName(), dataOutputStream);
            dataOutputStream.writeInt(pHPFunctionData.getModifiers());
            SerializationUtil.serialize(pHPFunctionData.getDocBlock(), dataOutputStream);
            SerializationUtil.serialize(pHPFunctionData.getUserData(), dataOutputStream);
            SerializationUtil.serialize(pHPFunctionData.getParameters(), dataOutputStream);
            SerializationUtil.writeString(pHPFunctionData.getReturnType(), dataOutputStream);
        }
    }

    private static void serialize(PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray, DataOutputStream dataOutputStream) throws IOException {
        if (pHPFunctionParameterArray != null) {
            dataOutputStream.writeInt(pHPFunctionParameterArray.length);
            int n = 0;
            while (n < pHPFunctionParameterArray.length) {
                SerializationUtil.serialize(pHPFunctionParameterArray[n], dataOutputStream);
                ++n;
            }
        }
    }

    private static void serialize(PHPFunctionData.PHPFunctionParameter pHPFunctionParameter, DataOutputStream dataOutputStream) throws IOException {
        if (pHPFunctionParameter != null) {
            SerializationUtil.writeString(pHPFunctionParameter.getName(), dataOutputStream);
            SerializationUtil.serialize(pHPFunctionParameter.getUserData(), dataOutputStream);
            dataOutputStream.writeBoolean(pHPFunctionParameter.isReference());
            dataOutputStream.writeBoolean(pHPFunctionParameter.isConst());
            SerializationUtil.writeString(pHPFunctionParameter.getClassType(), dataOutputStream);
            SerializationUtil.writeString(pHPFunctionParameter.getDefaultValue(), dataOutputStream);
        }
    }

    public static PHPFileData[] deserializePHPFileDataArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        PHPFileData[] pHPFileDataArray = new PHPFileData[n];
        int n2 = 0;
        while (n2 < n) {
            pHPFileDataArray[n2] = SerializationUtil.deserializePHPFileData(dataInputStream);
            ++n2;
        }
        return pHPFileDataArray;
    }

    private static PHPFileData deserializePHPFileData(DataInputStream dataInputStream) throws IOException {
        String string;
        currentFileName = string = SerializationUtil.readString(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        PHPClassData[] pHPClassDataArray = SerializationUtil.deserializeClassDataArray(dataInputStream);
        PHPFunctionData[] pHPFunctionDataArray = SerializationUtil.deserializeFunctionDataArray(dataInputStream);
        PHPVariablesTypeManager pHPVariablesTypeManager = SerializationUtil.deserializeVariableTypeManager(dataInputStream);
        PHPIncludeFileData[] pHPIncludeFileDataArray = SerializationUtil.deserializeIncludeDataArray(dataInputStream);
        PHPConstantData[] pHPConstantDataArray = SerializationUtil.deserializeConstantDataArray(dataInputStream);
        IPHPMarker[] iPHPMarkerArray = SerializationUtil.deserializeMarkersDataArray(dataInputStream);
        PHPBlock[] pHPBlockArray = SerializationUtil.deserializeBlockArray(dataInputStream);
        PHPDocBlock pHPDocBlock = SerializationUtil.deserializeDocBlock(dataInputStream);
        long l = dataInputStream.readLong();
        PHPFileData pHPFileData = PHPCodeDataFactory.createPHPFileData(string, userData, pHPClassDataArray, pHPFunctionDataArray, pHPVariablesTypeManager, pHPIncludeFileDataArray, pHPConstantDataArray, iPHPMarkerArray, pHPBlockArray, pHPDocBlock, l);
        int n = 0;
        while (n < pHPClassDataArray.length) {
            pHPClassDataArray[n].setContainer(pHPFileData);
            ++n;
        }
        return pHPFileData;
    }

    private static UserData deserializeUserData(DataInputStream dataInputStream) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        UserData userData = null;
        if (bl) {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            userData = PHPCodeDataFactory.createUserData(currentFileName, n, n2, n3, n4);
        }
        return userData;
    }

    private static PHPClassData[] deserializeClassDataArray(DataInputStream dataInputStream) throws IOException {
        PHPClassData[] pHPClassDataArray = new PHPClassData[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPClassDataArray.length) {
            pHPClassDataArray[n] = SerializationUtil.deserializeClassData(dataInputStream);
            ++n;
        }
        return pHPClassDataArray;
    }

    private static PHPClassData deserializeClassData(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        int n = dataInputStream.readInt();
        PHPDocBlock pHPDocBlock = SerializationUtil.deserializeDocBlock(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = SerializationUtil.deserializeSuperClass(dataInputStream);
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray = SerializationUtil.deserializeInterfacesArray(dataInputStream);
        PHPClassVarData[] pHPClassVarDataArray = SerializationUtil.deserializeClassVarDataArray(dataInputStream);
        PHPClassConstData[] pHPClassConstDataArray = SerializationUtil.deserializeClassConstArray(dataInputStream);
        PHPFunctionData[] pHPFunctionDataArray = SerializationUtil.deserializeFunctionDataArray(dataInputStream);
        PHPClassData pHPClassData = PHPCodeDataFactory.createPHPClassData(string, n, pHPDocBlock, userData, pHPSuperClassNameData, pHPInterfaceNameDataArray, pHPClassVarDataArray, pHPClassConstDataArray, pHPFunctionDataArray);
        int n2 = 0;
        while (n2 < pHPClassVarDataArray.length) {
            pHPClassVarDataArray[n2].setContainer(pHPClassData);
            ++n2;
        }
        n2 = 0;
        while (n2 < pHPClassConstDataArray.length) {
            pHPClassConstDataArray[n2].setContainer(pHPClassData);
            ++n2;
        }
        n2 = 0;
        while (n2 < pHPFunctionDataArray.length) {
            pHPFunctionDataArray[n2].setContainer(pHPClassData);
            ++n2;
        }
        return pHPClassData;
    }

    private static PHPClassConstData[] deserializeClassConstArray(DataInputStream dataInputStream) throws IOException {
        PHPClassConstData[] pHPClassConstDataArray = new PHPClassConstData[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPClassConstDataArray.length) {
            pHPClassConstDataArray[n] = SerializationUtil.deserializeClassConst(dataInputStream);
            ++n;
        }
        return pHPClassConstDataArray;
    }

    private static PHPClassConstData deserializeClassConst(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        PHPDocBlock pHPDocBlock = SerializationUtil.deserializeDocBlock(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        return PHPCodeDataFactory.createPHPClassConstData(string, pHPDocBlock, userData);
    }

    private static PHPClassVarData[] deserializeClassVarDataArray(DataInputStream dataInputStream) throws IOException {
        PHPClassVarData[] pHPClassVarDataArray = new PHPClassVarData[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPClassVarDataArray.length) {
            pHPClassVarDataArray[n] = SerializationUtil.deserializeClassVarData(dataInputStream);
            ++n;
        }
        return pHPClassVarDataArray;
    }

    private static PHPClassVarData deserializeClassVarData(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        int n = dataInputStream.readInt();
        String string2 = SerializationUtil.readString(dataInputStream);
        PHPDocBlock pHPDocBlock = SerializationUtil.deserializeDocBlock(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        return PHPCodeDataFactory.createPHPClassVarData(string, n, string2, pHPDocBlock, userData);
    }

    private static PHPClassData.PHPInterfaceNameData[] deserializeInterfacesArray(DataInputStream dataInputStream) throws IOException {
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray = new PHPClassData.PHPInterfaceNameData[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPInterfaceNameDataArray.length) {
            pHPInterfaceNameDataArray[n] = SerializationUtil.deserializeInterfaces(dataInputStream);
            ++n;
        }
        return pHPInterfaceNameDataArray;
    }

    private static PHPClassData.PHPInterfaceNameData deserializeInterfaces(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        return PHPCodeDataFactory.createPHPInterfaceNameData(string, userData);
    }

    private static PHPClassData.PHPSuperClassNameData deserializeSuperClass(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        return PHPCodeDataFactory.createPHPSuperClassNameData(string, userData);
    }

    private static PHPDocBlock deserializeDocBlock(DataInputStream dataInputStream) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        if (bl) {
            String string = SerializationUtil.readString(dataInputStream);
            String string2 = SerializationUtil.readString(dataInputStream);
            PHPDocTag[] pHPDocTagArray = SerializationUtil.deserializePHPDocTagArray(dataInputStream);
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            PHPDocBlockImp pHPDocBlockImp = new PHPDocBlockImp(string, string2, pHPDocTagArray, n);
            pHPDocBlockImp.setStartPosition(n2);
            pHPDocBlockImp.setEndPosition(n3);
            return pHPDocBlockImp;
        }
        return null;
    }

    private static PHPBlock[] deserializeBlockArray(DataInputStream dataInputStream) throws IOException {
        PHPBlock[] pHPBlockArray = new PHPBlock[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPBlockArray.length) {
            pHPBlockArray[n] = SerializationUtil.deserializeBlock(dataInputStream);
            ++n;
        }
        return pHPBlockArray;
    }

    private static PHPBlock deserializeBlock(DataInputStream dataInputStream) throws IOException {
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        UserData userData2 = SerializationUtil.deserializeUserData(dataInputStream);
        return new PHPBlock(userData, userData2);
    }

    private static IPHPMarker[] deserializeMarkersDataArray(DataInputStream dataInputStream) throws IOException {
        IPHPMarker[] iPHPMarkerArray = new IPHPMarker[dataInputStream.readInt()];
        int n = 0;
        while (n < iPHPMarkerArray.length) {
            iPHPMarkerArray[n] = SerializationUtil.deserializeMarkerData(dataInputStream);
            ++n;
        }
        return iPHPMarkerArray;
    }

    private static IPHPMarker deserializeMarkerData(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        String string2 = SerializationUtil.readString(dataInputStream);
        boolean bl = "TASK".equals(string2);
        String string3 = null;
        if (bl) {
            string3 = SerializationUtil.readString(dataInputStream);
        }
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        return bl ? new PHPTask(string3, string, userData) : new PHPMarker(string2, string, userData);
    }

    private static PHPConstantData[] deserializeConstantDataArray(DataInputStream dataInputStream) throws IOException {
        PHPConstantData[] pHPConstantDataArray = new PHPConstantData[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPConstantDataArray.length) {
            pHPConstantDataArray[n] = SerializationUtil.deserializeConstantData(dataInputStream);
            ++n;
        }
        return pHPConstantDataArray;
    }

    private static PHPConstantData deserializeConstantData(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        String string2 = SerializationUtil.readString(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        PHPDocBlock pHPDocBlock = SerializationUtil.deserializeDocBlock(dataInputStream);
        return PHPCodeDataFactory.createPHPConstantData(string, string2, userData, pHPDocBlock);
    }

    private static PHPIncludeFileData[] deserializeIncludeDataArray(DataInputStream dataInputStream) throws IOException {
        PHPIncludeFileData[] pHPIncludeFileDataArray = new PHPIncludeFileData[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPIncludeFileDataArray.length) {
            pHPIncludeFileDataArray[n] = SerializationUtil.deserializeIncludeData(dataInputStream);
            ++n;
        }
        return pHPIncludeFileDataArray;
    }

    private static PHPIncludeFileData deserializeIncludeData(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        PHPDocBlock pHPDocBlock = SerializationUtil.deserializeDocBlock(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        return PHPCodeDataFactory.createPHPIncludeFileData(string, pHPDocBlock, userData);
    }

    private static PHPVariablesTypeManager deserializeVariableTypeManager(DataInputStream dataInputStream) throws IOException {
        Object object;
        int n = dataInputStream.readInt();
        HashMap<PHPCodeContext, PHPVariableData[]> hashMap = new HashMap<PHPCodeContext, PHPVariableData[]>(n);
        int n2 = 0;
        while (n2 < n) {
            PHPCodeContext pHPCodeContext = SerializationUtil.deserializeCodeContext(dataInputStream);
            object = SerializationUtil.deserializePHPVariableDataArray(dataInputStream);
            hashMap.put(pHPCodeContext, (PHPVariableData[])object);
            ++n2;
        }
        n = dataInputStream.readInt();
        HashMap hashMap2 = new HashMap(n);
        int n3 = 0;
        while (n3 < n) {
            object = SerializationUtil.readString(dataInputStream);
            int n4 = dataInputStream.readInt();
            ArrayList<PHPVariableTypeData> arrayList = new ArrayList<PHPVariableTypeData>(n4);
            int n5 = 0;
            while (n5 < n4) {
                arrayList.add(SerializationUtil.deserializePHPVariableTypeData(dataInputStream));
                ++n5;
            }
            hashMap2.put((PHPVariableData[])object, arrayList);
            ++n3;
        }
        return VariableContextBuilder.createPHPVariablesTypeManager(hashMap, hashMap2);
    }

    private static PHPVariableTypeData deserializePHPVariableTypeData(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        boolean bl = dataInputStream.readBoolean();
        return VariableContextBuilder.createVariableTypeData(string, n, n2, bl);
    }

    private static PHPVariableData[] deserializePHPVariableDataArray(DataInputStream dataInputStream) throws IOException {
        PHPVariableData[] pHPVariableDataArray = new PHPVariableData[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPVariableDataArray.length) {
            pHPVariableDataArray[n] = SerializationUtil.deserializePHPVariableData(dataInputStream);
            ++n;
        }
        return pHPVariableDataArray;
    }

    private static PHPVariableData deserializePHPVariableData(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        boolean bl = dataInputStream.readBoolean();
        PHPDocBlock pHPDocBlock = SerializationUtil.deserializeDocBlock(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        return PHPCodeDataFactory.createPHPVariableData(string, bl, pHPDocBlock, userData);
    }

    private static PHPCodeContext deserializeCodeContext(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        String string2 = SerializationUtil.readString(dataInputStream);
        return ModelSupport.createContext(string, string2);
    }

    private static PHPFunctionData[] deserializeFunctionDataArray(DataInputStream dataInputStream) throws IOException {
        PHPFunctionData[] pHPFunctionDataArray = new PHPFunctionData[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPFunctionDataArray.length) {
            pHPFunctionDataArray[n] = SerializationUtil.deserializeFunctionData(dataInputStream);
            ++n;
        }
        return pHPFunctionDataArray;
    }

    private static PHPFunctionData deserializeFunctionData(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        int n = dataInputStream.readInt();
        PHPDocBlock pHPDocBlock = SerializationUtil.deserializeDocBlock(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = SerializationUtil.deserializeFunctionsParameterArray(dataInputStream);
        String string2 = SerializationUtil.readString(dataInputStream);
        PHPFunctionData pHPFunctionData = PHPCodeDataFactory.createPHPFuctionData(string, n, pHPDocBlock, userData, pHPFunctionParameterArray, string2);
        int n2 = 0;
        while (n2 < pHPFunctionParameterArray.length) {
            pHPFunctionParameterArray[n2].setContainer(pHPFunctionData);
            ++n2;
        }
        return pHPFunctionData;
    }

    private static PHPFunctionData.PHPFunctionParameter[] deserializeFunctionsParameterArray(DataInputStream dataInputStream) throws IOException {
        PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = new PHPFunctionData.PHPFunctionParameter[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPFunctionParameterArray.length) {
            pHPFunctionParameterArray[n] = SerializationUtil.deserializeFunctionsParameter(dataInputStream);
            ++n;
        }
        return pHPFunctionParameterArray;
    }

    private static PHPFunctionData.PHPFunctionParameter deserializeFunctionsParameter(DataInputStream dataInputStream) throws IOException {
        String string = SerializationUtil.readString(dataInputStream);
        UserData userData = SerializationUtil.deserializeUserData(dataInputStream);
        boolean bl = dataInputStream.readBoolean();
        boolean bl2 = dataInputStream.readBoolean();
        String string2 = SerializationUtil.readString(dataInputStream);
        String string3 = SerializationUtil.readString(dataInputStream);
        return PHPCodeDataFactory.createPHPFunctionParameter(string, userData, bl, bl2, string2, string3);
    }

    private static PHPDocTag[] deserializePHPDocTagArray(DataInputStream dataInputStream) throws IOException {
        PHPDocTag[] pHPDocTagArray = new PHPDocTag[dataInputStream.readInt()];
        int n = 0;
        while (n < pHPDocTagArray.length) {
            pHPDocTagArray[n] = SerializationUtil.deserializePHPDocTag(dataInputStream);
            ++n;
        }
        return pHPDocTagArray;
    }

    private static PHPDocTag deserializePHPDocTag(DataInputStream dataInputStream) throws IOException {
        BasicPHPDocTag basicPHPDocTag = new BasicPHPDocTag(dataInputStream.readInt(), SerializationUtil.readString(dataInputStream));
        return basicPHPDocTag;
    }

    private static String readString(DataInputStream dataInputStream) throws IOException {
        boolean bl = dataInputStream.readBoolean();
        if (bl) {
            return dataInputStream.readUTF();
        }
        return null;
    }

    private static void writeString(String string, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(string != null);
        if (string != null) {
            dataOutputStream.writeUTF(string);
        }
    }
}

