/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.Log;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.ResizableWizardDialog;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.wizards.RestoreFromRepositoryWizard;

public class RestoreFromRepositoryAction
extends WorkspaceTraversalAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IContainer resource = (IContainer)this.getSelectedResources()[0];
        ICVSFile[] files = this.fetchDeletedFiles(resource);
        if (files == null) {
            return;
        }
        if (files.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)CVSUIMessages.RestoreFromRepositoryAction_noFilesTitle, (String)NLS.bind((String)CVSUIMessages.RestoreFromRepositoryAction_noFilesMessage, (Object[])new String[]{resource.getName()}));
            return;
        }
        RestoreFromRepositoryWizard wizard = new RestoreFromRepositoryWizard(resource, files);
        ResizableWizardDialog dialog = new ResizableWizardDialog(this.getShell(), (IWizard)wizard);
        dialog.setMinimumPageSize(350, 250);
        dialog.open();
    }

    protected boolean isEnabled() throws TeamException {
        IResource[] resources = this.getSelectedResources();
        if (resources.length != 1) {
            return false;
        }
        if (resources[0].getType() == 1) {
            return false;
        }
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)((IContainer)resources[0]));
        return folder.isCVSFolder();
    }

    private ICVSFile[] fetchDeletedFiles(final IContainer parent) {
        final ICVSFile[][] files = new ICVSFile[1][0];
        files[0] = null;
        try {
            this.run(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)parent);
                        FolderSyncInfo info = folder.getFolderSyncInfo();
                        ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(info.getRoot());
                        files[0] = RestoreFromRepositoryAction.this.fetchFilesInAttic(location, folder, monitor);
                    }
                    catch (CVSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, true, 1);
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return files[0];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICVSFile[] fetchFilesInAttic(ICVSRepositoryLocation location, ICVSFolder parent, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        AtticLogListener listener = new AtticLogListener();
        Session session = new Session(location, parent, true);
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try {
            Command.QuietOption quietness = CVSProviderPlugin.getPlugin().getQuietness();
            try {
                CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
                IStatus status = Command.LOG.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Log.RCS_FILE_NAMES_ONLY}, new ICVSResource[]{parent}, (ICommandOutputListener)listener, Policy.subMonitorFor(monitor, 90));
                if (status.getCode() == -10) {
                    throw new CVSServerException(status);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
                throw throwable;
            }
            {
                Object var8_10 = null;
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            session.close();
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        session.close();
        return listener.getAtticFilePaths();
    }

    class AtticLogListener
    extends CommandOutputListener {
        private static final String RCS_FILE_POSTFIX = ",v";
        private static final String LOGGING_PREFIX = "Logging ";
        ICVSFolder currentFolder;
        List atticFiles = new ArrayList();

        AtticLogListener() {
        }

        public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
            int start = line.lastIndexOf("/");
            if (start != -1) {
                String fileName = line.substring(start + 1);
                if (fileName.endsWith(RCS_FILE_POSTFIX)) {
                    fileName = fileName.substring(0, fileName.length() - RCS_FILE_POSTFIX.length());
                }
                if (this.currentFolder != null) {
                    try {
                        ICVSFile file = this.currentFolder.getFile(fileName);
                        if (!file.exists()) {
                            this.atticFiles.add(file);
                        }
                    }
                    catch (CVSException e) {
                        return e.getStatus();
                    }
                }
            }
            return OK;
        }

        public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
            CVSRepositoryLocation repo = (CVSRepositoryLocation)location;
            String folderPath = repo.getServerMessageWithoutPrefix(line, "server: ");
            if (folderPath != null && folderPath.startsWith(LOGGING_PREFIX)) {
                folderPath = folderPath.substring(LOGGING_PREFIX.length());
                try {
                    this.currentFolder = commandRoot.getFolder(folderPath);
                }
                catch (CVSException e) {
                    return e.getStatus();
                }
                return OK;
            }
            return super.errorLine(line, location, commandRoot, monitor);
        }

        public ICVSFile[] getAtticFilePaths() {
            return this.atticFiles.toArray(new ICVSFile[this.atticFiles.size()]);
        }
    }
}

