/**
 * Copyright (c) 2007 Zend Technologies
 * 
 */
package lib.org.eclipse.php.test.bare.debug.core.debugger;

import java.util.Hashtable;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.php.internal.debug.core.debugger.parameters.AbstractDebugParametersInitializer;

/**
 * @author seva
 * Used to prepare a query.
 */
public class DebugParametersInitializerStub extends AbstractDebugParametersInitializer {

	static int DEFAULT_COMMUNICATION_PORT = 10000;
	private int port = DEFAULT_COMMUNICATION_PORT;

	public DebugParametersInitializerStub(int port) {
		super();
		setPort(port);
	}

	public DebugParametersInitializerStub() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.php.internal.debug.core.debugger.parameters.IDebugParametersInitializer#generateQueryParameters(org.eclipse.debug.core.ILaunch)
	 */
	public Hashtable generateQueryParameters(ILaunch launch) {
		Hashtable parameters = new Hashtable(4);
		// Start debugging
		parameters.put(START_DEBUG, "1");
		// Set debug port
		parameters.put(DEBUG_PORT, String.valueOf(port));
		// End the session after debug (?)
		parameters.put(SEND_SESS_END, "1");
		// Stop at the first line
		parameters.put(DEBUG_STOP, "1");
		return parameters;
	}

	public void setPort(int port) {
		Assert.isTrue(port > 0 && port < 1 << 16, "Port should be between 2^0 and 2^16");
		this.port = port;
	}
}
