/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.util.FileUtils;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PHPExeLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            PHPExeLaunchShortcut.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string, this.getPHPExeLaunchConfigType());
        }
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IFile iFile;
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iFile = (IFile)iEditorInput.getAdapter((Class)clazz)) != null) {
            PHPExeLaunchShortcut.searchAndLaunch(new Object[]{iFile}, string, this.getPHPExeLaunchConfigType());
        }
    }

    protected ILaunchConfigurationType getPHPExeLaunchConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        return iLaunchManager.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");
    }

    public static void searchAndLaunch(Object[] objectArray, String string, ILaunchConfigurationType iLaunchConfigurationType) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                IStatus iStatus;
                try {
                    String string2;
                    PHPexes pHPexes;
                    Object object;
                    String string3 = null;
                    iStatus = null;
                    Object object2 = objectArray[n2];
                    if (object2 instanceof PHPCodeData) {
                        object2 = PHPModelUtil.getResource((Object)object2);
                    }
                    if (object2 instanceof IFile) {
                        object = (IFile)object2;
                        iStatus = object.getProject();
                        pHPexes = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                        if (pHPexes.isAssociatedWith(object.getName())) {
                            string3 = object.getFullPath().toString();
                        }
                    }
                    if (string3 == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                    }
                    object = PHPExeLaunchShortcut.getDefaultPHPExe((IProject)iStatus);
                    pHPexes = new PHPexes();
                    pHPexes.load(PHPProjectPreferences.getModelPreferences());
                    PHPexeItem pHPexeItem = pHPexes.getItem((String)object);
                    if (pHPexeItem == null) {
                        pHPexeItem = pHPexes.getDefaultItem();
                    }
                    String string4 = string2 = pHPexeItem != null ? pHPexeItem.getPhpEXE().getAbsolutePath().toString() : null;
                    if (string2 == null) {
                        MessageDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_noexe_msg_title, (String)PHPDebugUIMessages.launch_noexe_msg_text);
                        PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)"org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage", null, null).open();
                        return;
                    }
                    ILaunchConfiguration iLaunchConfiguration = PHPExeLaunchShortcut.findLaunchConfiguration(iStatus.getName(), string3, string2, string, iLaunchConfigurationType);
                    if (iLaunchConfiguration != null) {
                        DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
                        break block10;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_config, null));
                }
                catch (CoreException coreException) {
                    iStatus = coreException.getStatus();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_exec_msg_text, (IStatus)iStatus);
                        }
                    });
                }
            }
            ++n2;
        }
    }

    private static String getDefaultPHPExe(IProject iProject) {
        IEclipsePreferences iEclipsePreferences;
        IScopeContext[] iScopeContextArray;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        String string = preferences.getString(PHPDebugCorePreferenceNames.DEFAULT_PHP);
        if (iProject != null && (iScopeContextArray = PHPExeLaunchShortcut.createPreferenceScopes(iProject))[0] instanceof ProjectScope && (iEclipsePreferences = iScopeContextArray[0].getNode(PHPProjectPreferences.getPreferenceNodeQualifier())) != null) {
            string = iEclipsePreferences.get(PHPDebugCorePreferenceNames.DEFAULT_PHP, string);
        }
        return string;
    }

    private static IScopeContext[] createPreferenceScopes(IProject iProject) {
        if (iProject != null) {
            return new IScopeContext[]{new ProjectScope(iProject), new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    protected static ILaunchConfiguration findLaunchConfiguration(String string, String string2, String string3, String string4, ILaunchConfigurationType iLaunchConfigurationType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            int n = iLaunchConfigurationArray == null ? 0 : iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string5 = iLaunchConfigurationArray[n2].getAttribute("ATTR_FILE", null);
                String string6 = iLaunchConfigurationArray[n2].getAttribute("ATTR_LOCATION", null);
                if (string2.equals(string5) && string6.equals(string3)) {
                    iLaunchConfiguration = iLaunchConfigurationArray[n2].getWorkingCopy();
                    break;
                }
                ++n2;
            }
            if (iLaunchConfiguration == null) {
                iLaunchConfiguration = PHPExeLaunchShortcut.createConfiguration(string, string2, string3, iLaunchConfigurationType);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    protected static ILaunchConfiguration createConfiguration(String string, String string2, String string3, ILaunchConfigurationType iLaunchConfigurationType) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = null;
        if (!FileUtils.fileExists((String)string2)) {
            return null;
        }
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom("New_configuration"));
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", string2);
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", string3);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
        iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        return iLaunchConfiguration;
    }
}

