/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.properties;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.sse.ui.internal.properties.RemoveAction;
import org.eclipse.wst.sse.ui.views.properties.IPropertySourceExtension;
import org.eclipse.wst.sse.ui.views.properties.PropertySheetConfiguration;

public class ConfigurablePropertySheetPage
extends PropertySheetPage {
    private static final boolean _DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/propertySheet"));
    private long _DEBUG_TIME = 0L;
    private PropertySheetConfiguration fConfiguration;
    private Object[] fSelectedEntries = null;
    private ISelection fInput = null;
    private IMenuManager fMenuManager;
    private RemoveAction fRemoveAction;
    private IStatusLineManager fStatusLineManager;
    private IToolBarManager fToolBarManager;
    private final PropertySheetConfiguration NULL_CONFIGURATION = new NullPropertySheetConfiguration();

    public void createControl(Composite parent) {
        this.setPropertySourceProvider(this.getConfiguration().getPropertySourceProvider((IPropertySheetPage)this));
        super.createControl(parent);
    }

    public void dispose() {
        this.setConfiguration(null);
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public PropertySheetConfiguration getConfiguration() {
        if (this.fConfiguration == null) {
            this.fConfiguration = this.NULL_CONFIGURATION;
        }
        return this.fConfiguration;
    }

    public void handleEntrySelection(ISelection selection) {
        if (this.getControl() != null && !this.getControl().isDisposed() && selection != null) {
            super.handleEntrySelection(selection);
            this.fSelectedEntries = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : null;
            this.fRemoveAction.setEnabled(!selection.isEmpty());
        }
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        this.fMenuManager = menuManager;
        this.fToolBarManager = toolBarManager;
        this.fStatusLineManager = statusLineManager;
        this.fRemoveAction = new RemoveAction(this);
        toolBarManager.add((IAction)this.fRemoveAction);
        menuManager.add((IAction)this.fRemoveAction);
        this.getConfiguration().addContributions(menuManager, toolBarManager, statusLineManager);
        menuManager.update(true);
    }

    void remove() {
        if (this.fSelectedEntries != null) {
            IPropertySource source;
            Object[] entries = this.fSelectedEntries;
            ISelection selection = this.fInput;
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (source = this.getConfiguration().getPropertySourceProvider((IPropertySheetPage)this).getPropertySource(((IStructuredSelection)selection).getFirstElement())) != null && source instanceof IPropertySourceExtension) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i] instanceof IPropertySheetEntry) {
                        IPropertySheetEntry entry = (IPropertySheetEntry)entries[i];
                        ((IPropertySourceExtension)source).removeProperty(entry.getDisplayName());
                    }
                    ++i;
                }
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (_DEBUG) {
            this._DEBUG_TIME = System.currentTimeMillis();
        }
        if (this.getControl() != null && this.getControl().isVisible() && !this.getControl().isFocusControl()) {
            ISelection preferredSelection = this.getConfiguration().getInputSelection(part, selection);
            if (!preferredSelection.equals(this.fInput)) {
                this.fInput = preferredSelection;
                this.fSelectedEntries = null;
                super.selectionChanged(part, preferredSelection);
            }
            if (_DEBUG) {
                System.out.println("(P:service " + (System.currentTimeMillis() - this._DEBUG_TIME) + "ms) " + part + " : " + ((IStructuredSelection)preferredSelection).getFirstElement());
            }
        } else if (_DEBUG) {
            System.out.println("[skipped] (P:" + (System.currentTimeMillis() - this._DEBUG_TIME) + "ms) " + part + " : " + selection);
        }
    }

    public void setConfiguration(PropertySheetConfiguration configuration) {
        if (this.fConfiguration != null) {
            this.fConfiguration.removeContributions(this.fMenuManager, this.fToolBarManager, this.fStatusLineManager);
            this.fConfiguration.unconfigure();
        }
        this.fConfiguration = configuration;
        if (this.fConfiguration != null) {
            this.setPropertySourceProvider(this.fConfiguration.getPropertySourceProvider((IPropertySheetPage)this));
            this.fConfiguration.addContributions(this.fMenuManager, this.fToolBarManager, this.fStatusLineManager);
        }
    }

    public void setFocus() {
        ISelectionProvider selectionProvider;
        IEditorSite editorSite;
        IEditorPart activeEditor;
        super.setFocus();
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        IWorkbenchPage activePage = workbenchWindow.getActivePage();
        if (activePage != null && (activeEditor = activePage.getActiveEditor()) != null && (editorSite = activeEditor.getEditorSite()) != null && (selectionProvider = editorSite.getSelectionProvider()) != null) {
            this.selectionChanged((IWorkbenchPart)activeEditor, selectionProvider.getSelection());
        }
    }

    private class NullPropertySheetConfiguration
    extends PropertySheetConfiguration {
        private NullPropertySheetConfiguration() {
        }

        public IPropertySourceProvider getPropertySourceProvider(IPropertySheetPage page) {
            return null;
        }
    }
}

