/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.project.observer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.internal.core.util.project.observer.CompositeProjectChangeObserver;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;

public class ProjectRemovedObserversAttacher {
    private static ProjectRemovedObserversAttacher instance;
    private Map project2CompositeProjectChangeObserver = new HashMap();
    private IResourceChangeListener resourceChangeListener;

    public static ProjectRemovedObserversAttacher getInstance() {
        if (instance == null) {
            instance = new ProjectRemovedObserversAttacher();
        }
        return instance;
    }

    private ProjectRemovedObserversAttacher() {
    }

    public boolean addProjectClosedObserver(IProject iProject, IProjectClosedObserver iProjectClosedObserver) {
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                    IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                    if (iResourceDelta == null) {
                        return;
                    }
                    IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
                    if (iResourceDeltaArray.length > 0) {
                        ProjectRemovedObserversAttacher.this.handleClosedProjects(iResourceDeltaArray);
                    } else {
                        iResourceDeltaArray = iResourceDelta.getAffectedChildren(2);
                        ProjectRemovedObserversAttacher.this.handleRemovedProjects(iResourceDeltaArray);
                    }
                }
            };
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        if (!iProject.isAccessible()) {
            return false;
        }
        CompositeProjectChangeObserver compositeProjectChangeObserver = this.getCompositeProjectChangeObserver(iProject);
        compositeProjectChangeObserver.add(iProjectClosedObserver);
        return true;
    }

    private void handleRemovedProjects(IResourceDelta[] iResourceDeltaArray) {
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            IResourceDelta iResourceDelta = iResourceDeltaArray[n];
            IResource iResource = iResourceDelta.getResource();
            IProject iProject = (IProject)iResource;
            this.notifyProjectClosed(iProject);
            ++n;
        }
    }

    private void notifyProjectClosed(IProject iProject) {
        this.getCompositeProjectChangeObserver(iProject).closed();
        this.removeCompositeProjectChangeObserver(iProject);
    }

    private void handleClosedProjects(IResourceDelta[] iResourceDeltaArray) {
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            IResourceDelta iResourceDelta = iResourceDeltaArray[n];
            IResource iResource = iResourceDelta.getResource();
            IProject iProject = (IProject)iResource;
            int n2 = iResourceDelta.getFlags();
            if ((n2 & 0x4000) != 0 && !iProject.isOpen()) {
                this.notifyProjectClosed(iProject);
            }
            ++n;
        }
    }

    private void removeCompositeProjectChangeObserver(IProject iProject) {
        CompositeProjectChangeObserver compositeProjectChangeObserver = (CompositeProjectChangeObserver)this.project2CompositeProjectChangeObserver.remove(iProject);
        compositeProjectChangeObserver.clear();
        if (this.project2CompositeProjectChangeObserver.isEmpty()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
    }

    private CompositeProjectChangeObserver getCompositeProjectChangeObserver(IProject iProject) {
        Object v = this.project2CompositeProjectChangeObserver.get(iProject);
        if (v == null) {
            CompositeProjectChangeObserver compositeProjectChangeObserver = new CompositeProjectChangeObserver();
            this.project2CompositeProjectChangeObserver.put(iProject, compositeProjectChangeObserver);
            return compositeProjectChangeObserver;
        }
        return (CompositeProjectChangeObserver)v;
    }
}

