/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.actions.OpenProjectAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.ide.IDEActionFactory;

public class ProjectActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private OpenProjectAction fOpenAction;
    private CloseResourceAction fCloseAction;

    public ProjectActionGroup(IViewPart iViewPart) {
        IStructuredSelection iStructuredSelection;
        this.fSite = iViewPart.getSite();
        Shell shell = this.fSite.getShell();
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fCloseAction = new CloseResourceAction(shell);
        this.fCloseAction.setActionDefinitionId("org.eclipse.ui.project.closeProject");
        this.fOpenAction = new OpenProjectAction(this.fSite);
        this.fOpenAction.setActionDefinitionId("org.eclipse.ui.project.openProject");
        if (iSelection instanceof IStructuredSelection) {
            iStructuredSelection = (IStructuredSelection)iSelection;
            this.fOpenAction.selectionChanged(iStructuredSelection);
            this.fCloseAction.selectionChanged(iStructuredSelection);
        }
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
        iStructuredSelection = ResourcesPlugin.getWorkspace();
        iStructuredSelection.addResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        iStructuredSelection.addResourceChangeListener((IResourceChangeListener)this.fCloseAction);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.fCloseAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.fOpenAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        if (this.fOpenAction.isEnabled()) {
            iMenuManager.appendToGroup("group.build", (IAction)this.fOpenAction);
        }
        if (this.fCloseAction.isEnabled()) {
            iMenuManager.appendToGroup("group.build", (IAction)this.fCloseAction);
        }
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpenAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fCloseAction);
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace.removeResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        iWorkspace.removeResourceChangeListener((IResourceChangeListener)this.fCloseAction);
        super.dispose();
    }
}

