/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.workingset.IWorkingSetActionGroup;
import org.eclipse.php.internal.ui.workingset.ViewAction;
import org.eclipse.php.internal.ui.workingset.ViewActionGroup;
import org.eclipse.php.internal.ui.workingset.WorkingSetFilterActionGroup;
import org.eclipse.php.internal.ui.workingset.WorkingSetModel;
import org.eclipse.php.internal.ui.workingset.WorkingSetShowActionGroup;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionGroup;

public class ExplorerViewActionGroup
extends ViewActionGroup {
    public static final int SHOW_PROJECTS = 1;
    public static final int SHOW_WORKING_SETS = 2;
    public static final String MODE_CHANGED;
    private static final Integer INT_SHOW_PROJECTS;
    private static final Integer INT_SHOW_WORKING_SETS;
    private IPropertyChangeListener fChangeListener;
    private int fMode;
    private IMenuManager fMenuManager;
    private IWorkingSetActionGroup fActiveActionGroup;
    private WorkingSetShowActionGroup fShowActionGroup;
    private WorkingSetFilterActionGroup fFilterActionGroup;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.internal.ui.workingset.ViewActionGroup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MODE_CHANGED = String.valueOf(clazz.getName()) + ".mode_changed";
        INT_SHOW_PROJECTS = new Integer(1);
        INT_SHOW_WORKING_SETS = new Integer(2);
    }

    public ExplorerViewActionGroup(int n, IPropertyChangeListener iPropertyChangeListener, IWorkbenchPartSite iWorkbenchPartSite) {
        this.fChangeListener = iPropertyChangeListener;
        this.fFilterActionGroup = new WorkingSetFilterActionGroup(iWorkbenchPartSite, iPropertyChangeListener);
        this.fShowActionGroup = new WorkingSetShowActionGroup(iWorkbenchPartSite);
        this.fMode = n;
        this.fActiveActionGroup = this.showWorkingSets() ? this.fShowActionGroup : this.fFilterActionGroup;
    }

    public void dispose() {
        this.fFilterActionGroup.dispose();
        this.fShowActionGroup.dispose();
        this.fChangeListener = null;
        super.dispose();
    }

    public void setWorkingSetModel(WorkingSetModel workingSetModel) {
        this.fShowActionGroup.setWorkingSetMode(workingSetModel);
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.fMenuManager = iActionBars.getMenuManager();
        MenuManager menuManager = new MenuManager(PHPUIMessages.ViewActionGroup_show_label);
        this.fillShowMenu((IMenuManager)menuManager);
        this.fMenuManager.add((IContributionItem)menuManager);
        this.fMenuManager.add((IContributionItem)new Separator("working_set_action_group"));
        if (this.fActiveActionGroup == null) {
            this.fActiveActionGroup = this.fFilterActionGroup;
        }
        ((ActionGroup)this.fActiveActionGroup).fillActionBars(iActionBars);
    }

    private void fillShowMenu(IMenuManager iMenuManager) {
        ViewAction viewAction = new ViewAction(this, 1);
        viewAction.setText(PHPUIMessages.ViewActionGroup_projects_label);
        iMenuManager.add((IAction)viewAction);
        ViewAction viewAction2 = new ViewAction(this, 2);
        viewAction2.setText(PHPUIMessages.ViewActionGroup_workingSets_label);
        iMenuManager.add((IAction)viewAction2);
        if (this.fMode == 1) {
            viewAction.setChecked(true);
        } else {
            viewAction2.setChecked(true);
        }
    }

    public void fillFilters(StructuredViewer structuredViewer) {
        ViewerFilter viewerFilter = this.fFilterActionGroup.getWorkingSetFilter();
        if (this.showProjects()) {
            structuredViewer.addFilter(viewerFilter);
        } else if (this.showWorkingSets()) {
            structuredViewer.removeFilter(viewerFilter);
        }
    }

    public void setMode(int n) {
        PropertyChangeEvent propertyChangeEvent;
        this.fMode = n;
        this.fActiveActionGroup.cleanViewMenu(this.fMenuManager);
        if (n == 1) {
            this.fActiveActionGroup = this.fFilterActionGroup;
            propertyChangeEvent = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_WORKING_SETS, (Object)INT_SHOW_PROJECTS);
        } else {
            this.fActiveActionGroup = this.fShowActionGroup;
            propertyChangeEvent = new PropertyChangeEvent((Object)this, MODE_CHANGED, (Object)INT_SHOW_PROJECTS, (Object)INT_SHOW_WORKING_SETS);
        }
        this.fActiveActionGroup.fillViewMenu(this.fMenuManager);
        this.fMenuManager.updateAll(true);
        this.fChangeListener.propertyChange(propertyChangeEvent);
    }

    public WorkingSetFilterActionGroup getFilterGroup() {
        return this.fFilterActionGroup;
    }

    public void restoreState(IMemento iMemento) {
        this.fFilterActionGroup.restoreState(iMemento);
    }

    public void saveState(IMemento iMemento) {
        this.fFilterActionGroup.saveState(iMemento);
    }

    private boolean showProjects() {
        return this.fMode == 1;
    }

    private boolean showWorkingSets() {
        return this.fMode == 2;
    }
}

