/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.internal.debug.ui.preferences.phps.ShowPHPsPreferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class PHPsComboBlock
implements ISelectionProvider {
    PHPexes exes;
    private Combo fCombo;
    private Composite fControl;
    private PHPexeDescriptor fDefaultDescriptor = null;
    private ISelection fPrevSelection = new StructuredSelection();
    private final ListenerList fSelectionListeners = new ListenerList();
    private String fTitle = null;
    private final List phpExecutables = new ArrayList();

    public PHPsComboBlock() {
        this.fDefaultDescriptor = new PHPexeDescriptor(){

            public String getDescription() {
                PHPexeItem pHPexeItem = PHPsComboBlock.this.getPHPs(true).getDefaultItem();
                if (pHPexeItem != null) {
                    return String.valueOf(pHPexeItem.getName()) + " (" + pHPexeItem.getPhpEXE().toString() + ")";
                }
                return "No PHP exes defined";
            }
        };
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.add((Object)iSelectionChangedListener);
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        this.fControl = group;
        if (this.fTitle == null) {
            this.fTitle = PHPDebugUIMessages.PHPexesComboBlock_3;
        }
        group.setText(this.fTitle);
        this.fCombo = new Combo((Composite)group, 12);
        this.fCombo.setFont(font);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fCombo.setLayoutData((Object)gridData);
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPsComboBlock.this.setPHPexe(PHPsComboBlock.this.getPHPexe());
            }
        });
        Link link = new Link((Composite)group, 0);
        link.setFont(font);
        gridData = new GridData(1, 1024, true, false);
        gridData.horizontalSpan = 1;
        link.setLayoutData((Object)gridData);
        link.setText(PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPexeItem pHPexeItem = PHPsComboBlock.this.getPHPexe();
                new ShowPHPsPreferences().run(null);
                PHPsComboBlock.this.fillWithWorkspacePHPexes();
                if (PHPsComboBlock.this.phpExecutables.contains(pHPexeItem)) {
                    String string = String.valueOf(pHPexeItem.getName()) + " (" + pHPexeItem.getPhpEXE().toString() + ")";
                    PHPsComboBlock.this.fCombo.select(PHPsComboBlock.this.fCombo.indexOf(string));
                }
            }
        });
        if (this.getPHPs(true).getDefaultItem() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPDebugUIMessages.PHPsComboBlock_NoPHPsTitle, (String)PHPDebugUIMessages.PHPsComboBlock_noPHPsMessage);
            new ShowPHPsPreferences().run(null);
        }
        this.fillWithWorkspacePHPexes();
    }

    protected void fillWithWorkspacePHPexes() {
        ArrayList<PHPexeItem> arrayList = new ArrayList<PHPexeItem>();
        PHPexeItem[] pHPexeItemArray = this.getPHPs(true).getItems();
        int n = 0;
        while (n < pHPexeItemArray.length) {
            PHPexeItem pHPexeItem = pHPexeItemArray[n];
            arrayList.add(pHPexeItem);
            ++n;
        }
        this.setPHPexes(arrayList);
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = this.fSelectionListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ISelectionChangedListener iSelectionChangedListener = (ISelectionChangedListener)objectArray[n];
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
            ++n;
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    public PHPexeItem getPHPexe() {
        int n = this.fCombo.getSelectionIndex();
        if (n >= 0) {
            return (PHPexeItem)this.phpExecutables.get(n);
        }
        return null;
    }

    public PHPexeItem[] getPHPexes() {
        return this.phpExecutables.toArray(new PHPexeItem[this.phpExecutables.size()]);
    }

    public PHPexes getPHPs(boolean bl) {
        if (this.exes == null || bl) {
            this.exes = new PHPexes();
            this.exes.load(PHPProjectPreferences.getModelPreferences());
        }
        return this.exes;
    }

    public String getSelectedLocation() {
        PHPexeItem pHPexeItem = this.getPHPexe();
        if (pHPexeItem != null) {
            return pHPexeItem.getPhpEXE().toString();
        }
        return "";
    }

    public ISelection getSelection() {
        PHPexeItem pHPexeItem = this.getPHPexe();
        if (pHPexeItem == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)pHPexeItem);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.remove((Object)iSelectionChangedListener);
    }

    public void setPHPexe(PHPexeItem pHPexeItem) {
        if (pHPexeItem == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)pHPexeItem));
        }
    }

    protected void setPHPexes(List list) {
        PHPexeItem pHPexeItem;
        PHPexeItem pHPexeItem2;
        this.phpExecutables.clear();
        this.phpExecutables.addAll(list);
        Collections.sort(this.phpExecutables, new Comparator(){

            public int compare(Object object, Object object2) {
                PHPexeItem pHPexeItem = (PHPexeItem)object;
                PHPexeItem pHPexeItem2 = (PHPexeItem)object2;
                return pHPexeItem.getName().compareToIgnoreCase(pHPexeItem2.getName());
            }

            public boolean equals(Object object) {
                return object == this;
            }
        });
        String[] stringArray = new String[this.phpExecutables.size()];
        Iterator iterator = this.phpExecutables.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            pHPexeItem2 = (PHPexeItem)iterator.next();
            stringArray[n] = String.valueOf(pHPexeItem2.getName()) + " (" + pHPexeItem2.getPhpEXE().toString() + ")";
            ++n;
        }
        this.fCombo.setItems(stringArray);
        pHPexeItem2 = this.getPHPs(false);
        if (pHPexeItem2 == null) {
            pHPexeItem2 = this.getPHPs(true);
        }
        if ((pHPexeItem = pHPexeItem2.getDefaultItem()) != null) {
            String string = String.valueOf(pHPexeItem.getName()) + " (" + pHPexeItem.getPhpEXE().toString() + ")";
            this.fCombo.select(this.fCombo.indexOf(string));
        }
    }

    public void setSelection(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection && !iSelection.equals(this.fPrevSelection)) {
            this.fPrevSelection = iSelection;
            if (iSelection.isEmpty()) {
                this.fCombo.setText("");
                this.fCombo.select(-1);
                this.fCombo.setItems(new String[0]);
                this.fillWithWorkspacePHPexes();
            } else {
                Object object = ((IStructuredSelection)iSelection).getFirstElement();
                int n = this.phpExecutables.indexOf(object);
                if (n >= 0) {
                    this.fCombo.select(n);
                }
            }
            this.fireSelectionChanged();
        }
    }

    public void setTitle(String string) {
        this.fTitle = string;
    }

    public void setUseDefaultPHPexe() {
        if (this.fDefaultDescriptor != null && this.fControl != null) {
            this.fPrevSelection = null;
            this.fireSelectionChanged();
        }
    }
}

