/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerInitializer;
import org.eclipse.php.internal.debug.core.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.debugger.PHPWebServerDebuggerInitializer;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.launching.PHPServerLaunchDecorator;
import org.eclipse.php.internal.debug.core.model.DebugSessionIdGenerator;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.deploy.DeployFilter;
import org.eclipse.php.internal.server.core.deploy.FileUtil;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPWebPageLaunchDelegate
extends LaunchConfigurationDelegate {
    private ILaunch launch;
    private Job runDispatch;
    protected IDebuggerInitializer debuggerInitializer = this.createDebuggerInitilizer();

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!PHPLaunchUtilities.notifyPreviousLaunches(iLaunch)) {
            iProgressMonitor.setCanceled(true);
            iProgressMonitor.done();
            return;
        }
        if (!PHPLaunchUtilities.checkDebugAllPages(iLaunchConfiguration, iLaunch)) {
            iProgressMonitor.setCanceled(true);
            iProgressMonitor.done();
            return;
        }
        PHPLaunchUtilities.showDebugView();
        boolean bl = iLaunchConfiguration.getAttribute("run_with_debug", true);
        this.launch = iLaunch;
        if (string.equals("run") && !bl) {
            this.runWithoutDebug(iLaunchConfiguration, string, iLaunch, iProgressMonitor);
            return;
        }
        Server server = ServersManager.getServer((String)iLaunchConfiguration.getAttribute("name", ""));
        if (server == null) {
            Logger.log(4, "Launch configuration could not find server");
            this.terminated();
            return;
        }
        String string2 = iLaunchConfiguration.getAttribute("file_name", null);
        Path path = new Path(string2);
        IProject iProject = null;
        try {
            iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        }
        catch (Throwable throwable) {}
        if (iProject == null) {
            Logger.log(4, "Could not execute the debug (Project is null).");
            return;
        }
        boolean bl2 = iLaunchConfiguration.getAttribute("publish", false);
        if (bl2 && !FileUtil.publish((Server)server, (IProject)iProject, (ILaunchConfiguration)iLaunchConfiguration, (Map)DeployFilter.getFilterMap(), (IProgressMonitor)iProgressMonitor)) {
            this.terminated();
            return;
        }
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.getWorkingCopy();
        String string3 = iProject.getFullPath().toString();
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.PHP_Project", string3);
        iLaunchConfigurationWorkingCopy.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(iProject));
        iLaunchConfigurationWorkingCopy.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(iProject));
        iLaunchConfigurationWorkingCopy.doSave();
        String string4 = new String(iLaunchConfiguration.getAttribute("base_url", "").getBytes());
        if (string.equals("debug") || bl) {
            boolean bl3 = false;
            bl3 = iLaunchConfigurationWorkingCopy.getAttribute("overrideFirstLineBreakpoint", false) ? iLaunchConfigurationWorkingCopy.getAttribute("firstLineBreakpoint", false) : PHPProjectPreferences.getStopAtFirstLine(iProject);
            int n = PHPProjectPreferences.getDebugPort(iProject);
            int n2 = DebugSessionIdGenerator.generateSessionID();
            PHPSessionLaunchMapper.put(n2, new PHPServerLaunchDecorator(iLaunch, iProject));
            iLaunch.setAttribute("port", Integer.toString(n));
            iLaunch.setAttribute("webServerDebugger", Boolean.toString(true));
            iLaunch.setAttribute("firstLineBreakpoint", Boolean.toString(bl3));
            iLaunch.setAttribute("uriginalURL", string4);
            iLaunch.setAttribute("debugSessionID", Integer.toString(n2));
            this.runDispatch = new RunDispatchJobWebServer(iLaunch);
            this.runDispatch.schedule();
        }
    }

    public void runWithoutDebug(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        Server server = ServersManager.getServer((String)iLaunchConfiguration.getAttribute("name", ""));
        if (server == null) {
            Logger.log(4, "Launch configuration could not find server");
            return;
        }
        String string2 = iLaunchConfiguration.getAttribute("file_name", null);
        Path path = new Path(string2);
        IProject iProject = null;
        try {
            iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        }
        catch (Throwable throwable) {}
        if (iProject == null) {
            Logger.log(4, "Could not launch (Project is null).");
            return;
        }
        boolean bl = iLaunchConfiguration.getAttribute("publish", false);
        if (bl && !FileUtil.publish((Server)server, (IProject)iProject, (ILaunchConfiguration)iLaunchConfiguration, (Map)DeployFilter.getFilterMap(), (IProgressMonitor)iProgressMonitor)) {
            return;
        }
    }

    protected void initiateDebug(ILaunch iLaunch) {
        try {
            this.debuggerInitializer.debug(iLaunch);
        }
        catch (DebugException debugException) {
            IStatus iStatus = debugException.getStatus();
            String string = null;
            if (iStatus == null) {
                Logger.traceException("Unexpected Error return from debuggerInitializer ", debugException);
                this.fireError(PHPDebugCoreMessages.Debugger_Unexpected_Error_1, (Exception)((Object)debugException));
                string = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
            } else {
                this.fireError(iStatus);
                string = iStatus.getMessage();
            }
            this.displayErrorMessage(string);
        }
    }

    protected IDebuggerInitializer createDebuggerInitilizer() {
        return new PHPWebServerDebuggerInitializer();
    }

    protected void displayErrorMessage(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug Error", (String)string);
            }
        });
    }

    public void fireError(IStatus iStatus) {
        DebugEvent debugEvent = new DebugEvent((Object)this, 32);
        debugEvent.setData((Object)iStatus);
        this.fireEvent(debugEvent);
    }

    public void fireError(String string, Exception exception) {
        Status status = new Status(4, PHPDebugPlugin.getID(), 150, string, (Throwable)exception);
        DebugEvent debugEvent = new DebugEvent((Object)this, 32);
        debugEvent.setData((Object)status);
        this.fireEvent(debugEvent);
    }

    public void terminated() {
        DebugEvent debugEvent = null;
        if (this.launch.getDebugTarget() == null) {
            DummyDebugTarget dummyDebugTarget = new DummyDebugTarget(this.launch);
            debugEvent = new DebugEvent((Object)dummyDebugTarget, 8);
            if (this.launch != null) {
                this.launch.addDebugTarget((IDebugTarget)dummyDebugTarget);
                IDebugEventSetListener iDebugEventSetListener = (IDebugEventSetListener)this.launch;
                iDebugEventSetListener.handleDebugEvents(new DebugEvent[]{debugEvent});
            }
        }
        debugEvent = new DebugEvent((Object)this, 8);
        this.fireEvent(debugEvent);
    }

    public void fireEvent(DebugEvent debugEvent) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
    }

    private class DummyDebugTarget
    implements IDebugTarget {
        private ILaunch launch;

        public DummyDebugTarget(ILaunch iLaunch) {
            this.launch = iLaunch;
        }

        public String getName() throws DebugException {
            return "Session Terminated";
        }

        public IProcess getProcess() {
            return null;
        }

        public IThread[] getThreads() throws DebugException {
            return null;
        }

        public boolean hasThreads() throws DebugException {
            return false;
        }

        public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return this;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        public String getModelIdentifier() {
            return "";
        }

        public Object getAdapter(Class clazz) {
            return null;
        }

        public boolean canTerminate() {
            return true;
        }

        public boolean isTerminated() {
            return true;
        }

        public void terminate() throws DebugException {
        }

        public boolean canResume() {
            return false;
        }

        public boolean canSuspend() {
            return false;
        }

        public boolean isSuspended() {
            return false;
        }

        public void resume() throws DebugException {
        }

        public void suspend() throws DebugException {
        }

        public void breakpointAdded(IBreakpoint iBreakpoint) {
        }

        public void breakpointChanged(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        }

        public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        }

        public boolean canDisconnect() {
            return false;
        }

        public void disconnect() throws DebugException {
        }

        public boolean isDisconnected() {
            return false;
        }

        public IMemoryBlock getMemoryBlock(long l, long l2) throws DebugException {
            return null;
        }

        public boolean supportsStorageRetrieval() {
            return false;
        }
    }

    class RunDispatchJobWebServer
    extends Job {
        private ILaunch launch;

        public RunDispatchJobWebServer(ILaunch iLaunch) {
            super("runPHPWebServer");
            this.launch = iLaunch;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            PHPWebPageLaunchDelegate.this.initiateDebug(this.launch);
            Logger.debugMSG("[" + (Object)((Object)this) + "] PHPDebugTarget: Calling Terminated()");
            PHPWebPageLaunchDelegate.this.terminated();
            return Status.OK_STATUS;
        }

        public String toString() {
            String string = ((Object)((Object)this)).getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            return String.valueOf(string) + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        }
    }
}

