/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ICache;
import org.eclipse.team.core.ICacheListener;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.CVSModelProviderAction;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class WorkspaceCommitAction
extends CVSModelProviderAction
implements IDiffChangeListener {
    public WorkspaceCommitAction(ISynchronizePageConfiguration configuration) {
        super(configuration);
        final IDiffTree tree = this.getDiffTree();
        tree.addDiffChangeListener((IDiffChangeListener)this);
        this.getSynchronizationContext().getCache().addCacheListener(new ICacheListener(){

            public void cacheDisposed(ICache cache) {
                tree.removeDiffChangeListener((IDiffChangeListener)WorkspaceCommitAction.this);
            }
        });
        this.updateEnablement();
    }

    protected String getBundleKeyPrefix() {
        return "WorkspaceToolbarCommitAction.";
    }

    private IDiffTree getDiffTree() {
        ISynchronizationContext context = (ISynchronizationContext)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
        IResourceDiffTree tree = context.getDiffTree();
        return tree;
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        return this.isEnabled();
    }

    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        this.updateEnablement();
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }

    public void updateEnablement() {
        boolean enabled = this.getDiffTree().countFor(256, 768) > 0L && this.getDiffTree().countFor(768, 768) == 0L;
        this.setEnabled(enabled);
    }

    public void execute() {
        ISynchronizationContext context = (ISynchronizationContext)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
        ResourceTraversal[] traversals = context.getScope().getTraversals();
        Shell shell = this.getConfiguration().getSite().getShell();
        try {
            CommitWizard.run(this.getConfiguration().getSite().getPart(), shell, traversals);
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
    }

    protected IResource[] getTargetResources() {
        return this.getSynchronizationContext().getScope().getRoots();
    }
}

