/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameCompilationUnitChange
extends AbstractJavaElementRenameChange {
    public RenameCompilationUnitChange(RefactoringDescriptor descriptor, ICompilationUnit unit, String newName, String comment) {
        this(descriptor, ResourceUtil.getResource(unit).getFullPath(), unit.getElementName(), newName, comment, -1L);
        Assert.isTrue((!unit.isReadOnly() ? 1 : 0) != 0, (String)"compilation unit must not be read-only");
    }

    private RenameCompilationUnitChange(RefactoringDescriptor descriptor, IPath resourcePath, String oldName, String newName, String comment, long stampToRestore) {
        super(descriptor, resourcePath, oldName, newName, comment, stampToRestore);
    }

    protected IPath createNewPath() {
        if (this.getResourcePath().getFileExtension() != null) {
            return this.getResourcePath().removeFileExtension().removeLastSegments(1).append(this.getNewName());
        }
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    protected Change createUndoChange(long stampToRestore) throws JavaModelException {
        return new RenameCompilationUnitChange(null, this.createNewPath(), this.getNewName(), this.getOldName(), this.getComment(), stampToRestore);
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        ICompilationUnit cu = (ICompilationUnit)this.getModifiedElement();
        if (cu != null) {
            cu.rename(this.getNewName(), false, pm);
        }
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_name, new String[]{this.getOldName(), this.getNewName()});
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 7);
    }
}

