/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class TreeAndListGroup
implements ISelectionChangedListener {
    private Object root;
    private Object currentTreeSelection;
    private List selectionChangedListeners = new ArrayList();
    private List doubleClickListeners = new ArrayList();
    private ITreeContentProvider treeContentProvider;
    private IStructuredContentProvider listContentProvider;
    private ILabelProvider treeLabelProvider;
    private ILabelProvider listLabelProvider;
    private TreeViewer treeViewer;
    private TableViewer listViewer;
    private boolean allowMultiselection = false;

    public TreeAndListGroup(Composite composite, Object object, ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider, IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider2, int n, int n2, int n3, boolean bl) {
        this.root = object;
        this.treeContentProvider = iTreeContentProvider;
        this.listContentProvider = iStructuredContentProvider;
        this.treeLabelProvider = iLabelProvider;
        this.listLabelProvider = iLabelProvider2;
        this.allowMultiselection = bl;
        this.createContents(composite, n2, n3, n);
    }

    public void aboutToOpen() {
        Object object;
        this.currentTreeSelection = null;
        Object[] objectArray = this.treeContentProvider.getElements(this.root);
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : null;
        if (object != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
        this.treeViewer.getControl().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add(iSelectionChangedListener);
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.doubleClickListeners.add(iDoubleClickListener);
    }

    protected void notifySelectionListeners(SelectionChangedEvent selectionChangedEvent) {
        Iterator iterator = this.selectionChangedListeners.iterator();
        while (iterator.hasNext()) {
            ((ISelectionChangedListener)iterator.next()).selectionChanged(selectionChangedEvent);
        }
    }

    protected void notifyDoubleClickListeners(DoubleClickEvent doubleClickEvent) {
        Iterator iterator = this.doubleClickListeners.iterator();
        while (iterator.hasNext()) {
            ((IDoubleClickListener)iterator.next()).doubleClick(doubleClickEvent);
        }
    }

    protected void createContents(Composite composite, int n, int n2, int n3) {
        Composite composite2 = new Composite(composite, n3);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite2, n / 2, n2);
        this.createListViewer(composite2, n / 2, n2);
        this.initialize();
    }

    protected void createListViewer(Composite composite, int n, int n2) {
        int n3 = this.allowMultiselection ? 2 : 4;
        this.listViewer = new TableViewer(composite, 0x800 | n3);
        GridData gridData = new GridData(1808);
        gridData.widthHint = n;
        gridData.heightHint = n2;
        this.listViewer.getTable().setLayoutData((Object)gridData);
        this.listViewer.getTable().setFont(composite.getFont());
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.listLabelProvider);
        this.listViewer.setSorter((ViewerSorter)new ResourceSorter(1));
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TreeAndListGroup.this.notifySelectionListeners(selectionChangedEvent);
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                if (!doubleClickEvent.getSelection().isEmpty()) {
                    TreeAndListGroup.this.notifyDoubleClickListeners(doubleClickEvent);
                }
            }
        });
    }

    protected void createTreeViewer(Composite composite, int n, int n2) {
        Tree tree = new Tree(composite, 2048);
        GridData gridData = new GridData(1808);
        gridData.widthHint = n;
        gridData.heightHint = n2;
        tree.setLayoutData((Object)gridData);
        tree.setFont(composite.getFont());
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.treeLabelProvider);
        this.treeViewer.setSorter((ViewerSorter)new ResourceSorter(1));
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public Table getListTable() {
        return this.listViewer.getTable();
    }

    public IStructuredSelection getListTableSelection() {
        ISelection iSelection = this.listViewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return StructuredSelection.EMPTY;
    }

    protected void initialListItem(Object object) {
        Object object2 = this.treeContentProvider.getParent(object);
        this.selectAndRevealFolder(object2);
    }

    public void selectAndRevealFolder(Object object) {
        this.treeViewer.reveal(object);
        StructuredSelection structuredSelection = new StructuredSelection(object);
        this.treeViewer.setSelection((ISelection)structuredSelection);
    }

    public void selectAndRevealFile(Object object) {
        this.listViewer.reveal(object);
        StructuredSelection structuredSelection = new StructuredSelection(object);
        this.listViewer.setSelection((ISelection)structuredSelection);
    }

    protected void initialize() {
        this.treeViewer.setInput(this.root);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object == null) {
            this.currentTreeSelection = null;
            this.listViewer.setInput(this.currentTreeSelection);
            return;
        }
        if (object != this.currentTreeSelection) {
            this.listViewer.setInput(object);
        }
        this.currentTreeSelection = object;
    }

    public void setListProviders(IStructuredContentProvider iStructuredContentProvider, ILabelProvider iLabelProvider) {
        this.listViewer.setContentProvider((IContentProvider)iStructuredContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)iLabelProvider);
    }

    public void setListSorter(ViewerSorter viewerSorter) {
        this.listViewer.setSorter(viewerSorter);
    }

    public void setRoot(Object object) {
        this.root = object;
        this.initialize();
    }

    public void setTreeProviders(ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider) {
        this.treeViewer.setContentProvider((IContentProvider)iTreeContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)iLabelProvider);
    }

    public void setTreeSorter(ViewerSorter viewerSorter) {
        this.treeViewer.setSorter(viewerSorter);
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }
}

