/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.util.CodeDataResolver;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.ExternalFileHyperlink;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.WorkspaceFileHyperlink;
import org.eclipse.php.internal.ui.editor.hover.PHPCodeHyperLink;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.ui.editor.hover.IHyperlinkDetectorForPHP;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPCodeHyperlinkDetector
implements IHyperlinkDetectorForPHP {
    private static final Pattern QUOTES_PATTERN = Pattern.compile("^[\"']|[\"']$");

    private boolean isIncludeType(String string) {
        return "PHP_INCLUDE".equals(string) || "PHP_INCLUDE_ONCE".equals(string) || "PHP_REQUIRE".equals(string) || "PHP_REQUIRE_ONCE".equals(string);
    }

    public IHyperlink[] detectHyperlinks(ITextViewer iTextViewer, IRegion iRegion, boolean bl) {
        if (iRegion == null || bl) {
            return null;
        }
        try {
            IDocument iDocument = iTextViewer.getDocument();
            if (iDocument instanceof IStructuredDocument) {
                IStructuredDocument iStructuredDocument = (IStructuredDocument)iDocument;
                IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(iRegion.getOffset());
                ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(iRegion.getOffset());
                IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
                if (iTextRegion instanceof ITextRegionContainer) {
                    iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion;
                    iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(iRegion.getOffset());
                }
                if (iTextRegion.getType() == "PHP_CONTENT") {
                    PhpScriptRegion phpScriptRegion = (PhpScriptRegion)iTextRegion;
                    ITextRegion iTextRegion2 = phpScriptRegion.getPhpToken(iRegion.getOffset() - iStructuredDocumentRegion2.getStartOffset() - phpScriptRegion.getStart());
                    if (PHPPartitionTypes.isPHPQuotesState((String)iTextRegion2.getType())) {
                        ITextRegion iTextRegion3 = phpScriptRegion.getPhpToken(iTextRegion2.getStart() - 1);
                        if (iTextRegion3 != null && (iTextRegion3 = phpScriptRegion.getPhpToken(iTextRegion3.getStart() - 1)) != null && this.isIncludeType(iTextRegion3.getType())) {
                            IFile iFile;
                            IProject iProject;
                            IFile iFile2;
                            IWorkspace iWorkspace;
                            Object object;
                            int n = iStructuredDocumentRegion2.getStartOffset() + phpScriptRegion.getStart() + iTextRegion2.getStart();
                            int n2 = iTextRegion2.getLength();
                            String string = iStructuredDocument.get(n, n2);
                            Matcher matcher = QUOTES_PATTERN.matcher(string);
                            string = matcher.replaceAll("");
                            Path path = new Path(string);
                            IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
                            if (iWorkbenchPage != null && (object = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)(iWorkspace = iWorkbenchPage.getActiveEditor()))) != null && (iFile2 = (iProject = (iFile = ((PHPStructuredEditor)((Object)object)).getFile()).getProject()).getFile((IPath)path)) != null && iFile2.exists()) {
                                return new IHyperlink[]{new WorkspaceFileHyperlink((IRegion)new Region(n, n2), iFile2)};
                            }
                            iWorkspace = ResourcesPlugin.getWorkspace();
                            object = iWorkspace.getRoot();
                            iFile = object.getProjects();
                            int n3 = 0;
                            while (n3 < ((IFile)iFile).length) {
                                iFile2 = iFile[n3].getFile((IPath)path);
                                if (iFile2 != null && iFile2.exists()) {
                                    return new IHyperlink[]{new WorkspaceFileHyperlink((IRegion)new Region(n, n2), iFile2)};
                                }
                                ++n3;
                            }
                            File file = new File(string);
                            if (file.exists()) {
                                return new IHyperlink[]{new ExternalFileHyperlink((IRegion)new Region(n, n2), file)};
                            }
                        }
                    } else {
                        CodeData[] codeDataArray = CodeDataResolver.getInstance().resolve(iStructuredDocument, iRegion.getOffset());
                        if (codeDataArray != null && codeDataArray.length != 0) {
                            return new IHyperlink[]{new PHPCodeHyperLink(this.selectWord(iDocument, iRegion.getOffset()), codeDataArray)};
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private IRegion selectWord(IDocument iDocument, int n) {
        try {
            char c;
            int n2 = n;
            while (n2 >= 0) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c)) break;
                --n2;
            }
            int n3 = n2;
            n2 = n;
            int n4 = iDocument.getLength();
            while (n2 < n4) {
                c = iDocument.getChar(n2);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++n2;
            }
            int n5 = n2;
            if (n3 == n5) {
                return new Region(n3, 0);
            }
            return new Region(n3 + 1, n5 - n3 - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

