/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger.parameters;

import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.php.internal.core.util.HostsCollector;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.parameters.AbstractDebugParametersInitializer;

public class DefaultDebugParametersInitializer
extends AbstractDebugParametersInitializer {
    public Hashtable generateQueryParameters(ILaunch iLaunch) {
        String string;
        ILaunchConfiguration iLaunchConfiguration;
        String string2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("start_debug=", "1");
        String string3 = iLaunch.getAttribute("port");
        if (string3 != null) {
            hashtable.put("debug_port=", string3);
        } else {
            PHPDebugPlugin.logErrorMessage("A port was not defined for the DefaultDebugParametersInitializer.");
        }
        if (this.getBooleanValue(iLaunch.getAttribute("passiveDebug"))) {
            hashtable.put("debug_passive=", "1");
        }
        hashtable.put("send_sess_end=", "1");
        if (this.getBooleanValue(iLaunch.getAttribute("webServerDebugger"))) {
            hashtable.put("debug_host=", HostsCollector.getHosts());
            hashtable.put("debug_no_cache=", Long.toString(System.currentTimeMillis()));
        }
        if ("debug".equals(iLaunch.getLaunchMode()) && this.getBooleanValue(iLaunch.getAttribute("firstLineBreakpoint"))) {
            hashtable.put("debug_stop=", "1");
        }
        if ((string2 = iLaunch.getAttribute("uriginalURL")) != null) {
            hashtable.put("original_url=", string2);
        }
        if ((iLaunchConfiguration = iLaunch.getLaunchConfiguration()) != null) {
            try {
                string = iLaunchConfiguration.getAttribute("debugPages", "debugAllPages");
                if ("debugAllPages".equals(string)) {
                    hashtable.put("debug_start_session=", "1");
                } else if ("debugFirstPage".equals(string)) {
                    hashtable.put("debug_new_session=", "1");
                } else if ("debugFrom".equals(string)) {
                    hashtable.put("debug_start_url=", iLaunchConfiguration.getAttribute("debugContinue", ""));
                    if (iLaunchConfiguration.getAttribute("debugFromURL", false)) {
                        hashtable.put("debug_cont_session=", "1");
                    }
                }
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
        }
        if ((string = iLaunch.getAttribute("debugSessionID")) != null) {
            hashtable.put("debug_session_id=", string);
        }
        return hashtable;
    }

    public String getRequestURL(ILaunch iLaunch) {
        String string = iLaunch.getAttribute("uriginalURL");
        return string != null ? string.trim() : "";
    }

    public boolean getBooleanValue(String string) {
        if (string != null) {
            return Boolean.valueOf(string);
        }
        return false;
    }
}

