/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.util.ArrayList;

public class BlockingQueue {
    static Object emptyObject = new Object();
    private ArrayList content;
    private boolean releaseFlag = false;

    public BlockingQueue() {
        this(100);
    }

    public BlockingQueue(int n) {
        this.content = new ArrayList(n);
    }

    public synchronized void queueIn(Object object) {
        this.content.add(object);
        this.notify();
    }

    public synchronized Object queueOut() throws InterruptedException {
        return this.queueOut(0L);
    }

    public synchronized Object queueOut(long l) throws InterruptedException {
        this.releaseFlag = false;
        Object object = emptyObject;
        do {
            if (this.content.isEmpty()) {
                this.wait(l);
                if (this.releaseFlag) {
                    throw new InterruptedException();
                }
            }
            if (this.content.isEmpty()) continue;
            object = this.content.remove(0);
        } while (object == emptyObject);
        return object;
    }

    public synchronized boolean isEmpty() {
        return this.content.isEmpty();
    }

    public synchronized void releaseReaders() {
        this.releaseFlag = true;
        this.notifyAll();
    }

    public synchronized void clear() {
        this.content.clear();
    }

    public synchronized boolean remove(Object object) {
        int n = this.content.indexOf(object);
        if (n > -1) {
            this.content.set(n, emptyObject);
            return true;
        }
        return false;
    }

    public synchronized boolean moveToFront(Object object) {
        boolean bl = this.content.remove(object);
        if (bl) {
            this.content.add(0, object);
        }
        return bl;
    }

    public synchronized boolean contains(Object object) {
        return this.content.contains(object);
    }

    public synchronized Object top() {
        Object var1_1 = this.content.isEmpty() ? null : this.content.get(0);
        return var1_1;
    }

    public synchronized Object tail() {
        int n = this.content.size();
        Object var2_2 = n == 0 ? null : this.content.get(n - 1);
        return var2_2;
    }
}

