/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class RenamePHPElementAction
extends SelectionDispatchAction {
    protected PHPStructuredEditor fEditor;

    public RenamePHPElementAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
    }

    public RenamePHPElementAction(PHPStructuredEditor pHPStructuredEditor) {
        this((IWorkbenchSite)pHPStructuredEditor.getEditorSite());
        this.fEditor = pHPStructuredEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            if (iStructuredSelection.size() == 1) {
                this.setEnabled(RenamePHPElementAction.canEnable(iStructuredSelection));
                return;
            }
        }
        catch (CoreException coreException) {
            PHPUiPlugin.log(coreException);
        }
        this.setEnabled(false);
    }

    private static boolean canEnable(IStructuredSelection iStructuredSelection) throws CoreException {
        PHPCodeData pHPCodeData = RenamePHPElementAction.getPHPElement(iStructuredSelection);
        if (pHPCodeData == null) {
            return false;
        }
        return RenamePHPElementAction.isRenameAvailable(pHPCodeData);
    }

    private static PHPCodeData getPHPElement(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof PHPCodeData)) {
            return null;
        }
        return (PHPCodeData)object;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        PHPCodeData pHPCodeData = RenamePHPElementAction.getPHPElement(iStructuredSelection);
        if (pHPCodeData == null) {
            return;
        }
        try {
            this.run(pHPCodeData);
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, PHPUIMessages.RenamePHPElementAction_name, PHPUIMessages.RenamePHPElementAction_exception);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void run(ITextSelection iTextSelection) {
        try {
            PHPCodeData pHPCodeData = this.getPHPElement();
            if (pHPCodeData != null && RenamePHPElementAction.isRenameAvailable(pHPCodeData)) {
                this.run(pHPCodeData);
                return;
            }
        }
        catch (CoreException coreException) {
            ExceptionHandler.handle(coreException, PHPUIMessages.RenamePHPElementAction_name, PHPUIMessages.RenamePHPElementAction_exception);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)PHPUIMessages.RenamePHPElementAction_name, (String)PHPUIMessages.RenamePHPElementAction_not_available);
    }

    public boolean canRun() {
        PHPCodeData pHPCodeData = this.getPHPElement();
        if (pHPCodeData == null) {
            return false;
        }
        try {
            return RenamePHPElementAction.isRenameAvailable(pHPCodeData);
        }
        catch (CoreException coreException) {
            PHPUiPlugin.log(coreException);
            return false;
        }
    }

    private PHPCodeData getPHPElement() {
        PHPCodeData[] pHPCodeDataArray = SelectionConverter.codeResolveHandled(this.fEditor, this.getShell(), PHPUIMessages.RenamePHPElementAction_name);
        if (pHPCodeDataArray == null || pHPCodeDataArray.length != 1) {
            return null;
        }
        return pHPCodeDataArray[0];
    }

    private void run(PHPCodeData pHPCodeData) throws CoreException {
        if (!ActionUtils.isProcessable(this.getShell(), pHPCodeData)) {
            return;
        }
        throw new RuntimeException("implement me");
    }

    private static boolean isRenameAvailable(PHPCodeData pHPCodeData) throws CoreException {
        return false;
    }
}

