/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.ITaskTagsListener;
import org.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.php.internal.core.preferences.TaskTagsEvent;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class TaskTagsProvider {
    private static TaskTagsProvider instance;
    private HashMap projectToTaskTagListener;
    private HashMap projectToPropagatorListeners;
    private boolean isInstalled;
    private PreferencesSupport preferencesSupport;
    private PreferencesPropagator preferencesPropagator;
    private static final String NODES_QUALIFIER = "org.eclipse.php.core";
    private static final IPreferenceStore store;

    static {
        store = PHPCorePlugin.getDefault().getPreferenceStore();
    }

    private TaskTagsProvider() {
        this.install();
    }

    public static TaskTagsProvider getInstance() {
        if (instance == null) {
            instance = new TaskTagsProvider();
        }
        return instance;
    }

    public TaskTag[] getWorkspaceTaskTags() {
        String string = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
        String string2 = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
        TaskTag[] taskTagArray = this.getTagsAndPropertiesFrom(string2, string);
        return taskTagArray;
    }

    public boolean isWorkspaceTagsCaseSensitive() {
        String string = this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskCaseSensitive");
        return "enabled".equals(string);
    }

    public TaskTag[] getProjectTaskTags(IProject iProject) {
        String string = this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", null, iProject);
        String string2 = this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, iProject);
        if (string2 == null || string == null) {
            return null;
        }
        TaskTag[] taskTagArray = this.getTagsAndPropertiesFrom(string2, string);
        return taskTagArray;
    }

    public boolean getProjectTagsCaseSensitive(IProject iProject) {
        String string = this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskCaseSensitive", null, iProject);
        if (string == null) {
            return this.isWorkspaceTagsCaseSensitive();
        }
        return "enabled".equals(string);
    }

    public void addTaskTagsListener(ITaskTagsListener iTaskTagsListener, IProject iProject) {
        this.projectToTaskTagListener.put(iProject, iTaskTagsListener);
        this.installPropagatorListeners(iProject);
    }

    public void removeTaskTagsListener(ITaskTagsListener iTaskTagsListener, IProject iProject) {
        this.projectToTaskTagListener.remove(iProject);
        this.uninstallPropagatorListeners(iProject);
    }

    private void installPropagatorListeners(IProject iProject) {
        IPreferencesPropagatorListener[] iPreferencesPropagatorListenerArray = new IPreferencesPropagatorListener[]{new InnerTaskTagsListener(iProject), new InnerTaskPrioritiesListener(iProject), new InnerTaskCaseListener(iProject)};
        this.preferencesPropagator.addPropagatorListener(iPreferencesPropagatorListenerArray[0], "org.eclipse.php.core.taskTags");
        this.preferencesPropagator.addPropagatorListener(iPreferencesPropagatorListenerArray[1], "org.eclipse.php.core.taskPriorities");
        this.preferencesPropagator.addPropagatorListener(iPreferencesPropagatorListenerArray[2], "org.eclipse.php.core.taskCaseSensitive");
        this.projectToPropagatorListeners.put(iProject, iPreferencesPropagatorListenerArray);
    }

    private void uninstallPropagatorListeners(IProject iProject) {
        IPreferencesPropagatorListener[] iPreferencesPropagatorListenerArray = (IPreferencesPropagatorListener[])this.projectToPropagatorListeners.get(iProject);
        if (iPreferencesPropagatorListenerArray != null) {
            this.preferencesPropagator.removePropagatorListener(iPreferencesPropagatorListenerArray[0], "org.eclipse.php.core.taskTags");
            this.preferencesPropagator.removePropagatorListener(iPreferencesPropagatorListenerArray[1], "org.eclipse.php.core.taskPriorities");
            this.preferencesPropagator.removePropagatorListener(iPreferencesPropagatorListenerArray[2], "org.eclipse.php.core.taskCaseSensitive");
        }
        this.projectToPropagatorListeners.remove(iProject);
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.preferencesSupport = new PreferencesSupport(NODES_QUALIFIER, PHPCorePlugin.getDefault().getPreferenceStore());
        this.projectToTaskTagListener = new HashMap();
        this.projectToPropagatorListeners = new HashMap();
        PreferencePropagatorFactory.getInstance();
        this.preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator(NODES_QUALIFIER, store);
        this.isInstalled = true;
    }

    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        Set set = this.projectToPropagatorListeners.keySet();
        IProject[] iProjectArray = new IProject[set.size()];
        set.toArray(iProjectArray);
        int n = 0;
        while (n < iProjectArray.length) {
            this.uninstallPropagatorListeners(iProjectArray[n]);
            ++n;
        }
        this.preferencesSupport = null;
        this.preferencesPropagator = null;
        this.projectToTaskTagListener = null;
        this.projectToPropagatorListeners = null;
        this.isInstalled = false;
    }

    private void notifyTaskTagChange(TaskTagsEvent taskTagsEvent) {
        ITaskTagsListener[] iTaskTagsListenerArray = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(iTaskTagsListenerArray);
        int n = 0;
        while (n < iTaskTagsListenerArray.length) {
            iTaskTagsListenerArray[n].taskTagsChanged(taskTagsEvent);
            ++n;
        }
    }

    private void notifyTaskPriorityChange(TaskTagsEvent taskTagsEvent) {
        ITaskTagsListener[] iTaskTagsListenerArray = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(iTaskTagsListenerArray);
        int n = 0;
        while (n < iTaskTagsListenerArray.length) {
            iTaskTagsListenerArray[n].taskPrioritiesChanged(taskTagsEvent);
            ++n;
        }
    }

    private void notifyTaskCaseChange(TaskTagsEvent taskTagsEvent) {
        ITaskTagsListener[] iTaskTagsListenerArray = new ITaskTagsListener[this.projectToTaskTagListener.size()];
        this.projectToTaskTagListener.values().toArray(iTaskTagsListenerArray);
        int n = 0;
        while (n < iTaskTagsListenerArray.length) {
            iTaskTagsListenerArray[n].taskCaseChanged(taskTagsEvent);
            ++n;
        }
    }

    private TaskTag[] getTagsAndPropertiesFrom(String string, String string2) {
        Object object;
        String[] stringArray = StringUtils.unpack((String)string);
        String[] stringArray2 = StringUtils.unpack((String)string2);
        ArrayList<TaskTag[]> arrayList = new ArrayList<TaskTag[]>();
        int n = 0;
        while (n < stringArray2.length) {
            object = null;
            object = "HIGH".equals(stringArray2[n]) ? new Integer(2) : ("LOW".equals(stringArray2[n]) ? new Integer(0) : new Integer(1));
            arrayList.add((TaskTag[])object);
            ++n;
        }
        Integer[] integerArray = new Integer[arrayList.size()];
        arrayList.toArray(integerArray);
        object = new TaskTag[Math.min(stringArray.length, stringArray2.length)];
        int n2 = 0;
        while (n2 < ((TaskTag[])object).length) {
            object[n2] = new TaskTag(stringArray[n2], integerArray[n2].intValue());
            ++n2;
        }
        return object;
    }

    private abstract class AbstractTasksListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public AbstractTasksListener(IProject iProject) {
            this.project = iProject;
        }

        public IProject getProject() {
            return this.project;
        }
    }

    private class InnerTaskCaseListener
    extends AbstractTasksListener {
        public InnerTaskCaseListener(IProject iProject) {
            super(iProject);
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            String string = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, this.getProject());
            String string2 = null;
            if (string == null) {
                string = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
                string2 = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
            } else {
                string2 = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", "", this.getProject());
            }
            if (StringUtils.occurrencesOf((String)string2, (char)',') == StringUtils.occurrencesOf((String)string, (char)',')) {
                TaskTag[] taskTagArray = TaskTagsProvider.this.getTagsAndPropertiesFrom(string, string2);
                TaskTagsEvent taskTagsEvent = null;
                String string3 = (String)preferencesPropagatorEvent.getNewValue();
                if (string3 == null) {
                    string3 = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskCaseSensitive");
                }
                taskTagsEvent = "enabled".equals(string3) ? new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTagArray, true) : new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTagArray, false);
                TaskTagsProvider.this.notifyTaskCaseChange(taskTagsEvent);
            }
        }
    }

    private class InnerTaskPrioritiesListener
    extends AbstractTasksListener {
        public InnerTaskPrioritiesListener(IProject iProject) {
            super(iProject);
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            String string;
            String string2 = (String)preferencesPropagatorEvent.getNewValue();
            if (string2 == null) {
                string2 = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
            }
            if ((string = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskTags", null, this.getProject())) == null) {
                string = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
            }
            if (StringUtils.occurrencesOf((String)string, (char)',') == StringUtils.occurrencesOf((String)string2, (char)',')) {
                TaskTag[] taskTagArray = TaskTagsProvider.this.getTagsAndPropertiesFrom(string, string2);
                TaskTagsEvent taskTagsEvent = new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTagArray, TaskTagsProvider.this.getProjectTagsCaseSensitive(this.getProject()));
                TaskTagsProvider.this.notifyTaskPriorityChange(taskTagsEvent);
            }
        }
    }

    private class InnerTaskTagsListener
    extends AbstractTasksListener {
        public InnerTaskTagsListener(IProject iProject) {
            super(iProject);
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            String string;
            String string2 = (String)preferencesPropagatorEvent.getNewValue();
            if (string2 == null) {
                string2 = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskTags");
            }
            if ((string = TaskTagsProvider.this.preferencesSupport.getProjectSpecificPreferencesValue("org.eclipse.php.core.taskPriorities", null, this.getProject())) == null) {
                string = TaskTagsProvider.this.preferencesSupport.getWorkspacePreferencesValue("org.eclipse.php.core.taskPriorities");
            }
            if (StringUtils.occurrencesOf((String)string, (char)',') == StringUtils.occurrencesOf((String)string2, (char)',')) {
                TaskTag[] taskTagArray = TaskTagsProvider.this.getTagsAndPropertiesFrom(string2, string);
                TaskTagsEvent taskTagsEvent = new TaskTagsEvent(TaskTagsProvider.this, this.getProject(), taskTagArray, TaskTagsProvider.this.getProjectTagsCaseSensitive(this.getProject()));
                TaskTagsProvider.this.notifyTaskTagChange(taskTagsEvent);
            }
        }
    }
}

