/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.java.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.java.JavaImporter;
import org.eclipse.emf.importer.java.JavaImporterPlugin;
import org.eclipse.emf.importer.ui.contribution.base.ModelImporterPackagePage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class JavaPackagePage
extends ModelImporterPackagePage {
    public JavaPackagePage(ModelImporter modelImporter, String pageName) {
        super(modelImporter, pageName);
        this.setDescription(JavaImporterPlugin.INSTANCE.getString("_UI_PackageSelection_description"));
    }

    public JavaImporter getJavaImporter() {
        return (JavaImporter)this.getModelImporter();
    }

    protected void pageActivated(final boolean firstTime, int cause) {
        if (this.getJavaImporter().canImport()) {
            this.setErrorMessage(null);
            this.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JavaPackagePage.this.computeEPackages();
                    JavaPackagePage.this.filterEPackagesTable(firstTime);
                    JavaPackagePage.this.getContainer().updateButtons();
                }
            });
        } else {
            this.setErrorMessage(JavaImporterPlugin.INSTANCE.getString("_UI_JavaProjectRequired_message"));
            this.setPageComplete(false);
        }
    }

    protected void computeEPackages() {
        WorkspaceModifyOperation initializeOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                Monitor monitor = BasicMonitor.toMonitor((IProgressMonitor)progressMonitor);
                try {
                    try {
                        JavaPackagePage.this.computeEPackages(monitor);
                    }
                    catch (Exception e) {
                        JavaImporterPlugin.INSTANCE.log(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)initializeOperation);
        }
        catch (Exception exception) {
            JavaImporterPlugin.INSTANCE.log(exception);
        }
    }

    protected void computeEPackages(Monitor monitor) throws Exception {
        Diagnostic diagnostic = this.getJavaImporter().computeEPackages(monitor);
        this.getJavaImporter().adjustEPackages(monitor);
        String message = JavaImporterPlugin.INSTANCE.getString("_UI_ProblemsEncounteredProcessingJava_message");
        this.handleDiagnostic(diagnostic, message, JavaImporterPlugin.INSTANCE.getString("_UI_LoadProblem_title"), message);
    }
}

