/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.plan;

import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.SPLaunchShortcut;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.plan.ExplainSQLActionDelegate;
import org.eclipse.debug.core.ILaunchConfiguration;

public class ExplainRoutineActionDelegate
extends ExplainSQLActionDelegate {
    protected String _procSql;

    public ExplainRoutineActionDelegate(SQLEditor targetEditor) {
        super(targetEditor);
    }

    public void run() {
        if (this.explainAsRoutineObject()) {
            ProcEditorInput procEditorInput = (ProcEditorInput)this._sqlEditor.getEditorInput();
            try {
                ILaunchConfiguration config = SPLaunchShortcut.getLaunchConfiguration(procEditorInput.getProcIdentifier(), "run");
                if (config == null) {
                    return;
                }
                this._procSql = LaunchHelper.constructDirectInvocationSQLString(config);
                super.run();
            }
            catch (Exception exception) {}
        } else {
            super.run();
        }
    }

    public String getSQLStatements() {
        if (this.explainAsRoutineObject()) {
            return this._procSql;
        }
        return super.getSQLStatements();
    }

    protected boolean explainAsRoutineObject() {
        return this.isRoutineEditor() && (this._sqlEditor.getSelectedText() == null || this._sqlEditor.getSelectedText().trim().equals(""));
    }

    protected boolean isRoutineEditor() {
        return this._sqlEditor != null && this._sqlEditor.getEditorInput() instanceof ProcEditorInput;
    }

    protected boolean isSelectionEmpty() {
        return this._sqlEditor == null || this._sqlEditor.getSelectedText() == null || this._sqlEditor.getSelectedText().trim().equals("");
    }

    public void update() {
        if (this.isRoutineEditor()) {
            ProcEditorInput procEditorInput = (ProcEditorInput)this._sqlEditor.getEditorInput();
            int procType = procEditorInput.getProcIdentifier().getType();
            IPlanService service = SQLToolsFacade.getPlanService((DatabaseIdentifier)this.getDatabaseIdentifier());
            boolean supported = false;
            if (service != null) {
                boolean bl = supported = service.getPlanOption() == null ? false : service.getPlanOption().supportPlan(procType);
            }
            if (!supported) {
                if (this.isSelectionEmpty()) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(this._sqlEditor != null && this._sqlEditor.getConnectionInfo().getSharedConnection() != null && super.canBeEnabled());
                }
            }
        } else {
            this.setEnabled(this._sqlEditor != null && this._sqlEditor.isConnected() && super.canBeEnabled());
        }
    }
}

