/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewComponentDialog;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class NewTypeDialog
extends NewComponentDialog
implements IComponentDialog {
    protected XSDSchema schema;
    protected static int SIMPLE_TYPE = 0;
    protected static int COMPLEX_TYPE = 1;
    protected Object setObject;
    protected int typeKind;
    protected Object selection;
    protected boolean allowComplexType = true;
    protected boolean allowAnonymousType = true;
    protected boolean anonymousType = false;
    private Button complexTypeButton;
    private Button simpleTypeButton;
    private Button anonymousTypeCheckBox;

    public NewTypeDialog() {
        super(Display.getCurrent().getActiveShell(), Messages._UI_LABEL_NEW_TYPE, "NewType");
    }

    public NewTypeDialog(XSDSchema schema) {
        super(Display.getCurrent().getActiveShell(), Messages._UI_LABEL_NEW_TYPE, "NewType");
        this.schema = schema;
    }

    private void setup() {
        if (this.schema != null) {
            List usedNames = this.getUsedTypeNames();
            this.setUsedNames(usedNames);
            this.setDefaultName(XSDCommonUIUtils.createUniqueElementName("NewType", (List)this.schema.getTypeDefinitions()));
        }
    }

    public int createAndOpen() {
        this.setup();
        int returnCode = super.createAndOpen();
        if (returnCode == 0) {
            boolean cfr_ignored_0 = this.setObject instanceof Adapter;
        }
        return returnCode;
    }

    public ComponentSpecification getSelectedComponent() {
        ComponentSpecification componentSpecification = this.anonymousType ? new ComponentSpecification(null, null, null) : new ComponentSpecification(null, this.getName(), null);
        componentSpecification.setMetaName(this.typeKind == COMPLEX_TYPE ? IXSDSearchConstants.COMPLEX_TYPE_META_NAME : IXSDSearchConstants.SIMPLE_TYPE_META_NAME);
        componentSpecification.setNew(true);
        return componentSpecification;
    }

    public void setInitialSelection(ComponentSpecification componentSpecification) {
    }

    protected void createHeaderContent(Composite parent) {
        this.complexTypeButton = new Button(parent, 16);
        this.complexTypeButton.setText(Messages._UI_LABEL_COMPLEX_TYPE);
        this.complexTypeButton.setEnabled(this.allowComplexType);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.complexTypeButton, "org.eclipse.wst.xsd.ui.xsdud0010");
        this.simpleTypeButton = new Button(parent, 16);
        this.simpleTypeButton.setText(Messages._UI_LABEL_SIMPLE_TYPE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.simpleTypeButton, "org.eclipse.wst.xsd.ui.xsdud0020");
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == NewTypeDialog.this.simpleTypeButton) {
                    NewTypeDialog.this.typeKind = SIMPLE_TYPE;
                } else if (e.widget == NewTypeDialog.this.complexTypeButton) {
                    NewTypeDialog.this.typeKind = COMPLEX_TYPE;
                } else if (NewTypeDialog.this.allowAnonymousType && e.widget == NewTypeDialog.this.anonymousTypeCheckBox) {
                    if (NewTypeDialog.this.anonymousTypeCheckBox.getSelection()) {
                        NewTypeDialog.this.nameField.setEnabled(false);
                        NewTypeDialog.this.anonymousType = true;
                    } else {
                        NewTypeDialog.this.nameField.setEnabled(true);
                        NewTypeDialog.this.anonymousType = false;
                    }
                }
            }
        };
        if (this.allowComplexType) {
            this.complexTypeButton.setSelection(true);
            this.typeKind = COMPLEX_TYPE;
        } else {
            this.simpleTypeButton.setSelection(true);
            this.typeKind = SIMPLE_TYPE;
        }
        this.simpleTypeButton.addSelectionListener((SelectionListener)listener);
        this.complexTypeButton.addSelectionListener((SelectionListener)listener);
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(1808);
        separator.setLayoutData((Object)gd);
        if (this.allowAnonymousType) {
            this.anonymousTypeCheckBox = new Button(parent, 32);
            this.anonymousTypeCheckBox.setText(Messages._UI_LABEL_CREATE_ANON_TYPE);
        }
        if (this.anonymousTypeCheckBox != null) {
            this.anonymousTypeCheckBox.addSelectionListener((SelectionListener)listener);
        }
    }

    protected String getNormalizedLocation(String location) {
        try {
            URL url = new URL(location);
            URL resolvedURL = FileLocator.resolve((URL)url);
            location = resolvedURL.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return location;
    }

    public void allowComplexType(boolean value) {
        this.allowComplexType = value;
    }

    public void allowAnonymousType(boolean value) {
        this.allowAnonymousType = value;
    }

    private List getUsedTypeNames() {
        ArrayList<String> usedNames = new ArrayList<String>();
        if (this.schema != null) {
            EList typesList = this.schema.getTypeDefinitions();
            Iterator types = typesList.iterator();
            while (types.hasNext()) {
                usedNames.add(((XSDTypeDefinition)types.next()).getName());
            }
        }
        return usedNames;
    }
}

