/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.ui.wizards;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.ws.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSConsole;
import org.eclipse.datatools.enablement.oda.ws.ui.util.WSUIUtil;
import org.eclipse.datatools.enablement.oda.ws.ui.wizards.XMLTableMappingPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SOAPResponsePage
extends DataSetWizardPage {
    private transient Button dftXSDRadio;
    private transient Button extXSDRadio;
    private transient Button dftXMLRadio;
    private transient Button extXMLRadio;
    private transient Text xmlFileURI;
    private transient Text xsdFileURI;
    private transient Text soapEndPoint;
    private static String DEFAULT_MESSAGE = Messages.getString("soapResponsePage.message.default");

    public SOAPResponsePage(String pageName) {
        super(pageName);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(272);
        composite.setLayoutData((Object)layoutData);
        this.setupXSDGroup(composite);
        this.setupXMLGroup(composite);
        return composite;
    }

    private void setupXSDGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.getString("soapResponsePage.group.schema"));
        group.setLayout((Layout)new GridLayout(3, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        this.setupDFTXSDRadio((Composite)group);
        this.setupEXTXSDRadio((Composite)group);
    }

    private void setupDFTXSDRadio(Composite parent) {
        this.dftXSDRadio = new Button(parent, 16);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 3;
        this.dftXSDRadio.setLayoutData((Object)layoutData);
        this.dftXSDRadio.setText(Messages.getString("soapResponsePage.radio.defaultSchema"));
        this.dftXSDRadio.setSelection(true);
        this.dftXSDRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SOAPResponsePage.this.xsdFileURI.setText("");
            }
        });
    }

    private void setupEXTXSDRadio(Composite parent) {
        this.extXSDRadio = new Button(parent, 16);
        GridData layoutData = new GridData();
        this.extXSDRadio.setLayoutData((Object)layoutData);
        this.extXSDRadio.setText(Messages.getString("soapResponsePage.radio.externalSchema"));
        this.xsdFileURI = new Text(parent, 2048);
        layoutData = new GridData(768);
        this.xsdFileURI.setLayoutData((Object)layoutData);
        Button button = new Button(parent, 0);
        layoutData = new GridData();
        layoutData.widthHint = 70;
        button.setLayoutData((Object)layoutData);
        button.setText(Messages.getString("soapResponsePage.button.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xsd", "*.*"});
                if (SOAPResponsePage.this.xsdFileURI.getText() != null && SOAPResponsePage.this.xsdFileURI.getText().trim().length() > 0) {
                    dialog.setFilterPath(SOAPResponsePage.this.xsdFileURI.getText());
                }
                if ((selectedLocation = dialog.open()) != null) {
                    SOAPResponsePage.this.xsdFileURI.setText(selectedLocation);
                    SOAPResponsePage.this.extXSDRadio.setSelection(true);
                    SOAPResponsePage.this.dftXSDRadio.setSelection(false);
                }
            }
        });
    }

    private void setupXMLGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(768);
        group.setLayoutData((Object)layoutData);
        group.setText(Messages.getString("soapResponsePage.group.xml"));
        this.setupDFTXMLRadio((Composite)group);
        this.setupEXTXMLRadio((Composite)group);
    }

    private void setupDFTXMLRadio(Composite parent) {
        this.dftXMLRadio = new Button(parent, 16);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.dftXMLRadio.setLayoutData((Object)layoutData);
        this.dftXMLRadio.setText(Messages.getString("soapResponsePage.radio.endPoint"));
        this.dftXMLRadio.setSelection(true);
        this.dftXMLRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SOAPResponsePage.this.xmlFileURI.setText("");
            }
        });
        this.soapEndPoint = new Text(parent, 2048);
        layoutData = new GridData(768);
        this.soapEndPoint.setLayoutData((Object)layoutData);
        Button button = new Button(parent, 0);
        layoutData = new GridData();
        layoutData.widthHint = 70;
        button.setLayoutData((Object)layoutData);
        button.setText(Messages.getString("soapResponsePage.button.connect"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SOAPResponsePage.this.saveToModel();
                    WSConsole.getInstance().createXMLTempFileURI();
                    SOAPResponsePage.this.setMessage(DEFAULT_MESSAGE);
                }
                catch (OdaException e1) {
                    SOAPResponsePage.this.setMessage(e1.getMessage(), 3);
                }
            }
        });
    }

    private void setupEXTXMLRadio(Composite parent) {
        this.extXMLRadio = new Button(parent, 16);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        this.extXMLRadio.setLayoutData((Object)layoutData);
        this.extXMLRadio.setText(Messages.getString("soapResponsePage.radio.externalXML"));
        this.xmlFileURI = new Text(parent, 2048);
        layoutData = new GridData(768);
        this.xmlFileURI.setLayoutData((Object)layoutData);
        Button button = new Button(parent, 0);
        layoutData = new GridData();
        layoutData.widthHint = 70;
        button.setLayoutData((Object)layoutData);
        button.setText(Messages.getString("soapResponsePage.button.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedLocation;
                FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                if (SOAPResponsePage.this.xmlFileURI.getText() != null && SOAPResponsePage.this.xmlFileURI.getText().trim().length() > 0) {
                    dialog.setFilterPath(SOAPResponsePage.this.xmlFileURI.getText());
                }
                if ((selectedLocation = dialog.open()) != null) {
                    SOAPResponsePage.this.xmlFileURI.setText(selectedLocation);
                    SOAPResponsePage.this.extXMLRadio.setSelection(true);
                    SOAPResponsePage.this.dftXMLRadio.setSelection(false);
                }
            }
        });
    }

    private void initializeControl() {
        this.initWSConsole();
        this.initFromModel();
    }

    private void initWSConsole() {
        if (!WSConsole.getInstance().isSessionOK()) {
            WSConsole.getInstance().start(this.getInitializationDesign());
        }
    }

    private void initFromModel() {
        String xml;
        String xsd = WSConsole.getInstance().getPropertyValue("xsdFileURI");
        if (!WSUIUtil.isNull((Object)xsd)) {
            this.dftXSDRadio.setSelection(false);
            this.extXSDRadio.setSelection(true);
            this.xsdFileURI.setText(xsd);
        }
        if (!WSUIUtil.isNull((Object)(xml = WSConsole.getInstance().getPropertyValue("xmlFileURI")))) {
            this.dftXMLRadio.setSelection(false);
            this.extXMLRadio.setSelection(true);
            this.xmlFileURI.setText(xml);
        }
        this.soapEndPoint.setText(WSUIUtil.getNonNullString((String)WSConsole.getInstance().getPropertyValue("soapEndPoint")));
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        this.savePage(design);
        return design;
    }

    private void savePage(DataSetDesign design) {
        if (!WSConsole.getInstance().isSessionOK()) {
            return;
        }
        design.getPublicProperties().setProperty("xmlFileURI", WSConsole.getInstance().getPropertyValue("xmlFileURI"));
        design.getPublicProperties().setProperty("xsdFileURI", WSConsole.getInstance().getPropertyValue("xsdFileURI"));
        design.getDataSourceDesign().getPublicProperties().setProperty("soapEndPoint", WSConsole.getInstance().getPropertyValue("soapEndPoint"));
    }

    protected boolean canLeave() {
        this.saveToModel();
        return super.canLeave();
    }

    public IWizardPage getNextPage() {
        this.saveToModel();
        IWizardPage page = super.getNextPage();
        if (page instanceof XMLTableMappingPage) {
            ((XMLTableMappingPage)page).refresh();
        }
        return page;
    }

    private void saveToModel() {
        WSConsole.getInstance().setPropertyValue("xsdFileURI", this.xsdFileURI.getText());
        WSConsole.getInstance().setPropertyValue("soapEndPoint", this.soapEndPoint.getText());
        WSConsole.getInstance().setPropertyValue("xmlFileURI", this.xmlFileURI.getText());
    }

    protected void cleanup() {
        WSConsole.getInstance().terminateSession();
    }
}

