/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.help;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class HelpUtil {
    public static String HELP_KEY = "org.eclipse.ui.help";
    public static String CONTEXT_PROVIDER_KEY = "com.sybase.stf.help.context.provider";
    private static HelpListener _helpListener = null;
    private static HashMap _properties = new HashMap();

    private HelpUtil() {
    }

    private static Point computePopUpLocation(Display display) {
        Point point = display.getCursorLocation();
        return new Point(point.x + 15, point.y);
    }

    private static HelpListener getHelpListener() {
        if (_helpListener == null) {
            _helpListener = new HelpUtilHelpListener();
        }
        return _helpListener;
    }

    public static void setHelp(Control control, String contextId) {
        if (control != null) {
            control.removeHelpListener(HelpUtil.getHelpListener());
            control.addHelpListener(HelpUtil.getHelpListener());
        }
        control.setData(HELP_KEY, (Object)contextId);
    }

    public static String getHelpKey(Object target) {
        if (target instanceof Control) {
            Control control = (Control)target;
            while (control != null) {
                Object contextId = control.getData(HELP_KEY);
                if (contextId != null && contextId instanceof String) {
                    return (String)contextId;
                }
                control = control.getParent();
            }
        }
        return null;
    }

    public static String getContextId(String helpKey, String helpPluginID) {
        return HelpUtil.getHelpString(helpKey, helpPluginID, "contextIds");
    }

    public static String getSearchExpression(String helpKey, String helpPluginID) {
        return HelpUtil.getHelpString(helpKey, helpPluginID, "searchExpressions");
    }

    private static String getHelpString(String helpKey, String helpPluginID, String bundleType) {
        if (helpKey == null) {
            return null;
        }
        Properties[] properties = (Properties[])_properties.get(String.valueOf(helpPluginID) + ';' + bundleType);
        try {
            int i;
            if (properties == null) {
                String[] propertiesFiles = HelpUtil.getPropertiesFiles(helpPluginID, bundleType);
                properties = new Properties[propertiesFiles.length];
                i = 0;
                while (i < propertiesFiles.length) {
                    String file = new Path(propertiesFiles[i]).toOSString();
                    FileInputStream fis = new FileInputStream(file);
                    properties[i] = new Properties();
                    properties[i].load(fis);
                    ++i;
                }
                _properties.put(String.valueOf(helpPluginID) + ';' + bundleType, properties);
            }
            String bundleString = null;
            i = 0;
            while (bundleString == null && i < properties.length) {
                bundleString = properties[i].getProperty(helpKey);
                ++i;
            }
            return bundleString;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String[] getPropertiesFiles(String pluginIDToMatch, String bundleType) {
        IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.datatools.help", "helpKeyProperties");
        IExtension[] exts = exp.getExtensions();
        ArrayList<String> propertiesFiles = new ArrayList<String>();
        int index = 0;
        int count = exts.length;
        while (index < count) {
            Iterator<IConfigurationElement> it = Arrays.asList(exts[index].getConfigurationElements()).iterator();
            while (it.hasNext()) {
                String pluginID;
                IConfigurationElement elem = it.next();
                if (!elem.getName().equals(bundleType) || !(pluginID = elem.getAttribute("plugin")).equals(pluginIDToMatch)) continue;
                String propertiesFile = elem.getAttribute("file");
                try {
                    String helpPluginID = exts[index].getNamespaceIdentifier();
                    Bundle helpPluginBundle = Platform.getBundle((String)helpPluginID);
                    URL propertiesFileURL = helpPluginBundle.getResource(propertiesFile);
                    propertiesFileURL = FileLocator.resolve((URL)propertiesFileURL);
                    propertiesFile = propertiesFileURL.getFile();
                    if (propertiesFile.charAt(0) == '/') {
                        propertiesFile = propertiesFile.substring(1);
                    }
                    propertiesFiles.add(propertiesFile);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            ++index;
        }
        return propertiesFiles.toArray(new String[propertiesFiles.size()]);
    }

    private static class HelpUtilHelpListener
    implements HelpListener {
        static /* synthetic */ Class class$0;

        private HelpUtilHelpListener() {
        }

        public void helpRequested(HelpEvent event) {
            if (event.widget != null && !event.widget.isDisposed()) {
                IContext context;
                Widget widget = event.widget;
                IContextProvider provider = null;
                while (widget != null && provider == null) {
                    if (widget instanceof IAdaptable) {
                        IAdaptable iAdaptable = (IAdaptable)widget;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.help.IContextProvider");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        provider = (IContextProvider)iAdaptable.getAdapter((Class)clazz);
                    } else if (widget instanceof IContextProvider) {
                        provider = (IContextProvider)widget;
                    } else if (widget.getData(CONTEXT_PROVIDER_KEY) != null && widget.getData(CONTEXT_PROVIDER_KEY) instanceof IContextProvider) {
                        provider = (IContextProvider)widget.getData(CONTEXT_PROVIDER_KEY);
                    }
                    if (!(widget instanceof Control)) break;
                    widget = ((Control)widget).getParent();
                }
                if (provider != null && (provider.getContextChangeMask() & 1) != 0 && (context = HelpSystem.getContext((String)HelpUtil.getHelpKey(event.widget))) != null) {
                    Point point = HelpUtil.computePopUpLocation(event.widget.getDisplay());
                    PlatformUI.getWorkbench().getHelpSystem().displayContext(context, point.x, point.y);
                }
            }
        }
    }
}

