/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.datatools.enablement.oda.ws.soap.SOAPResponse;

public class RawMessageSender {
    private String spec = "";
    private String message = "";
    private String soapAction = "";
    private SOAPResponse soapResponse;
    private HttpURLConnection connection;

    public RawMessageSender(String spec, String message, String soapAction) {
        this.spec = spec;
        this.message = message;
        this.soapAction = soapAction;
    }

    public RawMessageSender() {
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public SOAPResponse getSOAPResponse() {
        Thread t = new Thread(new SOAPResponseCollector());
        t.start();
        while (t.isAlive()) {
        }
        return this.soapResponse;
    }

    class SOAPResponseCollector
    implements Runnable {
        SOAPResponseCollector() {
        }

        public void run() {
            try {
                URL url = new URL(RawMessageSender.this.spec);
                RawMessageSender.this.connection = (HttpURLConnection)url.openConnection();
                RawMessageSender.this.connection.setRequestMethod("POST");
                RawMessageSender.this.connection.setRequestProperty("Content-Length", String.valueOf(RawMessageSender.this.message.length()));
                RawMessageSender.this.connection.setRequestProperty("Content-Type", "text/xml");
                RawMessageSender.this.connection.setRequestProperty("Connection", "Close");
                RawMessageSender.this.connection.setRequestProperty("SoapAction", RawMessageSender.this.soapAction);
                RawMessageSender.this.connection.setDoOutput(true);
                PrintWriter pw = new PrintWriter(RawMessageSender.this.connection.getOutputStream());
                pw.write(RawMessageSender.this.message);
                pw.flush();
                RawMessageSender.this.connection.connect();
                RawMessageSender.this.soapResponse = new SOAPResponse(RawMessageSender.this.connection.getInputStream());
            }
            catch (MalformedURLException e) {
                RawMessageSender.this.soapResponse = new SOAPResponse(RawMessageSender.this.connection.getErrorStream(), 1, e.getMessage());
            }
            catch (IOException e) {
                RawMessageSender.this.soapResponse = new SOAPResponse(RawMessageSender.this.connection.getErrorStream(), 1, e.getMessage());
            }
        }
    }
}

