/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public class ParameterInfo {
    public static final int INDEX_FOR_ADDED = -1;
    public static final String ELLIPSIS = "...";
    private IVariableBinding fOldBinding;
    private ITypeBinding fOldTypeBinding;
    private final String fOldName;
    private final String fOldTypeName;
    private final int fOldIndex;
    private String fNewTypeName;
    private ITypeBinding fNewTypeBinding;
    private String fDefaultValue;
    private String fNewName;
    private boolean fIsDeleted;
    private boolean fCreateField = true;
    private boolean fInlined;

    public ParameterInfo(String type, String name, int index) {
        this(null, null, type, name, index);
    }

    public ParameterInfo(IVariableBinding binding, String type, String name, int index) {
        this(binding, null, type, name, index);
    }

    private ParameterInfo(IVariableBinding binding, ITypeBinding typeBinding, String type, String name, int index) {
        this.fOldBinding = binding;
        this.fOldTypeBinding = typeBinding;
        this.fNewTypeBinding = typeBinding;
        this.fOldTypeName = type;
        this.fNewTypeName = type;
        this.fOldName = name;
        this.fNewName = name;
        this.fOldIndex = index;
        this.fDefaultValue = "";
        this.fIsDeleted = false;
    }

    public static ParameterInfo createInfoForAddedParameter(String type, String name) {
        ParameterInfo info = new ParameterInfo("", "", -1);
        info.setNewTypeName(type);
        info.setNewName(name);
        return info;
    }

    public static ParameterInfo createInfoForAddedParameter(String type, String name, String defaultValue) {
        ParameterInfo info = new ParameterInfo("", "", -1);
        info.setNewTypeName(type);
        info.setNewName(name);
        info.setDefaultValue(defaultValue);
        return info;
    }

    public static ParameterInfo createInfoForAddedParameter(ITypeBinding typeBinding, String type, String name, String defaultValue) {
        ParameterInfo info = new ParameterInfo(null, typeBinding, "", "", -1);
        info.setNewTypeName(type);
        info.setNewName(name);
        info.setDefaultValue(defaultValue);
        return info;
    }

    public int getOldIndex() {
        return this.fOldIndex;
    }

    public boolean isDeleted() {
        return this.fIsDeleted;
    }

    public void markAsDeleted() {
        Assert.isTrue((!this.isAdded() ? 1 : 0) != 0);
        this.fIsDeleted = true;
    }

    public boolean isAdded() {
        return this.fOldIndex == -1;
    }

    public boolean isTypeNameChanged() {
        return !this.fOldTypeName.equals(this.fNewTypeName);
    }

    public boolean isRenamed() {
        return !this.fOldName.equals(this.fNewName);
    }

    public boolean isVarargChanged() {
        return this.isOldVarargs() ^ this.isNewVarargs();
    }

    public IVariableBinding getOldBinding() {
        return this.fOldBinding;
    }

    public String getOldTypeName() {
        return this.fOldTypeName;
    }

    public String getNewTypeName() {
        return this.fNewTypeName;
    }

    public void setNewTypeName(String type) {
        Assert.isNotNull((Object)type);
        this.fNewTypeName = type;
    }

    public ITypeBinding getNewTypeBinding() {
        return this.fNewTypeBinding;
    }

    public void setNewTypeBinding(ITypeBinding typeBinding) {
        this.fNewTypeBinding = typeBinding;
    }

    public boolean isOldVarargs() {
        return ParameterInfo.isVarargs(this.fOldTypeName);
    }

    public boolean isNewVarargs() {
        return ParameterInfo.isVarargs(this.fNewTypeName);
    }

    public String getOldName() {
        return this.fOldName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public void setNewName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewName = newName;
    }

    public String getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setDefaultValue(String value) {
        Assert.isNotNull((Object)value);
        this.fDefaultValue = value;
    }

    public String toString() {
        return String.valueOf(this.fOldTypeName) + " " + this.fOldName + " @" + this.fOldIndex + " -> " + this.fNewTypeName + " " + this.fNewName + ": " + this.fDefaultValue + (this.fIsDeleted ? " (deleted)" : " (stays)");
    }

    public static String stripEllipsis(String typeName) {
        if (ParameterInfo.isVarargs(typeName)) {
            return typeName.substring(0, typeName.length() - 3);
        }
        return typeName;
    }

    public static boolean isVarargs(String typeName) {
        return typeName.endsWith(ELLIPSIS);
    }

    public ITypeBinding getOldTypeBinding() {
        return this.fOldTypeBinding;
    }

    public boolean isCreateField() {
        return this.fCreateField;
    }

    public void setCreateField(boolean createField) {
        this.fIsDeleted = createField;
        this.fCreateField = createField;
    }

    public void setOldBinding(IVariableBinding binding) {
        this.fOldBinding = binding;
        this.fOldTypeBinding = binding.getType();
        this.fNewTypeBinding = binding.getType();
    }

    public void setInlined(boolean inlined) {
        this.fInlined = inlined;
    }

    public boolean isInlined() {
        return this.fInlined;
    }
}

