/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jpt.core.internal.mappings.DefaultEagerFetchType;
import org.eclipse.jpt.core.internal.mappings.DefaultTrueBoolean;
import org.eclipse.jpt.core.internal.mappings.EnumType;
import org.eclipse.jpt.core.internal.mappings.IBasic;
import org.eclipse.jpt.core.internal.mappings.TemporalType;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.details.ColumnComposite;
import org.eclipse.jpt.ui.internal.mappings.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.mappings.details.EnumComboViewer;
import org.eclipse.jpt.ui.internal.mappings.details.LobCheckBox;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class BasicComposite
extends BaseJpaComposite {
    private IBasic basic;
    private ColumnComposite columnComposite;
    private EnumComboViewer fetchTypeComboViewer;
    private EnumComboViewer optionalComboViewer;
    private LobCheckBox lobCheckBox;
    private EnumComboViewer temporalTypeViewer;
    private EnumComboViewer enumeratedTypeViewer;

    public BasicComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Control generalControl = this.buildGeneralComposite(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        generalControl.setLayoutData((Object)gridData);
    }

    private Control buildGeneralComposite(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        Composite generalComposite = this.getWidgetFactory().createComposite(composite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        generalComposite.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(generalComposite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.columnComposite.getControl().setLayoutData((Object)gridData);
        CommonWidgets.buildFetchLabel(generalComposite, this.getWidgetFactory());
        this.fetchTypeComboViewer = CommonWidgets.buildFetchTypeComboViewer(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.fetchTypeComboViewer.getControl(), "org.eclipse.jpt.ui.mapping_fetchType");
        CommonWidgets.buildOptionalLabel(generalComposite, this.getWidgetFactory());
        this.optionalComboViewer = CommonWidgets.buildEnumComboViewer(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.optionalComboViewer.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.optionalComboViewer.getControl(), "org.eclipse.jpt.ui.mapping_optional");
        CommonWidgets.buildTemporalLabel(generalComposite, this.getWidgetFactory());
        this.temporalTypeViewer = CommonWidgets.buildEnumComboViewer(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.temporalTypeViewer.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.temporalTypeViewer.getControl(), "org.eclipse.jpt.ui.mapping_temporal");
        CommonWidgets.buildEnumeratedLabel(generalComposite, this.getWidgetFactory());
        this.enumeratedTypeViewer = CommonWidgets.buildEnumComboViewer(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.enumeratedTypeViewer.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.enumeratedTypeViewer.getControl(), "org.eclipse.jpt.ui.mapping_enumerated");
        this.lobCheckBox = this.buildLobCheckBox(generalComposite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.lobCheckBox.getControl().setLayoutData((Object)gridData);
        helpSystem.setHelp(this.lobCheckBox.getControl(), "org.eclipse.jpt.ui.mapping_lob");
        return generalComposite;
    }

    private LobCheckBox buildLobCheckBox(Composite parent) {
        return new LobCheckBox(parent, this.commandStack, this.getWidgetFactory());
    }

    public void doPopulate(EObject obj) {
        this.basic = (IBasic)obj;
        if (this.basic != null) {
            this.columnComposite.populate((EObject)this.basic.getColumn());
        } else {
            this.columnComposite.populate(null);
        }
        this.fetchTypeComboViewer.populate(new FetchHolder(this.basic));
        this.optionalComboViewer.populate(new OptionalHolder(this.basic));
        this.lobCheckBox.populate((EObject)this.basic);
        this.temporalTypeViewer.populate(new TemporalTypeHolder(this.basic));
        this.enumeratedTypeViewer.populate(new EnumeratedTypeHolder(this.basic));
    }

    public void doPopulate() {
        this.columnComposite.populate();
        this.fetchTypeComboViewer.populate();
        this.optionalComboViewer.populate();
        this.lobCheckBox.populate();
        this.temporalTypeViewer.populate();
        this.enumeratedTypeViewer.populate();
    }

    protected void engageListeners() {
    }

    protected void disengageListeners() {
    }

    public void dispose() {
        this.columnComposite.dispose();
        this.fetchTypeComboViewer.dispose();
        this.optionalComboViewer.dispose();
        this.lobCheckBox.dispose();
        this.temporalTypeViewer.dispose();
        this.enumeratedTypeViewer.dispose();
        super.dispose();
    }

    protected IBasic getBasic() {
        return this.basic;
    }

    private class EnumeratedTypeHolder
    extends EObjectImpl
    implements EnumComboViewer.EnumHolder {
        private IBasic basic;

        EnumeratedTypeHolder(IBasic basic) {
            this.basic = basic;
        }

        public Object get() {
            return this.basic.getEnumerated();
        }

        public void set(Object enumSetting) {
            this.basic.setEnumerated((EnumType)enumSetting);
        }

        public Class featureClass() {
            return IBasic.class;
        }

        public int featureId() {
            return 5;
        }

        public EObject wrappedObject() {
            return this.basic;
        }

        public Object[] enumValues() {
            return EnumType.VALUES.toArray();
        }
    }

    private class FetchHolder
    extends EObjectImpl
    implements EnumComboViewer.EnumHolder {
        private IBasic basic;

        FetchHolder(IBasic basic) {
            this.basic = basic;
        }

        public Object get() {
            return this.basic.getFetch();
        }

        public void set(Object enumSetting) {
            this.basic.setFetch((DefaultEagerFetchType)enumSetting);
        }

        public Class featureClass() {
            return IBasic.class;
        }

        public int featureId() {
            return 0;
        }

        public EObject wrappedObject() {
            return this.basic;
        }

        public Object[] enumValues() {
            return DefaultEagerFetchType.VALUES.toArray();
        }
    }

    private class OptionalHolder
    extends EObjectImpl
    implements EnumComboViewer.EnumHolder {
        private IBasic basic;

        OptionalHolder(IBasic basic) {
            this.basic = basic;
        }

        public Object get() {
            return this.basic.getOptional();
        }

        public void set(Object enumSetting) {
            this.basic.setOptional((DefaultTrueBoolean)enumSetting);
        }

        public Class featureClass() {
            return IBasic.class;
        }

        public int featureId() {
            return 1;
        }

        public EObject wrappedObject() {
            return this.basic;
        }

        public Object[] enumValues() {
            return DefaultTrueBoolean.VALUES.toArray();
        }
    }

    private class TemporalTypeHolder
    extends EObjectImpl
    implements EnumComboViewer.EnumHolder {
        private IBasic basic;

        TemporalTypeHolder(IBasic basic) {
            this.basic = basic;
        }

        public Object get() {
            return this.basic.getTemporal();
        }

        public void set(Object enumSetting) {
            this.basic.setTemporal((TemporalType)enumSetting);
        }

        public Class featureClass() {
            return IBasic.class;
        }

        public int featureId() {
            return 4;
        }

        public EObject wrappedObject() {
            return this.basic;
        }

        public Object[] enumValues() {
            return TemporalType.VALUES.toArray();
        }
    }
}

