/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jpt.core.internal.mappings.IGeneratedValue;
import org.eclipse.jpt.core.internal.mappings.IId;
import org.eclipse.jpt.core.internal.mappings.ISequenceGenerator;
import org.eclipse.jpt.core.internal.mappings.ITableGenerator;
import org.eclipse.jpt.core.internal.mappings.TemporalType;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.ColumnComposite;
import org.eclipse.jpt.ui.internal.mappings.details.CommonWidgets;
import org.eclipse.jpt.ui.internal.mappings.details.EnumComboViewer;
import org.eclipse.jpt.ui.internal.mappings.details.GeneratedValueComposite;
import org.eclipse.jpt.ui.internal.mappings.details.SequenceGeneratorComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TableGeneratorComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class IdComposite
extends BaseJpaComposite {
    private IId id;
    private Adapter idListener = this.buildIdListener();
    private ColumnComposite columnComposite;
    private EnumComboViewer temporalTypeViewer;
    private Section pkGenerationSection;
    private Button primaryKeyGenerationCheckBox;
    private GeneratedValueComposite generatedValueComposite;
    private Section tableGenSection;
    private Button tableGeneratorCheckBox;
    private TableGeneratorComposite tableGeneratorComposite;
    private Section sequenceGenSection;
    private Button sequenceGeneratorCheckBox;
    private SequenceGeneratorComposite sequenceGeneratorComposite;

    public IdComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildIdListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                IdComposite.this.idMappingChanged(notification);
            }
        };
    }

    void idMappingChanged(Notification notification) {
        switch (notification.getFeatureID(IId.class)) {
            case 3: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (IdComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        IdComposite.this.populateTableGeneratorComposite();
                    }
                });
                break;
            }
            case 4: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (IdComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        IdComposite.this.populateSequenceGeneratorComposite();
                    }
                });
                break;
            }
            case 1: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (IdComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        IdComposite.this.populateGeneratedValueComposite();
                    }
                });
            }
        }
    }

    protected void initializeLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Control generalControl = this.buildGeneralComposite(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        generalControl.setLayoutData((Object)gridData);
        Control generationControl = this.buildGenerationComposite(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        generationControl.setLayoutData((Object)gridData);
    }

    private Control buildGeneralComposite(Composite composite) {
        Composite generalComposite = this.getWidgetFactory().createComposite(composite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        generalComposite.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(generalComposite, this.commandStack, this.getWidgetFactory());
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.columnComposite.getControl().setLayoutData((Object)gridData);
        CommonWidgets.buildTemporalLabel(generalComposite, this.getWidgetFactory());
        this.temporalTypeViewer = CommonWidgets.buildEnumComboViewer(generalComposite, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.temporalTypeViewer.getControl().setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.temporalTypeViewer.getControl(), "org.eclipse.jpt.ui.mapping_temporal");
        return generalComposite;
    }

    private Control buildGenerationComposite(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        this.pkGenerationSection = this.getWidgetFactory().createSection(composite, 8388866);
        this.pkGenerationSection.setText(JptUiMappingsMessages.IdMappingComposite_primaryKeyGeneration);
        Composite generationClient = this.getWidgetFactory().createComposite((Composite)this.pkGenerationSection);
        this.pkGenerationSection.setClient((Control)generationClient);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        generationClient.setLayout((Layout)layout);
        this.primaryKeyGenerationCheckBox = this.buildPrimaryKeyGenerationCheckBox(generationClient);
        GridData gridData = new GridData();
        this.primaryKeyGenerationCheckBox.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.primaryKeyGenerationCheckBox, "org.eclipse.jpt.ui.mapping_primaryKeyGeneration");
        this.generatedValueComposite = new GeneratedValueComposite(generationClient, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 20;
        this.generatedValueComposite.getControl().setLayoutData((Object)gridData);
        this.tableGenSection = this.getWidgetFactory().createSection(generationClient, 0x800002);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.tableGenSection.setLayoutData((Object)gridData);
        this.tableGenSection.setText(JptUiMappingsMessages.IdMappingComposite_tableGenerator);
        Composite tableGenClient = this.getWidgetFactory().createComposite((Composite)this.tableGenSection);
        this.tableGenSection.setClient((Control)tableGenClient);
        layout = new GridLayout();
        layout.marginWidth = 0;
        tableGenClient.setLayout((Layout)layout);
        this.tableGeneratorCheckBox = this.buildTableGeneratorCheckBox(tableGenClient);
        gridData = new GridData();
        this.tableGeneratorCheckBox.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.tableGeneratorCheckBox, "org.eclipse.jpt.ui.mapping_tableGenerator");
        this.tableGeneratorComposite = new TableGeneratorComposite(tableGenClient, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 20;
        this.tableGeneratorComposite.getControl().setLayoutData((Object)gridData);
        this.sequenceGenSection = this.getWidgetFactory().createSection(generationClient, 0x800002);
        this.sequenceGenSection.setText(JptUiMappingsMessages.IdMappingComposite_sequenceGenerator);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.sequenceGenSection.setLayoutData((Object)gridData);
        Composite sequenceGenClient = this.getWidgetFactory().createComposite((Composite)this.sequenceGenSection);
        this.sequenceGenSection.setClient((Control)sequenceGenClient);
        layout = new GridLayout();
        layout.marginWidth = 0;
        sequenceGenClient.setLayout((Layout)layout);
        this.sequenceGeneratorCheckBox = this.buildSequenceGeneratorCheckBox(sequenceGenClient);
        gridData = new GridData();
        this.sequenceGeneratorCheckBox.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.sequenceGeneratorCheckBox, "org.eclipse.jpt.ui.mapping_sequenceGenerator");
        this.sequenceGeneratorComposite = new SequenceGeneratorComposite(sequenceGenClient, this.commandStack, this.getWidgetFactory());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 20;
        this.sequenceGeneratorComposite.getControl().setLayoutData((Object)gridData);
        return this.pkGenerationSection;
    }

    private Button buildPrimaryKeyGenerationCheckBox(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.IdMappingComposite_primaryKeyGeneration, 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IdComposite.this.primaryKeyGenerationCheckBoxClicked(e);
            }
        });
        return button;
    }

    void primaryKeyGenerationCheckBoxClicked(SelectionEvent e) {
        boolean mappingHasGeneratedValue = this.id.getGeneratedValue() != null;
        boolean checked = this.primaryKeyGenerationCheckBox.getSelection();
        if (checked == mappingHasGeneratedValue) {
            return;
        }
        IGeneratedValue generatedValue = null;
        if (checked) {
            generatedValue = this.id.createGeneratedValue();
        }
        this.id.setGeneratedValue(generatedValue);
    }

    private Button buildTableGeneratorCheckBox(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.IdMappingComposite_tableGenerator, 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IdComposite.this.tableGeneratorCheckBoxClicked(e);
            }
        });
        return button;
    }

    void tableGeneratorCheckBoxClicked(SelectionEvent e) {
        IGeneratedValue generatedValue;
        boolean mappingHasTableGenerator = this.id.getTableGenerator() != null;
        boolean checked = this.tableGeneratorCheckBox.getSelection();
        if (checked == mappingHasTableGenerator) {
            return;
        }
        ITableGenerator tableGenerator = null;
        if (checked) {
            tableGenerator = this.id.createTableGenerator();
        }
        this.id.setTableGenerator(tableGenerator);
        if (checked && (generatedValue = this.id.getGeneratedValue()) != null && generatedValue.getGenerator() != null) {
            tableGenerator.setName(generatedValue.getGenerator());
        }
    }

    private Button buildSequenceGeneratorCheckBox(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.IdMappingComposite_sequenceGenerator, 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IdComposite.this.sequenceGeneratorCheckBoxClicked(e);
            }
        });
        return button;
    }

    void sequenceGeneratorCheckBoxClicked(SelectionEvent e) {
        IGeneratedValue generatedValue;
        boolean mappingHasSequenceGenerator = this.id.getSequenceGenerator() != null;
        boolean checked = this.sequenceGeneratorCheckBox.getSelection();
        if (checked == mappingHasSequenceGenerator) {
            return;
        }
        ISequenceGenerator sequenceGenerator = null;
        if (checked) {
            sequenceGenerator = this.id.createSequenceGenerator();
        }
        this.id.setSequenceGenerator(sequenceGenerator);
        if (checked && (generatedValue = this.id.getGeneratedValue()) != null && generatedValue.getGenerator() != null) {
            sequenceGenerator.setName(generatedValue.getGenerator());
        }
    }

    public void doPopulate(EObject obj) {
        this.id = (IId)obj;
        if (this.id == null) {
            this.columnComposite.populate(null);
            this.generatedValueComposite.populate(null);
            this.tableGeneratorComposite.populate(null);
            this.sequenceGeneratorComposite.populate(null);
            return;
        }
        this.columnComposite.populate((EObject)this.id.getColumn());
        this.pkGenerationSection.setExpanded(true);
        this.temporalTypeViewer.populate(new TemporalTypeHolder(this.id));
        this.populateGeneratedValueComposite();
        this.populateSequenceGeneratorComposite();
        this.populateTableGeneratorComposite();
    }

    public void doPopulate() {
        this.columnComposite.populate();
        this.temporalTypeViewer.populate();
        this.generatedValueComposite.populate();
        this.tableGeneratorComposite.populate();
        this.sequenceGeneratorComposite.populate();
    }

    private void populateTableGeneratorComposite() {
        this.tableGeneratorComposite.populate((EObject)this.id);
        boolean tableGeneratorExists = this.id.getTableGenerator() != null;
        this.tableGeneratorCheckBox.setSelection(tableGeneratorExists);
        if (tableGeneratorExists) {
            this.tableGenSection.setExpanded(true);
        }
    }

    private void populateSequenceGeneratorComposite() {
        this.sequenceGeneratorComposite.populate((EObject)this.id);
        boolean sequenceGeneratorExists = this.id.getSequenceGenerator() != null;
        this.sequenceGeneratorCheckBox.setSelection(sequenceGeneratorExists);
        if (sequenceGeneratorExists) {
            this.sequenceGenSection.setExpanded(true);
        }
    }

    private void populateGeneratedValueComposite() {
        this.generatedValueComposite.populate((EObject)this.id);
        this.primaryKeyGenerationCheckBox.setSelection(this.id.getGeneratedValue() != null);
    }

    protected void engageListeners() {
        if (this.id != null) {
            this.id.eAdapters().add((Object)this.idListener);
        }
    }

    protected void disengageListeners() {
        if (this.id != null) {
            this.id.eAdapters().remove((Object)this.idListener);
        }
    }

    public void dispose() {
        this.columnComposite.dispose();
        this.temporalTypeViewer.dispose();
        this.generatedValueComposite.dispose();
        this.tableGeneratorComposite.dispose();
        this.sequenceGeneratorComposite.dispose();
        super.dispose();
    }

    protected IId getId() {
        return this.id;
    }

    private class TemporalTypeHolder
    extends EObjectImpl
    implements EnumComboViewer.EnumHolder {
        private IId id;

        TemporalTypeHolder(IId id) {
            this.id = id;
        }

        public Object get() {
            return this.id.getTemporal();
        }

        public void set(Object enumSetting) {
            this.id.setTemporal((TemporalType)enumSetting);
        }

        public Class featureClass() {
            return IId.class;
        }

        public int featureId() {
            return 2;
        }

        public EObject wrappedObject() {
            return this.id;
        }

        public Object[] enumValues() {
            return TemporalType.VALUES.toArray();
        }
    }
}

