/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jpt.core.internal.mappings.IOrderBy;
import org.eclipse.jpt.core.internal.mappings.OrderingType;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class OrderByComposite
extends BaseJpaComposite {
    private IOrderBy orderBy;
    private Adapter orderingListener = this.buildOrderingListener();
    private Button noOrderingRadioButton;
    private Button primaryKeyOrderingRadioButton;
    private Button customOrderingRadioButton;
    private ITextViewer orderingTextViewer;

    public OrderByComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, commandStack, widgetFactory);
    }

    private Adapter buildOrderingListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                OrderByComposite.this.orderByChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Group orderByGroup = this.getWidgetFactory().createGroup(composite, JptUiMappingsMessages.OrderByComposite_orderByGroup);
        orderByGroup.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        orderByGroup.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)orderByGroup, "org.eclipse.jpt.ui.mapping_orderBy");
        this.noOrderingRadioButton = this.buildNoOrderingRadioButton((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.noOrderingRadioButton.setLayoutData((Object)gridData);
        this.primaryKeyOrderingRadioButton = this.buildPrimaryKeyOrderingRadioButton((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.primaryKeyOrderingRadioButton.setLayoutData((Object)gridData);
        this.customOrderingRadioButton = this.buildCustomOrderingRadioButton((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.customOrderingRadioButton.setLayoutData((Object)gridData);
        this.orderingTextViewer = this.buildOrderByTestViewer((Composite)orderByGroup);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 15;
        this.orderingTextViewer.getTextWidget().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.orderingTextViewer.getTextWidget(), "org.eclipse.jpt.ui.mapping_orderBy");
    }

    private Button buildNoOrderingRadioButton(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.OrderByComposite_noOrdering, 16);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrderByComposite.this.noOrderingRadioButtonSelected(e);
            }
        });
        return button;
    }

    void noOrderingRadioButtonSelected(SelectionEvent e) {
        if (!((Button)e.widget).getSelection()) {
            return;
        }
        if (this.orderBy.getType() == OrderingType.NONE) {
            return;
        }
        this.orderBy.setType(OrderingType.NONE);
        this.orderBy.setValue(null);
    }

    private Button buildPrimaryKeyOrderingRadioButton(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.OrderByComposite_primaryKeyOrdering, 16);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrderByComposite.this.primaryKeyOrderingRadioButtonSelected(e);
            }
        });
        return button;
    }

    void primaryKeyOrderingRadioButtonSelected(SelectionEvent e) {
        if (!((Button)e.widget).getSelection()) {
            return;
        }
        if (this.orderBy.getType() == OrderingType.PRIMARY_KEY) {
            return;
        }
        this.orderBy.setType(OrderingType.PRIMARY_KEY);
    }

    private Button buildCustomOrderingRadioButton(Composite parent) {
        Button button = this.getWidgetFactory().createButton(parent, JptUiMappingsMessages.OrderByComposite_customOrdering, 16);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OrderByComposite.this.customOrderingRadioButtonSelected(e);
            }
        });
        return button;
    }

    void customOrderingRadioButtonSelected(SelectionEvent e) {
        if (!((Button)e.widget).getSelection()) {
            return;
        }
        if (this.orderBy.getType() == OrderingType.CUSTOM) {
            return;
        }
        this.orderBy.setType(OrderingType.CUSTOM);
    }

    private ITextViewer buildOrderByTestViewer(Composite parent) {
        TextViewer textViewer = new TextViewer(parent, 2052);
        textViewer.setDocument((IDocument)new Document());
        textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                OrderByComposite.this.orderingTextViewerChanged();
            }
        });
        return textViewer;
    }

    private void orderingTextViewerChanged() {
        if (this.isPopulating()) {
            return;
        }
        String orderByValue = this.orderingTextViewer.getDocument().get();
        if (orderByValue.equals(this.orderBy.getValue())) {
            return;
        }
        this.orderBy.setValue(orderByValue);
    }

    private void orderByChanged(Notification notification) {
        if (notification.getFeatureID(IOrderBy.class) == 0 || notification.getFeatureID(IOrderBy.class) == 1) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    OrderByComposite.this.populate();
                }
            });
        }
    }

    protected void doPopulate(EObject obj) {
        this.orderBy = (IOrderBy)obj;
        if (this.orderBy == null) {
            return;
        }
        this.populateOrderingRadioButtons();
    }

    protected void doPopulate() {
        this.populateOrderingRadioButtons();
    }

    protected void engageListeners() {
        if (this.orderBy != null) {
            this.orderBy.eAdapters().add((Object)this.orderingListener);
        }
    }

    protected void disengageListeners() {
        if (this.orderBy != null) {
            this.orderBy.eAdapters().remove((Object)this.orderingListener);
        }
    }

    private void populateOrderingRadioButtons() {
        if (this.orderBy.getType() == OrderingType.NONE) {
            this.primaryKeyOrderingRadioButton.setSelection(false);
            this.customOrderingRadioButton.setSelection(false);
            this.noOrderingRadioButton.setSelection(true);
            if (!"".equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set("");
            }
        } else if (this.orderBy.getType() == OrderingType.PRIMARY_KEY) {
            this.customOrderingRadioButton.setSelection(false);
            this.noOrderingRadioButton.setSelection(false);
            this.primaryKeyOrderingRadioButton.setSelection(true);
            String value = this.orderBy.getValue();
            if (value != null && !value.equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set(value);
            } else if (!"".equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set("");
            }
        } else if (this.orderBy.getType() == OrderingType.CUSTOM) {
            this.noOrderingRadioButton.setSelection(false);
            this.primaryKeyOrderingRadioButton.setSelection(false);
            this.customOrderingRadioButton.setSelection(true);
            String value = this.orderBy.getValue();
            if (value != null && !value.equals(this.orderingTextViewer.getDocument().get())) {
                this.orderingTextViewer.getDocument().set(value);
            }
        }
        this.orderingTextViewer.setEditable(this.orderBy.getType() == OrderingType.CUSTOM);
        this.orderingTextViewer.getTextWidget().setEnabled(this.orderBy.getType() == OrderingType.CUSTOM);
    }
}

