/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.mappings.IId;
import org.eclipse.jpt.core.internal.mappings.ISequenceGenerator;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.GeneratorComposite;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceGeneratorComposite
extends GeneratorComposite<ISequenceGenerator> {
    private CCombo sequenceNameCombo;
    private ModifyListener sequenceNameComboListener;
    private ConnectionProfile connectionProfile;

    public SequenceGeneratorComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, commandStack, widgetFactory);
    }

    @Override
    protected ISequenceGenerator createGenerator() {
        ISequenceGenerator sequenceGenerator = this.idMapping().createSequenceGenerator();
        this.idMapping().setSequenceGenerator(sequenceGenerator);
        return sequenceGenerator;
    }

    @Override
    protected ISequenceGenerator generator(IId idMapping) {
        return idMapping.getSequenceGenerator();
    }

    @Override
    protected void initializeLayout(Composite composite) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.SequenceGeneratorComposite_name);
        this.nameTextWidget = this.buildNameText(composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.nameTextWidget.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.nameTextWidget, "org.eclipse.jpt.ui.mapping_sequenceGeneratorName");
        this.getWidgetFactory().createLabel(composite, JptUiMappingsMessages.SequenceGeneratorComposite_sequence);
        this.sequenceNameCombo = this.buildSequenceNameCombo(composite);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.sequenceNameCombo.setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.sequenceNameCombo, "org.eclipse.jpt.ui.mapping_sequenceGeneratorSequence");
    }

    private CCombo buildSequenceNameCombo(Composite parent) {
        CCombo combo = this.getWidgetFactory().createCCombo(parent, 0x800000);
        combo.add("");
        combo.select(0);
        combo.addModifyListener(this.getSequenceNameListener());
        return combo;
    }

    private ModifyListener getSequenceNameListener() {
        if (this.sequenceNameComboListener == null) {
            this.sequenceNameComboListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ISequenceGenerator generator;
                    if (SequenceGeneratorComposite.this.isPopulating()) {
                        return;
                    }
                    String text = ((CCombo)e.getSource()).getText();
                    if (text != null && SequenceGeneratorComposite.this.sequenceNameCombo.getItemCount() > 0 && text.equals(SequenceGeneratorComposite.this.sequenceNameCombo.getItem(0))) {
                        text = null;
                    }
                    if ((generator = (ISequenceGenerator)SequenceGeneratorComposite.this.getGenerator()) == null) {
                        generator = SequenceGeneratorComposite.this.createGenerator();
                    }
                    generator.setSpecifiedSequenceName(text);
                }
            };
        }
        return this.sequenceNameComboListener;
    }

    @Override
    protected void generatorChanged(Notification notification) {
        super.generatorChanged(notification);
        if (notification.getFeatureID(ISequenceGenerator.class) == 8) {
            final String sequenceName = notification.getNewStringValue();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (SequenceGeneratorComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    if (sequenceName == null) {
                        SequenceGeneratorComposite.this.sequenceNameCombo.select(0);
                    } else if (!SequenceGeneratorComposite.this.sequenceNameCombo.getText().equals(sequenceName)) {
                        SequenceGeneratorComposite.this.sequenceNameCombo.setText(sequenceName);
                    }
                }
            });
        }
    }

    @Override
    protected void doPopulate(EObject obj) {
        super.doPopulate(obj);
        if (obj == null) {
            return;
        }
        this.populateSequenceNameCombo();
    }

    @Override
    protected void doPopulate() {
        this.populateSequenceNameCombo();
    }

    private ConnectionProfile getConnectionProfile() {
        if (this.connectionProfile == null) {
            IJpaProject jpaProject = ((ISequenceGenerator)this.getGenerator()).getJpaProject();
            this.connectionProfile = jpaProject.connectionProfile();
        }
        return this.connectionProfile;
    }

    private void populateSequenceNameCombo() {
        if (this.getGenerator() == null) {
            return;
        }
        this.sequenceNameCombo.setItem(0, JptUiMappingsMessages.SequenceGeneratorComposite_default);
        this.getConnectionProfile().isConnected();
        String sequenceName = ((ISequenceGenerator)this.getGenerator()).getSpecifiedSequenceName();
        if (sequenceName != null) {
            if (!this.sequenceNameCombo.getText().equals(sequenceName)) {
                this.sequenceNameCombo.setText(sequenceName);
            }
        } else {
            this.sequenceNameCombo.select(0);
        }
    }

    @Override
    protected void clear() {
        super.clear();
        this.sequenceNameCombo.select(0);
    }
}

