/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.TypingPreferences;
import org.eclipse.php.internal.ui.editor.util.PHPDocBlockSerialezer;
import org.eclipse.php.internal.ui.editor.util.PHPDocTool;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class DocBlockAutoEditStrategy
implements IAutoEditStrategy {
    private static final String lineStart = "* ";

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (TypingPreferences.closePhpdoc && documentCommand.text != null && TextUtilities.endsWith((String[])iDocument.getLegalLineDelimiters(), (String)documentCommand.text) != -1) {
            this.autoEditAfterNewLine((IStructuredDocument)iDocument, documentCommand);
        }
    }

    private void autoEditAfterNewLine(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) {
        try {
            Matcher matcher;
            IRegion iRegion = iStructuredDocument.getLineInformationOfOffset(documentCommand.offset);
            int n = iRegion.getOffset();
            String string = iStructuredDocument.get(n, iRegion.getLength());
            String string2 = this.getBlanks(string);
            String string3 = string.trim();
            boolean bl = false;
            boolean bl2 = true;
            int n2 = string3.indexOf("/*");
            if (n2 != -1) {
                if (documentCommand.offset + documentCommand.length < n + n2 + 2) {
                    return;
                }
                bl = true;
                if (string3.indexOf("/**") != n2) {
                    bl2 = false;
                }
            }
            if ((matcher = Pattern.compile("/\\*.*\\*/").matcher(string3)).find()) {
                return;
            }
            if (bl) {
                int n3;
                string2 = String.valueOf(string2) + ' ';
                documentCommand.text = String.valueOf(documentCommand.text) + string2;
                int n4 = string.indexOf("/*");
                String string4 = FormatterUtils.getPartitionType((IStructuredDocument)iStructuredDocument, (int)(n + n4 - 1));
                if ((string4 == "org.eclipse.php.PHP_DEFAULT" || string4 == "org.eclipse.php.PHP_DOC" || string4 == "org.eclipse.php.PHP_MULTI_LINE_COMMENT") && (n3 = this.handleDocBlockStart(iStructuredDocument, documentCommand, string2, bl2)) != -1) {
                    iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                    documentCommand.offset = n3;
                    documentCommand.length = 0;
                    documentCommand.text = "";
                    iStructuredDocument.getUndoManager().disableUndoManagement();
                    iStructuredDocument.replace(documentCommand.offset, documentCommand.length, documentCommand.text);
                    iStructuredDocument.getUndoManager().enableUndoManagement();
                }
                return;
            }
            boolean bl3 = iStructuredDocument.get(n, documentCommand.offset - n).endsWith("*/");
            if (!bl3 && string3.length() > 0 && string3.charAt(0) == '*') {
                documentCommand.text = String.valueOf(documentCommand.text) + string2 + lineStart;
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
    }

    private String getBlanks(String string) {
        int n = string.indexOf("/*");
        if (n < 0) {
            n = string.indexOf("*");
        }
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                if (string.charAt(n2) == '\t') {
                    stringBuffer.append('\t');
                } else {
                    stringBuffer.append(' ');
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        return " ";
    }

    /*
     * Unable to fully structure code
     */
    private int handleDocBlockStart(IStructuredDocument var1_1, DocumentCommand var2_2, String var3_3, boolean var4_4) {
        block13: {
            block12: {
                block14: {
                    block11: {
                        var5_5 = 0;
                        var6_6 = var1_1.getLineInformationOfOffset(var2_2.offset);
                        var7_8 = var6_6.getOffset();
                        var8_9 = var1_1.get(var7_8, var2_2.offset - var7_8);
                        var9_10 = Pattern.compile("\\/\\*+").matcher(var8_9);
                        var9_10.find();
                        var10_11 = var8_9.substring(var9_10.start(), var9_10.end());
                        var11_12 = var10_11.length();
                        var2_2.text = String.valueOf(var2_2.text) + "* ";
                        var5_5 = var2_2.offset + var2_2.text.length();
                        var12_13 = var2_2.offset + var2_2.length;
                        if (!this.isInsideExistingDocBlock(var1_1, var12_13)) break block11;
lbl15:
                        // 3 sources

                        while (true) {
                            var1_1.getUndoManager().enableUndoManagement();
                            return -1;
                        }
                    }
                    var13_14 = var8_9.substring(var8_9.indexOf(var10_11) + var11_12).trim();
                    var5_5 = (var7_8 += var8_9.indexOf(var10_11)) + var11_12 + var2_2.text.length();
                    var14_15 = var12_13;
                    if (var12_13 < var6_6.getOffset() + var6_6.getLength()) {
                        var6_6 = var1_1.getLineInformationOfOffset(var12_13);
                    }
                    if (!var4_4 || !TypingPreferences.addDocTags) break block12;
                    var1_1.replace(var7_8, var14_15 - var7_8, "");
                    var2_2.offset = var7_8;
                    var15_16 = (DOMModelForPHP)StructuredModelManager.getModelManager().getModelForRead(var1_1);
                    var15_16.updateFileData();
                    if (var13_14.equals("")) {
                        var13_14 = null;
                    }
                    var16_17 = this.getDocBlockStub(var15_16, var1_1, var7_8, var13_14);
                    var15_16.releaseFromRead();
                    var2_2.offset += var10_11.length();
                    var1_1.replace(var7_8, 0, var10_11);
                    if (var16_17 == null) ** GOTO lbl60
                    var2_2.text = var16_17.substring(3);
                    if (var13_14 != null) break block14;
                    var17_18 = var15_16.getFileData().getName();
                    var18_19 = PHPUiPlugin.getWorkspace().getRoot().getFile((IPath)new Path(var17_18));
                    try {
                        var19_20 = EditorUtility.openInEditor(var18_19, true);
                    }
                    catch (PartInitException var20_21) {
                        Logger.logException(var20_21);
                        var2_2.text = String.valueOf(var10_11) + var2_2.text;
                        ** GOTO lbl15
                    }
                    var20_22 = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)var19_20);
                    Display.getDefault().asyncExec((Runnable)new SelectText(var2_2.offset + var2_2.text.indexOf("E"), 25, (ITextEditor)var20_22));
                    ** continue;
                }
                var22_23 = var5_5 + var13_14.length();
                var1_1.getUndoManager().enableUndoManagement();
                return var22_23;
            }
            try {
                try {
                    var2_2.length += var2_2.offset - var7_8 - var11_12;
                    var2_2.offset = var7_8 + var11_12;
lbl60:
                    // 2 sources

                    var7_8 += var11_12;
                    if (var13_14 == null || var13_14.equals("")) break block13;
                    var2_2.text = String.valueOf(var2_2.text) + var13_14;
                    var5_5 = var7_8 + var2_2.text.length();
                }
                catch (BadLocationException var6_7) {
                    Logger.logException(var6_7);
                    var1_1.getUndoManager().enableUndoManagement();
                }
            }
            catch (Throwable var21_24) {
                var1_1.getUndoManager().enableUndoManagement();
                throw var21_24;
            }
        }
        var1_1.getUndoManager().enableUndoManagement();
        var2_2.text = String.valueOf(var2_2.text) + var1_1.getLineDelimiter() + var3_3 + "*/";
        return var5_5;
    }

    private boolean isInsideExistingDocBlock(IStructuredDocument iStructuredDocument, int n) {
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        boolean bl = true;
        while (iStructuredDocumentRegion != null) {
            int n2;
            String string = iStructuredDocumentRegion.getText();
            if (bl) {
                bl = false;
                string = string.substring(n - iStructuredDocumentRegion.getStartOffset());
            }
            if ((n2 = string.length()) == 0) {
                iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
                continue;
            }
            char c = string.charAt(0);
            int n3 = 1;
            while (n3 < n2) {
                char c2 = string.charAt(n3);
                if (c == '*' && c2 == '/') {
                    return true;
                }
                if (c == '/' && c2 == '*') {
                    return false;
                }
                c = c2;
                ++n3;
            }
            iStructuredDocumentRegion = iStructuredDocumentRegion.getNext();
        }
        return false;
    }

    private String getDocBlockStub(DOMModelForPHP dOMModelForPHP, IStructuredDocument iStructuredDocument, int n, String string) {
        PHPFileData pHPFileData = dOMModelForPHP.getFileData();
        if (pHPFileData == null) {
            return null;
        }
        PHPCodeData pHPCodeData = this.getClosestCodeData(iStructuredDocument, pHPFileData, n);
        if (pHPCodeData == null) {
            return null;
        }
        PHPDocBlock pHPDocBlock = PHPDocTool.createPhpDoc((CodeData)pHPCodeData, string, (IDocument)iStructuredDocument);
        return PHPDocBlockSerialezer.instance().createDocBlockText(iStructuredDocument, pHPDocBlock, n, false);
    }

    private PHPCodeData getClosestCodeData(IStructuredDocument iStructuredDocument, PHPFileData pHPFileData, int n) {
        int n2;
        int n3;
        int n4;
        PHPClassData pHPClassData = null;
        int n5 = iStructuredDocument.getLength();
        PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
        int n6 = 0;
        while (n6 < pHPClassDataArray.length) {
            PHPClassData pHPClassData2 = pHPClassDataArray[n6];
            n4 = pHPClassData2.getUserData().getStartPosition();
            if (n4 < n) {
                n3 = pHPClassData2.getUserData().getEndPosition();
                if (n3 > n) {
                    return this.getClosestCodeDataFromClass(iStructuredDocument, pHPClassData2, n);
                }
            } else if (n4 < n5) {
                n5 = n4;
                pHPClassData = pHPClassData2;
            }
            ++n6;
        }
        PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
        int n7 = 0;
        while (n7 < pHPFunctionDataArray.length) {
            PHPFunctionData pHPFunctionData = pHPFunctionDataArray[n7];
            n3 = pHPFunctionData.getUserData().getStartPosition();
            if (n3 < n) {
                n2 = pHPFunctionData.getUserData().getEndPosition();
                if (n2 > n) {
                    return null;
                }
            } else if (n3 < n5) {
                n5 = n3;
                pHPClassData = pHPFunctionData;
            }
            ++n7;
        }
        PHPConstantData[] pHPConstantDataArray = pHPFileData.getConstants();
        n4 = 0;
        while (n4 < pHPConstantDataArray.length) {
            PHPConstantData pHPConstantData = pHPConstantDataArray[n4];
            n2 = pHPConstantData.getUserData().getStartPosition();
            if (n2 < n) {
                int n8 = pHPConstantData.getUserData().getEndPosition();
                if (n8 > n) {
                    return null;
                }
            } else if (n2 < n5) {
                n5 = n2;
                pHPClassData = pHPConstantData;
            }
            ++n4;
        }
        if (pHPClassData != null && this.isNoCodeBetween(iStructuredDocument, n, n5)) {
            return pHPClassData;
        }
        return null;
    }

    private PHPCodeData getClosestCodeDataFromClass(IStructuredDocument iStructuredDocument, PHPClassData pHPClassData, int n) {
        int n2;
        int n3;
        int n4;
        PHPFunctionData pHPFunctionData = null;
        int n5 = iStructuredDocument.getLength();
        PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
        int n6 = 0;
        while (n6 < pHPFunctionDataArray.length) {
            PHPFunctionData pHPFunctionData2 = pHPFunctionDataArray[n6];
            n4 = pHPFunctionData2.getUserData().getStartPosition();
            if (n4 < n) {
                n3 = pHPFunctionData2.getUserData().getEndPosition();
                if (n3 > n) {
                    return null;
                }
            } else if (n4 < n5) {
                n5 = n4;
                pHPFunctionData = pHPFunctionData2;
            }
            ++n6;
        }
        PHPClassConstData[] pHPClassConstDataArray = pHPClassData.getConsts();
        int n7 = 0;
        while (n7 < pHPClassConstDataArray.length) {
            PHPClassConstData pHPClassConstData = pHPClassConstDataArray[n7];
            n3 = pHPClassConstData.getUserData().getStartPosition();
            if (n3 < n) {
                n2 = pHPClassConstData.getUserData().getEndPosition();
                if (n2 > n) {
                    return null;
                }
            } else if (n3 < n5) {
                n5 = n3;
                pHPFunctionData = pHPClassConstData;
            }
            ++n7;
        }
        PHPClassVarData[] pHPClassVarDataArray = pHPClassData.getVars();
        n4 = 0;
        while (n4 < pHPClassVarDataArray.length) {
            PHPClassVarData pHPClassVarData = pHPClassVarDataArray[n4];
            n2 = pHPClassVarData.getUserData().getStartPosition();
            if (n2 < n) {
                int n8 = pHPClassVarData.getUserData().getEndPosition();
                if (n8 > n) {
                    return null;
                }
            } else if (n2 < n5) {
                n5 = n2;
                pHPFunctionData = pHPClassVarData;
            }
            ++n4;
        }
        if (pHPFunctionData != null && this.isNoCodeBetween(iStructuredDocument, n, n5)) {
            return pHPFunctionData;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isNoCodeBetween(IStructuredDocument iStructuredDocument, int n, int n2) {
        int n3 = n;
        try {
            ITextRegionContainer iTextRegionContainer;
            IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n3);
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n3);
            if (iTextRegion.getType().equals("PHP_CLOSE")) {
                iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n3 - 1);
            }
            int n4 = iStructuredDocumentRegion.getStartOffset(iTextRegion);
            if (iTextRegion instanceof ITextRegionContainer) {
                iTextRegionContainer = (ITextRegionContainer)iTextRegion;
                iTextRegion = iTextRegionContainer.getRegionAtCharacterOffset(n3);
                n4 += iTextRegion.getStart();
            }
            if (!(iTextRegion instanceof PhpScriptRegion)) return true;
            iTextRegionContainer = (PhpScriptRegion)iTextRegion;
            while (iTextRegion != null) {
                if (n3 >= n2) return true;
                if (n3 - n4 <= 0) {
                    return true;
                }
                iTextRegion = iTextRegionContainer.getPhpToken(n3 - n4);
                if (iTextRegion == null) continue;
                String string = iTextRegion.getType();
                if (string != "PHP_LINE_COMMENT") {
                    if (n4 + iTextRegion.getTextEnd() >= n3) return false;
                }
                n3 = n4 + iTextRegion.getEnd() + 1;
            }
            return true;
        }
        catch (BadLocationException badLocationException) {}
        return true;
    }

    private class SelectText
    implements Runnable {
        int offset;
        int length;
        ITextEditor textEditor;

        public SelectText(int n, int n2, ITextEditor iTextEditor) {
            this.offset = n;
            this.length = n2;
            this.textEditor = iTextEditor;
        }

        public void run() {
            EditorUtility.revealInEditor((IEditorPart)this.textEditor, this.offset, this.length);
        }
    }
}

