/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.documentModel.dom.Utils;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SortAction;
import org.eclipse.php.internal.ui.outline.ChangeOutlineModeAction;
import org.eclipse.php.internal.ui.outline.PHPNodeActionManager;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.outline.PHPOutlineLabelProvider;
import org.eclipse.php.internal.ui.outline.ShowGroupsAction;
import org.eclipse.php.internal.ui.treecontent.TreeProvider;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.php.internal.ui.util.PHPOutlineElementComparer;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.html.ui.views.contentoutline.HTMLContentOutlineConfiguration;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;

public class PHPContentOutlineConfiguration
extends HTMLContentOutlineConfiguration {
    private PHPOutlineContentProvider fContentProvider = null;
    private PHPOutlineLabelProvider fLabelProvider = null;
    IPHPTreeContentProvider[] treeProviders;
    DoubleClickListener doubleClickListener = new DoubleClickListener();
    private SortAction sortAction;
    private JFaceNodeLabelProvider fSimpleLabelProvider;

    protected IContributionItem[] createMenuContributions(TreeViewer treeViewer) {
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)new ChangeOutlineModeAction(PHPUIMessages.PHPOutlinePage_mode_php, 1, treeViewer));
        ChangeOutlineModeAction changeOutlineModeAction = new ChangeOutlineModeAction(PHPUIMessages.PHPOutlinePage_mode_html, 2, treeViewer);
        changeOutlineModeAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("checked")) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    if (PHPContentOutlineConfiguration.this.sortAction != null) {
                        PHPContentOutlineConfiguration.this.sortAction.setEnabled(!bl);
                    }
                }
            }
        });
        ActionContributionItem actionContributionItem2 = new ActionContributionItem((IAction)changeOutlineModeAction);
        IContributionItem[] iContributionItemArray = super.createMenuContributions(treeViewer);
        if (iContributionItemArray == null) {
            iContributionItemArray = new IContributionItem[]{actionContributionItem, actionContributionItem2};
        } else {
            IContributionItem[] iContributionItemArray2 = new IContributionItem[iContributionItemArray.length + 2];
            System.arraycopy(iContributionItemArray, 0, iContributionItemArray2, 0, iContributionItemArray.length);
            iContributionItemArray2[iContributionItemArray.length] = actionContributionItem;
            iContributionItemArray2[iContributionItemArray.length + 1] = actionContributionItem2;
            iContributionItemArray = iContributionItemArray2;
        }
        if (changeOutlineModeAction.isChecked()) {
            this.sortAction.setEnabled(false);
        }
        return iContributionItemArray;
    }

    public DoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }

    protected IContributionItem[] createToolbarContributions(TreeViewer treeViewer) {
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)new ShowGroupsAction("Show Groups", treeViewer));
        IContributionItem iContributionItem = super.createMenuContributions(treeViewer)[0];
        this.sortAction = new SortAction(treeViewer);
        ActionContributionItem actionContributionItem2 = new ActionContributionItem((IAction)this.sortAction);
        IContributionItem[] iContributionItemArray = super.createToolbarContributions(treeViewer);
        if (iContributionItemArray == null) {
            iContributionItemArray = new IContributionItem[]{actionContributionItem2, actionContributionItem};
        } else {
            IContributionItem[] iContributionItemArray2 = new IContributionItem[iContributionItemArray.length + 3];
            System.arraycopy(iContributionItemArray, 0, iContributionItemArray2, 0, iContributionItemArray.length);
            iContributionItemArray2[iContributionItemArray.length] = actionContributionItem2;
            iContributionItemArray2[iContributionItemArray.length + 1] = actionContributionItem;
            iContributionItemArray2[iContributionItemArray.length + 2] = iContributionItem;
            iContributionItemArray = iContributionItemArray2;
        }
        return iContributionItemArray;
    }

    public IContentProvider getContentProvider(TreeViewer treeViewer) {
        if (this.fContentProvider == null) {
            treeViewer.setComparer((IElementComparer)new PHPOutlineElementComparer());
            PHPOutlineLabelProvider pHPOutlineLabelProvider = (PHPOutlineLabelProvider)this.getLabelProvider(treeViewer);
            this.fContentProvider = new PHPOutlineContentProvider(treeViewer, pHPOutlineLabelProvider);
            this.fContentProvider.phpContentProvider.setTreeProviders(this.getTreeProviders());
        }
        return this.fContentProvider;
    }

    public ILabelProvider getLabelProvider(TreeViewer treeViewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new PHPOutlineLabelProvider();
            this.fLabelProvider.setTreeProviders(this.getTreeProviders());
        }
        return this.fLabelProvider;
    }

    public ISelection getSelection(TreeViewer treeViewer, ISelection iSelection) {
        IContentProvider iContentProvider = treeViewer.getContentProvider();
        if (iContentProvider instanceof PHPOutlineContentProvider) {
            PHPCodeData pHPCodeData;
            IStructuredSelection iStructuredSelection;
            Object object;
            PHPOutlineContentProvider pHPOutlineContentProvider = (PHPOutlineContentProvider)iContentProvider;
            if (pHPOutlineContentProvider.mode == 1 && iSelection instanceof IStructuredSelection && iSelection instanceof TextSelection && (object = (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement()) instanceof NodeImpl && (pHPCodeData = Utils.getPHPCodeData((NodeImpl)((NodeImpl)object), (int)((TextSelection)iSelection).getOffset())) != null) {
                return new StructuredSelection((Object)pHPCodeData);
            }
        }
        return super.getSelection(treeViewer, iSelection);
    }

    private IPHPTreeContentProvider[] getTreeProviders() {
        if (this.treeProviders == null) {
            this.treeProviders = TreeProvider.getTreeProviders("org.eclipse.ui.views.ContentOutline");
        }
        return this.treeProviders;
    }

    public ILabelProvider getStatusLineLabelProvider(TreeViewer treeViewer) {
        if (this.fSimpleLabelProvider == null) {
            this.fSimpleLabelProvider = new StatusLineLabelProvider(treeViewer);
        }
        return this.fSimpleLabelProvider;
    }

    protected XMLNodeActionManager createNodeActionManager(TreeViewer treeViewer) {
        return new PHPNodeActionManager((IStructuredModel)treeViewer.getInput(), (Viewer)treeViewer);
    }

    public static class DoubleClickListener
    implements IDoubleClickListener {
        private boolean enabled;

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            ISelection iSelection = doubleClickEvent.getSelection();
            if (!(iSelection instanceof IStructuredSelection)) {
                return;
            }
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            if (!(object instanceof PHPCodeData)) {
                return;
            }
            try {
                IEditorPart iEditorPart = EditorUtility.openInEditor(object, true);
                if (iEditorPart != null) {
                    EditorUtility.revealInEditor(iEditorPart, (PHPCodeData)object);
                }
            }
            catch (PartInitException partInitException) {}
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private class StatusLineLabelProvider
    extends JFaceNodeLabelProvider {
        TreeViewer treeViewer = null;

        public StatusLineLabelProvider(TreeViewer treeViewer) {
            this.treeViewer = treeViewer;
        }

        public String getText(Object object) {
            if (object == null) {
                return null;
            }
            return PHPElementLabels.getTextLabel(object, 1090519051L);
        }
    }
}

