/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.io.CharArrayReader;
import java.io.Reader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPhp;
import org.eclipse.php.internal.ui.util.PHPColorHelper;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.sse.ui.internal.util.Sorter;
import org.w3c.dom.Node;

public class PHPStyledTextColorPicker
extends Composite {
    public static final String BACKGROUND = "background";
    public static final String BOLD = "bold";
    public static final String COLOR = "color";
    public static final String FOREGROUND = "foreground";
    public static final String ITALIC = "italic";
    public static final String NAME = "name";
    protected static final boolean showItalic = true;
    protected AccessibleControlListener backgroundAccListener = new AccessibleControlAdapter(){

        public void getValue(AccessibleControlEvent accessibleControlEvent) {
            if (accessibleControlEvent.childID == -1) {
                accessibleControlEvent.result = PHPStyledTextColorPicker.this.fBackground.getColorValue().toString();
            }
        }
    };
    protected SelectionListener buttonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            String string = PHPStyledTextColorPicker.this.getStyleName(PHPStyledTextColorPicker.this.fStyleCombo.getItem(PHPStyledTextColorPicker.this.fStyleCombo.getSelectionIndex()));
            if (string == null) {
                return;
            }
            if (selectionEvent.widget == PHPStyledTextColorPicker.this.fBold) {
                String string2 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                String[] stringArray = PHPColorHelper.unpackStylePreferences(string2);
                if (stringArray != null) {
                    String string3 = stringArray[2];
                    String string4 = String.valueOf(PHPStyledTextColorPicker.this.fBold.getSelection());
                    if (!string4.equals(string3)) {
                        stringArray[2] = string4;
                        String string5 = PHPColorHelper.packStylePreferences(stringArray);
                        PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string5);
                        PHPStyledTextColorPicker.this.refresh();
                    }
                }
            } else if (selectionEvent.widget == PHPStyledTextColorPicker.this.fItalic) {
                String string6 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                String[] stringArray = PHPColorHelper.unpackStylePreferences(string6);
                if (stringArray != null) {
                    String string7 = stringArray[3];
                    String string8 = String.valueOf(PHPStyledTextColorPicker.this.fItalic.getSelection());
                    if (!string8.equals(string7)) {
                        stringArray[3] = string8;
                        String string9 = PHPColorHelper.packStylePreferences(stringArray);
                        PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string9);
                        PHPStyledTextColorPicker.this.refresh();
                    }
                }
            } else if (selectionEvent.widget == PHPStyledTextColorPicker.this.fUnderline) {
                String string10 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                String[] stringArray = PHPColorHelper.unpackStylePreferences(string10);
                if (stringArray != null) {
                    String string11 = stringArray[4];
                    String string12 = String.valueOf(PHPStyledTextColorPicker.this.fUnderline.getSelection());
                    if (!string12.equals(string11)) {
                        stringArray[4] = string12;
                        String string13 = PHPColorHelper.packStylePreferences(stringArray);
                        PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string13);
                        PHPStyledTextColorPicker.this.refresh();
                    }
                }
            } else if (selectionEvent.widget == PHPStyledTextColorPicker.this.fClearStyle) {
                PHPStyledTextColorPicker.this.getPreferenceStore().setToDefault(string);
                PHPStyledTextColorPicker.this.refresh();
            }
        }
    };
    protected SelectionListener comboListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = PHPStyledTextColorPicker.this.fStyleCombo.getSelectionIndex();
            String string = n >= 0 ? PHPStyledTextColorPicker.this.fStyleCombo.getItem(n) : null;
            PHPStyledTextColorPicker.this.activate(PHPStyledTextColorPicker.this.getStyleName(string));
        }
    };
    protected ColorSelector fBackground;
    protected Label fBackgroundLabel;
    protected Button fBold;
    protected Button fClearStyle;
    protected Dictionary fContextStyleMap = null;
    protected Color fDefaultBackground = this.getDisplay().getSystemColor(25);
    protected Color fDefaultForeground = this.getDisplay().getSystemColor(24);
    protected Dictionary fDescriptions = null;
    protected ColorSelector fForeground;
    protected Label fForegroundLabel;
    protected String fInput = "";
    protected Button fItalic;
    protected Button fUnderline;
    private IStructuredDocumentRegion fNodes = null;
    private IPreferenceStore fPreferenceStore;
    protected Combo fStyleCombo = null;
    protected List fStyleList = null;
    protected StyledText fText = null;
    protected LineStyleProviderForPhp fStyleProvider;
    protected RegionParser fParser = null;
    protected AccessibleControlListener foregroundAccListener = new AccessibleControlAdapter(){

        public void getValue(AccessibleControlEvent accessibleControlEvent) {
            if (accessibleControlEvent.childID == -1) {
                accessibleControlEvent.result = PHPStyledTextColorPicker.this.fForeground.getColorValue().toString();
            }
        }
    };

    public void setLineStyleProvider(LineStyleProviderForPhp lineStyleProviderForPhp) {
        this.fStyleProvider = lineStyleProviderForPhp;
        if (this.fPreferenceStore != null) {
            this.fStyleProvider.setColorPreferences(this.fPreferenceStore);
        }
    }

    public LineStyleProviderForPhp getLineStyleProvider() {
        return this.fStyleProvider;
    }

    public PHPStyledTextColorPicker(Composite composite, int n) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.createControls(this);
    }

    protected void activate(String string) {
        if (string == null) {
            this.fForeground.setEnabled(false);
            this.fBackground.setEnabled(false);
            this.fClearStyle.setEnabled(false);
            this.fBold.setEnabled(false);
            this.fItalic.setEnabled(false);
            this.fUnderline.setEnabled(false);
            this.fForegroundLabel.setEnabled(false);
            this.fBackgroundLabel.setEnabled(false);
        } else {
            this.fForeground.setEnabled(true);
            this.fBackground.setEnabled(true);
            this.fClearStyle.setEnabled(true);
            this.fBold.setEnabled(true);
            this.fItalic.setEnabled(true);
            this.fUnderline.setEnabled(true);
            this.fForegroundLabel.setEnabled(true);
            this.fBackgroundLabel.setEnabled(true);
        }
        TextAttribute textAttribute = this.getAttribute(string);
        Color color = textAttribute.getForeground();
        if (color == null) {
            color = this.fDefaultForeground;
        }
        this.fForeground.setColorValue(color.getRGB());
        color = textAttribute.getBackground();
        if (color == null) {
            color = this.fDefaultBackground;
        }
        this.fBackground.setColorValue(color.getRGB());
        this.fBold.setSelection((textAttribute.getStyle() & 1) != 0);
        this.fItalic.setSelection((textAttribute.getStyle() & 2) != 0);
        this.fUnderline.setSelection((textAttribute.getStyle() & 0x40000000) != 0);
    }

    protected void applyStyles() {
        if (this.fText == null || this.fText.isDisposed() || this.fInput == null || this.fInput.length() == 0) {
            return;
        }
        this.fStyleProvider.loadColors();
        IStructuredDocumentRegion iStructuredDocumentRegion = this.fNodes;
        ArrayList arrayList = new ArrayList();
        this.fStyleProvider.prepareTextRegions(iStructuredDocumentRegion, 0, this.fNodes.getEnd(), arrayList);
        for (StyleRange styleRange : arrayList) {
            this.fText.setStyleRange(styleRange);
        }
    }

    protected void close() {
    }

    private Button createCheckBox(Composite composite, String string) {
        Button button = new Button(composite, 0x1000020);
        if (string != null) {
            button.setText(string);
        }
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 128;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private Combo createCombo(Composite composite, String[] stringArray, int n) {
        Combo combo = new Combo(composite, 12);
        combo.setItems(stringArray);
        if (n >= 0) {
            combo.select(n);
        }
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 256;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    private Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = n;
        gridLayout.horizontalSpacing = 5;
        gridLayout.makeColumnsEqualWidth = false;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1040);
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        return composite2;
    }

    protected void createControls(Composite composite) {
        Composite composite2 = this.createComposite(composite, 3);
        this.createLabel(composite2, SSEUIMessages.Content_type__UI_);
        this.fStyleCombo = this.createCombo(composite2, new String[0], -1);
        this.fClearStyle = this.createPushButton(composite2, SSEUIMessages.Restore_Default_UI_);
        Composite composite3 = this.createComposite(composite, 8);
        this.fForegroundLabel = this.createLabel(composite3, SSEUIMessages.Foreground_UI_);
        this.fForeground = new ColorSelector(composite3);
        this.fForeground.getButton().setLayoutData((Object)new GridData());
        this.setAccessible((Control)this.fForeground.getButton(), this.fForegroundLabel.getText());
        this.fForeground.getButton().getAccessible().addAccessibleControlListener(this.foregroundAccListener);
        ((GridData)this.fForeground.getButton().getLayoutData()).minimumWidth = 20;
        this.fBackgroundLabel = this.createLabel(composite3, SSEUIMessages.Background_UI_);
        this.fBackground = new ColorSelector(composite3);
        this.fBackground.getButton().setLayoutData((Object)new GridData());
        this.setAccessible((Control)this.fBackground.getButton(), this.fBackgroundLabel.getText());
        this.fBackground.getButton().getAccessible().addAccessibleControlListener(this.backgroundAccListener);
        ((GridData)this.fBackground.getButton().getLayoutData()).minimumWidth = 20;
        this.createLabel(composite3, "");
        this.fBold = this.createCheckBox(composite3, SSEUIMessages.Bold_UI_);
        this.fItalic = this.createCheckBox(composite3, SSEUIMessages.Italics_UI);
        this.fUnderline = this.createCheckBox(composite3, PHPUIMessages.ColorPage_Underline);
        this.fForeground.setEnabled(false);
        this.fBackground.setEnabled(false);
        this.fClearStyle.setEnabled(false);
        this.fBold.setEnabled(false);
        this.fItalic.setEnabled(false);
        this.fUnderline.setEnabled(false);
        this.fForegroundLabel.setEnabled(false);
        this.fBackgroundLabel.setEnabled(false);
        Composite composite4 = this.createComposite(composite, 1);
        this.createLabel(composite4, SSEUIMessages.Sample_text__UI_);
        this.fText = new StyledText(composite4, 33557258);
        GridData gridData = new GridData(1808);
        this.fText.setLayoutData((Object)gridData);
        this.fText.setEditable(false);
        this.fText.setBackground(this.fDefaultBackground);
        this.fText.setFont(JFaceResources.getTextFont());
        this.fText.addKeyListener(this.getTextKeyListener());
        this.fText.addSelectionListener(this.getTextSelectionListener());
        this.fText.addMouseListener(this.getTextMouseListener());
        this.fText.addTraverseListener(this.getTraverseListener());
        this.setAccessible((Control)this.fText, SSEUIMessages.Sample_text__UI_);
        this.fForeground.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("colorValue")) {
                    String string = PHPStyledTextColorPicker.this.getStyleName(PHPStyledTextColorPicker.this.fStyleCombo.getItem(PHPStyledTextColorPicker.this.fStyleCombo.getSelectionIndex()));
                    String string2 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                    String[] stringArray = PHPColorHelper.unpackStylePreferences(string2);
                    if (stringArray != null) {
                        String string3 = stringArray[0];
                        String string4 = "null";
                        Object object = propertyChangeEvent.getNewValue();
                        if (object instanceof RGB) {
                            string4 = PHPColorHelper.toRGBString((RGB)((RGB)object));
                        }
                        if (!string4.equals(string3)) {
                            stringArray[0] = string4;
                            String string5 = PHPColorHelper.packStylePreferences(stringArray);
                            PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string5);
                            PHPStyledTextColorPicker.this.refresh();
                        }
                    }
                }
            }
        });
        this.fBackground.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("colorValue")) {
                    String string = PHPStyledTextColorPicker.this.getStyleName(PHPStyledTextColorPicker.this.fStyleCombo.getItem(PHPStyledTextColorPicker.this.fStyleCombo.getSelectionIndex()));
                    String string2 = PHPStyledTextColorPicker.this.getPreferenceStore().getString(string);
                    String[] stringArray = PHPColorHelper.unpackStylePreferences(string2);
                    if (stringArray != null) {
                        String string3 = stringArray[1];
                        String string4 = "null";
                        Object object = propertyChangeEvent.getNewValue();
                        if (object instanceof RGB) {
                            string4 = PHPColorHelper.toRGBString((RGB)((RGB)object));
                        }
                        if (!string4.equals(string3)) {
                            stringArray[1] = string4;
                            String string5 = PHPColorHelper.packStylePreferences(stringArray);
                            PHPStyledTextColorPicker.this.getPreferenceStore().setValue(string, string5);
                            PHPStyledTextColorPicker.this.refresh();
                        }
                    }
                }
            }
        });
        this.fClearStyle.addSelectionListener(this.buttonListener);
        this.fBold.addSelectionListener(this.buttonListener);
        this.fItalic.addSelectionListener(this.buttonListener);
        this.fUnderline.addSelectionListener(this.buttonListener);
        this.fStyleCombo.addSelectionListener(this.comboListener);
    }

    private Label createLabel(Composite composite, String string) {
        Label label = new Label(composite, 16384);
        label.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        GridData gridData = new GridData(1808);
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected TextAttribute getAttribute(String string) {
        String string2;
        String[] stringArray;
        TextAttribute textAttribute = new TextAttribute(this.getDefaultForeground(), this.getDefaultBackground(), 0);
        if (string != null && this.getPreferenceStore() != null && (stringArray = PHPColorHelper.unpackStylePreferences(string2 = this.getPreferenceStore().getString(string))) != null) {
            boolean bl;
            RGB rGB = PHPColorHelper.toRGB((String)stringArray[0]);
            RGB rGB2 = PHPColorHelper.toRGB((String)stringArray[1]);
            int n = 0;
            boolean bl2 = Boolean.valueOf(stringArray[2]);
            if (bl2) {
                n |= 1;
            }
            if (bl = Boolean.valueOf(stringArray[3]).booleanValue()) {
                n |= 2;
            }
            if (bl = Boolean.valueOf(stringArray[4]).booleanValue()) {
                n |= 0x40000000;
            }
            textAttribute = new TextAttribute(rGB != null ? EditorUtility.getColor((RGB)rGB) : null, rGB2 != null ? EditorUtility.getColor((RGB)rGB2) : null, n);
        }
        return textAttribute;
    }

    public Node getColorsNode() {
        return null;
    }

    public Dictionary getContextStyleMap() {
        return this.fContextStyleMap;
    }

    public Color getDefaultBackground() {
        return this.fDefaultBackground;
    }

    public Color getDefaultForeground() {
        return this.fDefaultForeground;
    }

    public Dictionary getDescriptions() {
        return this.fDescriptions;
    }

    public Font getFont() {
        return this.fText.getFont();
    }

    protected String getNamedStyleAtOffset(int n) {
        String string;
        Object object;
        if (n >= this.fInput.length()) {
            return this.getNamedStyleAtOffset(this.fInput.length() - 1);
        }
        if (n < 0) {
            return this.getNamedStyleAtOffset(0);
        }
        if (this.fNodes == null) {
            return null;
        }
        ITextRegion iTextRegion = this.fNodes.getRegionAtCharacterOffset(n);
        IStructuredDocumentRegion iStructuredDocumentRegion = this.fNodes;
        if (iTextRegion instanceof ITextRegionContainer) {
            iStructuredDocumentRegion = (ITextRegionContainer)iTextRegion;
            iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        }
        if (iTextRegion.getType() == "PHP_CONTENT") {
            object = (PhpScriptRegion)iTextRegion;
            try {
                string = object.getPhpTokenType(n - iStructuredDocumentRegion.getStartOffset() - object.getStart());
            }
            catch (BadLocationException badLocationException) {
                assert (false);
                return null;
            }
        } else {
            string = iTextRegion.getType() == "PHP_OPEN" ? "PHP_OPENTAG" : (iTextRegion.getType() == "PHP_CLOSE" ? "PHP_CLOSETAG" : iTextRegion.getType());
        }
        object = (String)this.getContextStyleMap().get(string);
        return object;
    }

    public RegionParser getParser() {
        return this.fParser;
    }

    private IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    public List getStyleList() {
        return this.fStyleList;
    }

    private String getStyleName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        Enumeration enumeration = this.getDescriptions().keys();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement().toString();
            if (!this.getDescriptions().get(string3).equals(string)) continue;
            string2 = string3;
            break;
        }
        return string2;
    }

    public String getText() {
        return this.fInput;
    }

    private KeyListener getTextKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.widget instanceof StyledText) {
                    int n = ((StyledText)keyEvent.widget).getCaretOffset();
                    PHPStyledTextColorPicker.this.selectColorAtOffset(n);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.widget instanceof StyledText) {
                    int n = ((StyledText)keyEvent.widget).getCaretOffset();
                    PHPStyledTextColorPicker.this.selectColorAtOffset(n);
                }
            }
        };
    }

    private MouseListener getTextMouseListener() {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (mouseEvent.widget instanceof StyledText) {
                    int n = ((StyledText)mouseEvent.widget).getCaretOffset();
                    PHPStyledTextColorPicker.this.selectColorAtOffset(n);
                }
            }
        };
    }

    private SelectionListener getTextSelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                PHPStyledTextColorPicker.this.selectColorAtOffset(selectionEvent.x);
                if (selectionEvent.widget instanceof StyledText) {
                    ((StyledText)selectionEvent.widget).setSelection(selectionEvent.x);
                }
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPStyledTextColorPicker.this.selectColorAtOffset(selectionEvent.x);
                if (selectionEvent.widget instanceof StyledText) {
                    ((StyledText)selectionEvent.widget).setSelection(selectionEvent.x);
                }
            }
        };
    }

    private TraverseListener getTraverseListener() {
        return new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                if (traverseEvent.widget instanceof StyledText && (traverseEvent.detail == 16 || traverseEvent.detail == 8)) {
                    traverseEvent.doit = true;
                }
            }
        };
    }

    public void refresh() {
        this.fText.setRedraw(false);
        int n = this.fStyleCombo.getSelectionIndex();
        String string = n >= 0 ? this.fStyleCombo.getItem(n) : null;
        this.activate(this.getStyleName(string));
        this.fText.setFont(JFaceResources.getTextFont());
        this.applyStyles();
        this.fText.setRedraw(true);
    }

    public void releasePickerResources() {
    }

    private void selectColorAtOffset(int n) {
        String string = this.getNamedStyleAtOffset(n);
        if (string == null) {
            this.fStyleCombo.deselectAll();
            this.activate(null);
            return;
        }
        String string2 = (String)this.getDescriptions().get(string);
        if (string2 == null) {
            return;
        }
        int n2 = this.fStyleCombo.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            if (this.fStyleCombo.getItem(n3).equals(string2)) {
                this.fStyleCombo.select(n3);
                break;
            }
            ++n3;
        }
        this.activate(string);
    }

    private void setAccessible(Control control, String string) {
        if (control == null) {
            return;
        }
        final String string2 = string;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (accessibleEvent.childID == -1) {
                    accessibleEvent.result = string2;
                }
            }
        });
    }

    public void setColorsNode(Node node) {
    }

    public void setContextStyleMap(Dictionary dictionary) {
        this.fContextStyleMap = dictionary;
    }

    public void setDefaultBackground(Color color) {
        this.fDefaultBackground = color;
    }

    public void setDefaultColorsNode(Node node) {
    }

    public void setDefaultForeground(Color color) {
        this.fDefaultForeground = color;
    }

    public void setDescriptions(Dictionary dictionary) {
        this.fDescriptions = dictionary;
        this.updateStyleList();
    }

    public void setFont(Font font) {
        this.fText.setFont(font);
        this.fText.redraw();
    }

    public void setGeneratorKey(String string) {
    }

    public void setParser(RegionParser regionParser) {
        this.fParser = regionParser;
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        this.fPreferenceStore = iPreferenceStore;
        if (this.fStyleProvider != null) {
            this.fStyleProvider.setColorPreferences(iPreferenceStore);
        }
    }

    public void setStyleList(List list) {
        this.fStyleList = list;
        this.updateStyleList();
    }

    public void setText(String string) {
        this.fInput = string;
        this.getParser().reset((Reader)new CharArrayReader(this.fInput.toCharArray()));
        this.fNodes = this.getParser().getDocumentRegions();
        if (this.fText != null) {
            this.fText.setText(string);
        }
        this.applyStyles();
    }

    RGB toRGB(String string, RGB rGB) {
        RGB rGB2 = PHPColorHelper.toRGB((String)string);
        if (rGB2 == null) {
            return rGB;
        }
        return rGB2;
    }

    private void updateStyleList() {
        if (this.fStyleList == null || this.fDescriptions == null) {
            return;
        }
        Object[] objectArray = new String[this.fStyleList.size()];
        int n = 0;
        while (n < this.fStyleList.size()) {
            objectArray[n] = this.fStyleList.get(n) != null ? (String)this.getDescriptions().get(this.fStyleList.get(n)) : (String)this.fStyleList.get(n);
            ++n;
        }
        Object[] objectArray2 = new DescriptionSorter().sort(objectArray);
        String[] stringArray = new String[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            stringArray[n2] = objectArray2[n2].toString();
            ++n2;
        }
        this.fStyleCombo.setItems(stringArray);
        this.fStyleCombo.select(0);
    }

    protected class DescriptionSorter
    extends Sorter {
        Collator collator = Collator.getInstance();

        protected DescriptionSorter() {
        }

        public boolean compare(Object object, Object object2) {
            return this.collator.compare(object.toString(), object2.toString()) < 0;
        }
    }
}

