/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.part.FileEditorInput;

public class PHPOpenExternalFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private String fFilterPath;
    private StringBuffer notFound = new StringBuffer();

    public PHPOpenExternalFileAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.fWindow = null;
        this.fFilterPath = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
        this.fFilterPath = System.getProperty("user.home");
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void run(List list) {
        if (list != null) {
            int n = 0;
            for (String string : list) {
                Path path = new Path(string);
                this.fFilterPath = path.removeLastSegments(1).toOSString();
                IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(this.fFilterPath));
                if (!(iFileStore = iFileStore.getChild(path.lastSegment())).fetchInfo().isDirectory() && iFileStore.fetchInfo().exists()) {
                    IEditorInput iEditorInput = this.createEditorInput(iFileStore);
                    String string2 = this.getEditorId(iFileStore);
                    IWorkbenchPage iWorkbenchPage = this.fWindow.getActivePage();
                    try {
                        iWorkbenchPage.openEditor(iEditorInput, string2);
                    }
                    catch (PartInitException partInitException) {
                        Logger.logException("Failed opening file called externally", partInitException);
                    }
                    continue;
                }
                if (++n > 1) {
                    this.notFound.append('\n');
                }
                this.notFound.append(string);
            }
        }
    }

    public String getFileNotFoundStr() {
        return this.notFound.toString();
    }

    private String getEditorId(IFileStore iFileStore) {
        IWorkbench iWorkbench = this.fWindow.getWorkbench();
        IEditorRegistry iEditorRegistry = iWorkbench.getEditorRegistry();
        IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(iFileStore.getName(), this.getContentType(iFileStore));
        if (iEditorDescriptor == null && iEditorRegistry.isSystemInPlaceEditorAvailable(iFileStore.getName())) {
            iEditorDescriptor = iEditorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (iEditorDescriptor == null && iEditorRegistry.isSystemExternalEditorAvailable(iFileStore.getName())) {
            iEditorDescriptor = iEditorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (iEditorDescriptor != null) {
            return iEditorDescriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IContentType getContentType(IFileStore iFileStore) {
        if (iFileStore == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = iFileStore.openInputStream(0, null);
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(inputStream, iFileStore.getName());
            return iContentType;
        }
        catch (IOException iOException) {
            EditorsPlugin.log((Throwable)iOException);
            return null;
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getException() instanceof FileNotFoundException) return null;
            EditorsPlugin.log((Throwable)coreException);
            return null;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                EditorsPlugin.log((Throwable)iOException);
            }
        }
    }

    private IEditorInput createEditorInput(IFileStore iFileStore) {
        IFile iFile = this.getWorkspaceFile(iFileStore);
        if (iFile != null) {
            return new FileEditorInput(iFile);
        }
        return new FileStoreEditorInput(iFileStore);
    }

    private IFile getWorkspaceFile(IFileStore iFileStore) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IFile[] iFileArray = iWorkspace.getRoot().findFilesForLocation((IPath)new Path(iFileStore.toURI().getPath()));
        if ((iFileArray = this.filterNonExistentFiles(iFileArray)) == null || iFileArray.length == 0) {
            return null;
        }
        if (iFileArray.length == 1) {
            return iFileArray[0];
        }
        return this.selectWorkspaceFile(iFileArray);
    }

    private IFile[] filterNonExistentFiles(IFile[] iFileArray) {
        if (iFileArray == null) {
            return null;
        }
        int n = iFileArray.length;
        ArrayList<IFile> arrayList = new ArrayList<IFile>(n);
        int n2 = 0;
        while (n2 < n) {
            if (iFileArray[n2].exists()) {
                arrayList.add(iFileArray[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    private IFile selectWorkspaceFile(IFile[] iFileArray) {
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.fWindow.getShell(), (ILabelProvider)new FileLabelProvider());
        elementListSelectionDialog.setElements((Object[])iFileArray);
        if (elementListSelectionDialog.open() == 0) {
            return (IFile)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof IFile) {
                IPath iPath = ((IFile)object).getFullPath();
                return iPath != null ? iPath.toString() : "";
            }
            return super.getText(object);
        }
    }
}

