/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.HashSet;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.IProblemChangedListener;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.swt.widgets.Display;

public class ProblemMarkerManager
implements IResourceChangeListener,
IAnnotationModelListener,
IAnnotationModelListenerExtension {
    private ListenerList fListeners = new ListenerList(10);

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResource[] iResourceArray;
        HashSet hashSet = new HashSet();
        try {
            iResourceArray = iResourceChangeEvent.getDelta();
            if (iResourceArray != null) {
                iResourceArray.accept((IResourceDeltaVisitor)new ProjectErrorVisitor(hashSet));
            }
        }
        catch (CoreException coreException) {
            PHPUiPlugin.log(coreException.getStatus());
        }
        if (!hashSet.isEmpty()) {
            iResourceArray = hashSet.toArray(new IResource[hashSet.size()]);
            this.fireChanges(iResourceArray, true);
        }
    }

    public void modelChanged(IAnnotationModel iAnnotationModel) {
    }

    public void modelChanged(AnnotationModelEvent annotationModelEvent) {
    }

    public void addListener(IProblemChangedListener iProblemChangedListener) {
        if (this.fListeners.isEmpty()) {
            PHPUiPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.fListeners.add((Object)iProblemChangedListener);
    }

    public void removeListener(IProblemChangedListener iProblemChangedListener) {
        this.fListeners.remove((Object)iProblemChangedListener);
        if (this.fListeners.isEmpty()) {
            PHPUiPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    private void fireChanges(final IResource[] iResourceArray, final boolean bl) {
        Display display = SWTUtil.getStandardDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    Object[] objectArray = ProblemMarkerManager.this.fListeners.getListeners();
                    int n = 0;
                    while (n < objectArray.length) {
                        IProblemChangedListener iProblemChangedListener = (IProblemChangedListener)objectArray[n];
                        iProblemChangedListener.problemsChanged(iResourceArray, bl);
                        ++n;
                    }
                }
            });
        }
    }

    private static class ProjectErrorVisitor
    implements IResourceDeltaVisitor {
        private HashSet fChangedElements;

        public ProjectErrorVisitor(HashSet hashSet) {
            this.fChangedElements = hashSet;
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            IProject iProject;
            IResource iResource = iResourceDelta.getResource();
            if (iResource instanceof IProject && iResourceDelta.getKind() == 4 && !(iProject = (IProject)iResource).isAccessible()) {
                return false;
            }
            this.checkInvalidate(iResourceDelta, iResource);
            return true;
        }

        private void checkInvalidate(IResourceDelta iResourceDelta, IResource iResource) {
            int n = iResourceDelta.getKind();
            if (n == 2 || n == 1 || n == 4 && this.isErrorDelta(iResourceDelta)) {
                while (iResource.getType() != 8 && this.fChangedElements.add(iResource)) {
                    iResource = iResource.getParent();
                }
            }
        }

        private boolean isErrorDelta(IResourceDelta iResourceDelta) {
            if ((iResourceDelta.getFlags() & 0x20000) != 0) {
                IMarkerDelta[] iMarkerDeltaArray = iResourceDelta.getMarkerDeltas();
                int n = 0;
                while (n < iMarkerDeltaArray.length) {
                    if (iMarkerDeltaArray[n].isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        int n2 = iMarkerDeltaArray[n].getKind();
                        if (n2 == 1 || n2 == 2) {
                            return true;
                        }
                        int n3 = iMarkerDeltaArray[n].getAttribute("severity", -1);
                        int n4 = iMarkerDeltaArray[n].getMarker().getAttribute("severity", -1);
                        if (n4 != n3) {
                            return true;
                        }
                    }
                    ++n;
                }
            }
            return false;
        }
    }
}

