/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.Parameter;
import org.eclipse.datatools.sqltools.result.ResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultItem;
import org.eclipse.datatools.sqltools.result.internal.model.XMLResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.PrintResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.view.MultipleTabsModeSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.datatools.sqltools.result.internal.ui.viewer.ResultSetViewer;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusTextProvider;
import org.eclipse.datatools.sqltools.result.internal.utils.UIUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MultipleTabsGridSection
extends MultipleTabsModeSection {
    private Text _statusView;
    private Text _messageView;
    private static final int PARAM_NAME = 0;
    private static final int PARAM_TYPE = 1;
    private static final int PARAM_DATA_TYPE = 2;
    private static final int PARAM_VALUE = 3;
    private static final int PARAM_VALUE_OUT = 4;
    private Table _paramTable;

    public MultipleTabsGridSection(Composite composite, ResultsView view) {
        super(composite, view);
    }

    public MultipleTabsGridSection(Composite composite, IResultInstance instance, ResultsView view) {
        super(composite, instance, view);
    }

    protected Control createStatusItem(CTabFolder ctf) {
        this._statusView = new Text((Composite)ctf, 770);
        this._statusView.setEditable(false);
        return this._statusView;
    }

    protected Control createMessageItem(CTabFolder ctf) {
        this._messageView = new Text((Composite)ctf, 770);
        this._messageView.setEditable(false);
        return this._messageView;
    }

    public void showStatusDetail(IResultInstance instance) {
        if (instance == null) {
            this._statusView.setText("");
        } else {
            String text = StatusTextProvider.getStatusText(instance);
            this._statusView.setText(text);
        }
    }

    protected void showMessageDetail(IResultInstance instance) {
        if (this._splitMessages) {
            return;
        }
        if (instance == null) {
            this._messageView.setText("");
        } else {
            int count = instance.getItemCount();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < count; ++i) {
                ResultItem item = instance.getItem(i);
                if (item.getResultType() != 2) continue;
                sb.append(item.getResultObject());
            }
            this._messageView.setText(sb.toString());
        }
    }

    protected void showParameterDetail(IResultInstance instance) {
        if (instance.getParameters() == null) {
            return;
        }
        Iterator iter = instance.getParameters().iterator();
        ArrayList newList = new ArrayList();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || !(obj instanceof Parameter)) continue;
            newList.add(obj);
        }
        this.appendAndShowParameters(newList);
    }

    protected void createViewerForItem(Composite composite, ResultItem item) {
        int resultType = item.getResultType();
        switch (resultType) {
            case 2: {
                Text message = new Text(composite, 770);
                message.setLayoutData((Object)new GridData(1808));
                message.setEditable(false);
                message.setText((String)item.getResultObject());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                IResultSetObject result = (IResultSetObject)item.getResultObject();
                if (result instanceof XMLResultSetObject) {
                    this.createTextforResultSet(composite, result);
                }
                if (!(result instanceof ResultSetObject)) break;
                this.createTableViewerForResultSet(composite, result);
                break;
            }
        }
    }

    protected void appendStatusView(String text) {
        this._statusView.append(text);
    }

    protected void appendMessageView(String text) {
        this._messageView.append(text);
    }

    protected void createTableViewerForResultSet(Composite composite, IResultSetObject result) {
        new ResultSetViewer(composite, 66308, this._resultInstance, result, this._displayRowNumber);
        Label label = new Label(composite, 0);
        GridData labelGridData = new GridData();
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.grabExcessVerticalSpace = false;
        labelGridData.heightHint = UIUtil.convertHeightInCharsToPixels(1, (Control)this._parent);
        label.setLayoutData((Object)labelGridData);
        int totalRowCount = result.getTotalRowCount();
        int rowCount = result.getRowCount();
        if (totalRowCount == rowCount) {
            label.setText(NLS.bind((String)Messages.ResultSection_resultset_tooltip1, (Object[])new Object[]{String.valueOf(rowCount)}));
        } else {
            label.setText(NLS.bind((String)Messages.ResultSection_resultset_tooltip, (Object[])new Object[]{String.valueOf(totalRowCount), String.valueOf(rowCount)}));
        }
    }

    protected void createTextforResultSet(Composite composite, IResultSetObject result) {
        Text txt = new Text(composite, 778);
        txt.setLayoutData((Object)new GridData(1808));
        StringBuffer buf = new StringBuffer();
        Iterator iter = result.getDisplayRecords();
        while (iter != null && iter.hasNext()) {
            IResultSetRow row = (IResultSetRow)iter.next();
            for (int i = 0; i < row.getData().length; ++i) {
                buf.append(row.getData(i));
            }
        }
        String s = buf.toString();
        txt.setText(s);
        MenuManager mgr = new MenuManager();
        MenuManager saveMgr = new MenuManager(Messages.Save_name);
        saveMgr.add((IAction)new SaveResultSetAction(txt.getShell(), result));
        saveMgr.add((IAction)new SaveAllResultSetsAction(txt.getShell(), this._resultInstance));
        MenuManager exportMgr = new MenuManager(Messages.Export_name);
        exportMgr.add((IAction)new ExportResultSetAction(txt.getShell(), result));
        exportMgr.add((IAction)new ExportAllResultSetsAction(txt.getShell(), this._resultInstance));
        MenuManager printMgr = new MenuManager(Messages.Print_name);
        printMgr.add((IAction)new PrintResultSetAction(result, this._parent));
        printMgr.add((IAction)new PrintResultSetAction(this._resultInstance, this._parent));
        mgr.add((IContributionItem)saveMgr);
        mgr.add((IContributionItem)exportMgr);
        mgr.add((IContributionItem)printMgr);
        Menu menu = mgr.createContextMenu((Control)txt);
        txt.setMenu(menu);
    }

    public void onInstanceReseted() {
        super.onInstanceReseted();
        this._statusView.setText("");
    }

    private void createTableForParameters(Composite comp) {
        TableViewer paramViewer = new TableViewer(comp, 66048);
        this._paramTable = paramViewer.getTable();
        this._paramTable.setLinesVisible(true);
        this._paramTable.setHeaderVisible(true);
        this._paramTable.setLayoutData((Object)new GridData(1808));
        TableColumn nameColumn = new TableColumn(this._paramTable, 0);
        nameColumn.setText(Messages.MultipleTabsGridSection_parameter_name);
        TableColumn typeColumn = new TableColumn(this._paramTable, 0);
        typeColumn.setText(Messages.MultipleTabsGridSection_parameter_type);
        TableColumn dataTypeColumn = new TableColumn(this._paramTable, 0);
        dataTypeColumn.setText(Messages.MultipleTabsGridSection_parameter_datatype);
        TableColumn valueColumn = new TableColumn(this._paramTable, 0);
        valueColumn.setText(Messages.MultipleTabsGridSection_value);
        TableColumn outValueColumn = new TableColumn(this._paramTable, 0);
        outValueColumn.setText(Messages.MultipleTabsGridSection_value_out);
        int defaultWidth = 0;
        int columnCount = this._paramTable.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this._paramTable.getColumn(i);
            column.pack();
            defaultWidth = defaultWidth + column.getWidth() + this._paramTable.getGridLineWidth();
        }
        int moreWidth = comp.getParent().getBounds().width - 2 - defaultWidth;
        if (moreWidth > 0) {
            for (int i = 0; i < columnCount; ++i) {
                TableColumn col = this._paramTable.getColumn(i);
                col.setWidth(col.getWidth() + moreWidth / columnCount);
            }
        }
        this._paramTable.pack();
    }

    protected void appendAndShowParameters(List params) {
        if (this._paramsItem == null) {
            this._paramsItem = new CTabItem(this._tabFolder, 0, this._numberStaticTab);
            this._paramsItem.setText(Messages.MultipleTabsGridSection_parameter);
            ++this._numberStaticTab;
            this._isParamShown = true;
            this._paramTabNumber = this._numberStaticTab - 1;
            this.createTableForParameters((Composite)this._tabFolder);
            this._paramsItem.setControl((Control)this._paramTable);
        }
        this.fillDataIntoParamsTable(params);
    }

    private void fillDataIntoParamsTable(List params) {
        this._paramTable.removeAll();
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            Parameter param = (Parameter)iter.next();
            TableItem item = new TableItem(this._paramTable, 0);
            item.setText(0, param.getParamName());
            item.setText(1, param.getParamType());
            item.setText(2, param.getParamDataType());
            item.setText(3, param.getParamValue());
            item.setText(4, param.getParamOutValue());
        }
    }
}

