/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.Parameter;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultItem;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSection;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsView;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusTextProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class MultipleTabsModeSection
extends ResultSection {
    private static ILogger _log = ResultsViewPlugin.getLogger(null);
    protected int _numberStaticTab = 1;
    protected CTabFolder _tabFolder;
    protected CTabItem _statusItem;
    protected CTabItem _messageItem;
    protected CTabItem _paramsItem;
    protected int _messageIndex = 1;
    protected int _resultsetIndex = 1;
    protected ResultItem _preItem;
    protected CTabItem _preTab;
    protected boolean _splitMessages;
    protected boolean _endTabCreated = false;
    protected int _tabsNum;
    protected int _currentTabsNum;
    protected boolean _isParamShown = false;
    protected int _paramTabNumber;

    public MultipleTabsModeSection(Composite composite, IResultInstance instance, ResultsView view) {
        super(instance, view);
        this._parent = composite;
        this._tabFolder = new CTabFolder(composite, 0);
        this._splitMessages = this._store.getBoolean("org.eclipse.datatools.sqltools.result.preferences.display.splitmessages");
        this._tabsNum = this._store.getInt("org.eclipse.datatools.sqltools.result.preferences.display.tabsnumber");
        if (!this._splitMessages) {
            this._numberStaticTab = 2;
        }
        this._currentTabsNum = this._numberStaticTab;
        this.createInitialControl(this._tabFolder);
    }

    public MultipleTabsModeSection(Composite composite, ResultsView view) {
        this(composite, null, view);
    }

    protected void createInitialControl(CTabFolder ctf) {
        this._statusItem = new CTabItem(ctf, 0);
        this._statusItem.setControl(this.createStatusItem(ctf));
        this._statusItem.setText(Messages.ResultHistorySection_status);
        if (!this._splitMessages) {
            this._messageItem = new CTabItem(ctf, 0);
            this._messageItem.setControl(this.createMessageItem(ctf));
            this._messageItem.setText(Messages.MultipleTabsModeSection_message);
        }
        this._tabFolder.setSelection(this._statusItem);
    }

    public void showDetail(IResultInstance instance) {
        super.showDetail(instance);
        if (instance == this._resultInstance) {
            return;
        }
        this._view.clearStatusLine();
        this._resultInstance = instance;
        this._tabFolder.setVisible(false);
        this.showStatusDetail(instance);
        this.showMessageDetail(instance);
        this.showParameterDetail(instance);
        this.showResultsDetail(instance);
        this.onInstanceFinished();
        this._tabFolder.setVisible(true);
        this._tabFolder.setSelection(0);
    }

    protected abstract void showStatusDetail(IResultInstance var1);

    protected abstract void showMessageDetail(IResultInstance var1);

    protected abstract void showParameterDetail(IResultInstance var1);

    protected void showResultsDetail(IResultInstance instance) {
        CTabItem[] items = this._tabFolder.getItems();
        for (int i = this._numberStaticTab; i < items.length; ++i) {
            if (items[i] == null) continue;
            if (items[i].getControl() != null) {
                items[i].getControl().dispose();
            }
            items[i].dispose();
        }
        if (instance != null) {
            int count = instance.getItemCount();
            for (int i = 0; i < count; ++i) {
                this.createTabForResultItem(this._tabFolder, instance.getItem(i));
            }
        }
    }

    private void createTabForResultItem(CTabFolder tabFolder, ResultItem item) {
        GridLayout layout;
        Composite composite;
        CTabItem tabitem;
        if (item.getResultType() == 1 || item.getResultType() == 4) {
            return;
        }
        if (!this._splitMessages && item.getResultType() == 2) {
            return;
        }
        if (this._preItem != null && this._preItem.getResultType() == 2 && this._preItem.getResultType() == item.getResultType()) {
            Text text = null;
            StyledText styledText = null;
            tabFolder.setSelection(this._preTab);
            if (this._preTab != null) {
                try {
                    Composite tabControl = (Composite)this._preTab.getControl();
                    if (tabControl.getChildren()[0] instanceof Text) {
                        text = (Text)tabControl.getChildren()[0];
                    } else if (tabControl.getChildren()[0] instanceof StyledText) {
                        styledText = (StyledText)tabControl.getChildren()[0];
                    }
                }
                catch (Exception ex) {
                    _log.error("MultipleTabsModeSection_unexpectederror", (Throwable)ex);
                }
            }
            if (text != null) {
                this._preItem = item;
                text.append((String)item.getResultObject());
                return;
            }
            if (styledText != null) {
                this._preItem = item;
                StringBuffer orginalStr = new StringBuffer(styledText.getText());
                orginalStr.append((String)item.getResultObject());
                styledText.setText(orginalStr.toString());
                return;
            }
        }
        if (this._currentTabsNum >= this._tabsNum) {
            if (!this._endTabCreated) {
                this._endTabCreated = true;
                tabitem = new CTabItem(tabFolder, 0);
                tabitem.setText(Messages.MultipleTabsModeSection_warning);
                composite = new Composite((Composite)tabFolder, 0);
                layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                layout.numColumns = 1;
                composite.setLayout((Layout)layout);
                Text warningText = new Text(composite, 778);
                warningText.setLayoutData((Object)new GridData(1808));
                warningText.setText(Messages.MultipleTabsModeSection_warning_info);
                tabitem.setControl((Control)composite);
                tabFolder.setSelection(tabitem);
            }
            return;
        }
        tabitem = new CTabItem(tabFolder, 0);
        tabFolder.setSelection(tabitem);
        this._preTab = tabitem;
        this._preItem = item;
        composite = new Composite((Composite)tabFolder, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createViewerForItem(composite, item);
        tabitem.setControl((Control)composite);
        switch (item.getResultType()) {
            case 2: {
                tabitem.setText(Messages.ResultSection_message + this._messageIndex++);
                break;
            }
            case 3: {
                tabitem.setData((Object)item);
                tabitem.setText(Messages.ResultSection_result + this._resultsetIndex++);
                break;
            }
            case 1: {
                break;
            }
        }
        ++this._currentTabsNum;
    }

    public Composite getControl() {
        return this._tabFolder;
    }

    public void onNewItemAppended(ResultItem item, int index) {
        if (this._resultInstance == null || this._displayedItems.contains(item)) {
            return;
        }
        this._displayedItems.add(item);
        if (item.getResultType() == 1) {
            this.appendStatusView(StatusTextProvider.getUpdateCountText((Integer)item.getResultObject()));
            return;
        }
        if (item.getResultType() == 4) {
            this._tabFolder.setSelection(this._statusItem);
            this.appendStatusView((String)item.getResultObject());
            return;
        }
        if (!this._splitMessages && item.getResultType() == 2) {
            this._tabFolder.setSelection(this._messageItem);
            this.appendMessageView((String)item.getResultObject());
            return;
        }
        this.createTabForResultItem(this._tabFolder, item);
    }

    public void onParametersShown(List params) {
        if (this._resultInstance == null || params == null) {
            return;
        }
        Iterator iter = params.iterator();
        ArrayList newList = new ArrayList();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || !(obj instanceof Parameter)) continue;
            newList.add(obj);
        }
        this.appendAndShowParameters(newList);
    }

    public void onInstanceReseted() {
        if (this._resultInstance == null) {
            return;
        }
        this._tabFolder.setVisible(false);
        this._messageIndex = 1;
        this._resultsetIndex = 1;
        CTabItem[] items = this._tabFolder.getItems();
        for (int i = this._numberStaticTab; i < items.length; ++i) {
            items[i].dispose();
        }
        if (this._isParamShown) {
            --this._numberStaticTab;
            this._isParamShown = false;
            items[this._paramTabNumber].dispose();
        }
        this._tabFolder.setVisible(true);
    }

    public void onInstanceFinished() {
        this._view.refreshResults();
    }

    protected abstract void createViewerForItem(Composite var1, ResultItem var2);

    protected abstract Control createStatusItem(CTabFolder var1);

    protected abstract Control createMessageItem(CTabFolder var1);

    protected abstract void appendStatusView(String var1);

    protected abstract void appendMessageView(String var1);

    protected abstract void appendAndShowParameters(List var1);

    public void showTab(int tabType) {
        switch (tabType) {
            case 1: {
                if (this._statusItem == null) break;
                this._tabFolder.setSelection(this._statusItem);
                break;
            }
            case 2: {
                if (this._paramsItem == null) break;
                this._tabFolder.setSelection(this._paramsItem);
                break;
            }
            case 3: {
                if (!this._splitMessages) {
                    if (this._messageItem == null) break;
                    this._tabFolder.setSelection(this._messageItem);
                    break;
                }
                CTabItem firstMessageItem = this.findTabItem(Messages.ResultSection_message + "1");
                if (firstMessageItem == null) break;
                this._tabFolder.setSelection(firstMessageItem);
                break;
            }
            case 4: {
                CTabItem fisrtResultItem = this.findTabItem(Messages.ResultSection_result + "1");
                if (fisrtResultItem == null) break;
                this._tabFolder.setSelection(fisrtResultItem);
                break;
            }
        }
    }

    public void showResultSet(IResultSetObject result) {
        if (result == null) {
            return;
        }
        if (this._resultInstance == null) {
            return;
        }
        int resultSerialNumber = 0;
        boolean found = false;
        for (int i = 0; i < this._resultInstance.getItemCount(); ++i) {
            if (this._resultInstance.getItem(i).getResultType() == 3) {
                ++resultSerialNumber;
            }
            if (this._resultInstance.getItem(i) != result) continue;
            found = true;
            break;
        }
        if (resultSerialNumber == 0 || !found) {
            return;
        }
        CTabItem resultItem = this.findTabItem(Messages.ResultSection_result + resultSerialNumber);
        if (resultItem != null) {
            this._tabFolder.setSelection(resultItem);
        }
    }

    public void showTab(int tabType, int tabNumber) {
        if (this._resultInstance == null) {
            return;
        }
        String namePrefix = "";
        switch (tabType) {
            case 4: {
                namePrefix = Messages.ResultSection_result;
                break;
            }
            case 3: {
                namePrefix = Messages.ResultSection_message;
                break;
            }
        }
        CTabItem item = this.findTabItem(namePrefix + tabNumber);
        if (item != null) {
            this._tabFolder.setSelection(item);
        }
    }

    private CTabItem findTabItem(String tabName) {
        CTabItem[] items = this._tabFolder.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getText().equals(tabName)) continue;
            return items[i];
        }
        return null;
    }

    public int getRowCount() {
        CTabItem item = this._tabFolder.getSelection();
        Object data = item.getData();
        if (data == null || !(data instanceof ResultItem)) {
            return super.getRowCount();
        }
        ResultItem result = (ResultItem)data;
        if (result.getResultType() == 3) {
            return ((IResultSetObject)result.getResultObject()).getRowCount();
        }
        return super.getRowCount();
    }
}

