/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.internal.DomainLoadingStrategyRegistry;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainLoadingStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.ModelKeyDescriptor;
import org.eclipse.jst.jsf.common.metadata.internal.ModelNotSetException;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;
import org.eclipse.jst.jsf.common.metadata.query.IMetaDataModelContext;

public class MetaDataModelManager
implements IResourceChangeListener {
    public static final QualifiedName KEY_SESSIONPROPERTY = new QualifiedName(null, "MetaDataModelManager");
    private static MetaDataModelManager SHARED_INSTANCE;
    private ModelMap models;
    private IProject project;

    public static synchronized MetaDataModelManager getSharedInstance() {
        if (SHARED_INSTANCE == null) {
            SHARED_INSTANCE = new MetaDataModelManager(null);
        }
        return SHARED_INSTANCE;
    }

    public static synchronized MetaDataModelManager getInstance(IProject project) {
        MetaDataModelManager repo = null;
        repo = MetaDataModelManager.getFromSessionProperty(project);
        if (repo == null) {
            repo = new MetaDataModelManager(project);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)repo, 2);
        }
        return repo;
    }

    private MetaDataModelManager(IProject project) {
        this.project = project;
        this.init();
    }

    protected static MetaDataModelManager getFromSessionProperty(IProject project) {
        MetaDataModelManager repo = null;
        try {
            Object obj = project.getSessionProperty(KEY_SESSIONPROPERTY);
            if (obj != null && obj instanceof MetaDataModelManager) {
                repo = (MetaDataModelManager)obj;
            }
        }
        catch (CoreException ce) {
            JSFCommonPlugin.log(4, "Internal Error: Unable to recover MetaDataModelManager for: " + project.getName(), ce);
        }
        return repo;
    }

    protected void setAsSessionProperty() {
        if (this.project != null) {
            try {
                this.project.setSessionProperty(KEY_SESSIONPROPERTY, (Object)this);
            }
            catch (CoreException ce) {
                JSFCommonPlugin.log(4, "Internal Error: Unable to store MetaDataModelManager for: " + this.project.getName(), ce);
            }
        }
    }

    protected void removeAsSessionProperty(IProject aProject) {
        try {
            aProject.setSessionProperty(KEY_SESSIONPROPERTY, null);
        }
        catch (CoreException e) {
            JSFCommonPlugin.log((Exception)((Object)e), "Error removing session property");
        }
    }

    private synchronized void init() {
        this.models = new ModelMap();
        this.setAsSessionProperty();
    }

    public synchronized MetaDataModel getModel(IMetaDataModelContext modelContext) {
        ModelKeyDescriptor modelKeyDescriptor = StandardModelFactory.getInstance().createModelKeyDescriptor(modelContext);
        MetaDataModel model = this.models.get(modelKeyDescriptor);
        if (model == null || this.project == null) {
            model = this.loadMetadata(modelKeyDescriptor);
        } else if (model.needsRefresh()) {
            try {
                model.reload();
            }
            catch (ModelNotSetException modelNotSetException) {
                model = this.loadMetadata(modelKeyDescriptor);
            }
        }
        if (model != null && model.getRoot() != null) {
            ((Model)model.getRoot()).setCurrentModelContext(modelKeyDescriptor);
        }
        return model;
    }

    private void addModel(MetaDataModel model) {
        if (model != null) {
            this.models.put(model.getModelKey(), model);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject aProject;
        if (event.getType() == 2 && (aProject = (IProject)event.getResource()) == this.project) {
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    for (MetaDataModel model : MetaDataModelManager.this.models.getModels()) {
                        MetaDataModelManager.this.models.remove(model);
                        model.cleanup();
                    }
                    MetaDataModelManager.this.removeAsSessionProperty(MetaDataModelManager.this.project);
                }
            });
        }
    }

    private synchronized MetaDataModel loadMetadata(ModelKeyDescriptor modelKeyDescriptor) {
        IDomainLoadingStrategy strategy = DomainLoadingStrategyRegistry.getInstance().getLoadingStrategy(modelKeyDescriptor.getDomain());
        if (strategy == null) {
            JSFCommonPlugin.log(4, "Internal Error: Unable to locate metadata loading strategy for: " + modelKeyDescriptor.toString());
            return null;
        }
        MetaDataModel model = StandardModelFactory.getInstance().createModel(modelKeyDescriptor, strategy);
        model.load();
        this.addModel(model);
        return model;
    }

    private class ModelMap {
        private HashMap map = new HashMap();

        ModelMap() {
        }

        public void put(ModelKeyDescriptor modelKeyDescriptor, MetaDataModel model) {
            String key = modelKeyDescriptor.toString();
            this.map.put(key, model);
        }

        public synchronized MetaDataModel get(ModelKeyDescriptor modelKeyDescriptor) {
            String key = modelKeyDescriptor.toString();
            return (MetaDataModel)this.map.get(key);
        }

        public void remove(MetaDataModel model) {
            this.map.remove(model.getModelKey().toString());
        }

        public Set getModels() {
            HashSet ret = new HashSet();
            for (Map.Entry entry : this.map.entrySet()) {
                ret.add(entry.getValue());
            }
            return ret;
        }
    }
}

