/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainLoadingStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.MetaDataModel;
import org.eclipse.jst.jsf.common.metadata.internal.ModelKeyDescriptor;
import org.eclipse.jst.jsf.common.metadata.internal.util.MetadataResourceImpl;
import org.eclipse.jst.jsf.common.metadata.query.IMetaDataModelContext;

public class StandardModelFactory {
    private static StandardModelFactory INSTANCE;
    private ExtendedMetaData extendedMetaData;
    private ResourceSet resourceSet;

    public static synchronized StandardModelFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StandardModelFactory();
            INSTANCE.init();
        }
        return INSTANCE;
    }

    private void init() {
        this.resourceSet = new ResourceSetImpl();
        this.extendedMetaData = new BasicExtendedMetaData(this.resourceSet.getPackageRegistry());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
    }

    private StandardModelFactory() {
    }

    public MetaDataModel createModel(ModelKeyDescriptor key, IDomainLoadingStrategy strategy) {
        return new MetaDataModel(key, strategy);
    }

    public ModelKeyDescriptor createModelKeyDescriptor(IMetaDataModelContext modelContext) {
        return new ModelKeyDescriptor(modelContext.getProject(), modelContext.getDomain(), modelContext.getURI());
    }

    public EList loadStandardFileResource(InputStream inputStream, IMetaDataSourceModelProvider provider) throws IOException {
        MetadataResourceImpl res = new MetadataResourceImpl(provider);
        this.resourceSet.getResources().add((Object)res);
        this.setLoadOptions((XMLResource)res);
        res.load(inputStream, null);
        EList root = res.getContents();
        return root;
    }

    protected void setLoadOptions(XMLResource resource) {
        Map options = resource.getDefaultLoadOptions();
        options.put("SCHEMA_LOCATION", Boolean.TRUE);
        options.put("EXTENDED_META_DATA", this.extendedMetaData);
        options.put("RESOURCE_HANDLER", resource);
        options.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
    }
}

