/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.resolver.structureddocument.internal.impl;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.MetaDataQueryHelper;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IMetadataContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.impl.DOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.impl.TaglibContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.impl.WorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MetadataContextResolver
implements IMetadataContextResolver {
    private final IStructuredDocumentContext _context;

    public MetadataContextResolver(IStructuredDocumentContext context) {
        this._context = context;
    }

    public List getPropertyValue(String key) {
        DOMContextResolver domResolver = new DOMContextResolver(this._context);
        WorkspaceContextResolver wsResolver = new WorkspaceContextResolver(this._context);
        TaglibContextResolver tagResolver = new TaglibContextResolver(this._context);
        Node curNode = domResolver.getNode();
        if (curNode instanceof Attr) {
            Attr attribute = (Attr)curNode;
            Element element = attribute.getOwnerElement();
            String uri = tagResolver.getTagURIForNodeName(element);
            IProject project = wsResolver.getProject();
            IMetaDataModelContext mdContext = MetaDataQueryHelper.createTagLibraryDomainMetaDataModelContext(project, uri);
            Trait trait = MetaDataQueryHelper.getTrait(mdContext, String.valueOf(element.getLocalName()) + "/" + attribute.getLocalName(), key);
            return TraitValueHelper.getValueAsListOfStrings(trait);
        }
        if (curNode instanceof Element) {
            Element element = (Element)curNode;
            String uri = tagResolver.getTagURIForNodeName(element);
            IProject project = wsResolver.getProject();
            IMetaDataModelContext mdContext = MetaDataQueryHelper.createMetaDataModelContext(project, "TagLibraryDomain", uri);
            Trait trait = MetaDataQueryHelper.getTrait(mdContext, element.getLocalName(), key);
            return TraitValueHelper.getValueAsListOfStrings(trait);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean canResolveContext(IModelContext modelContext) {
        return modelContext.getAdapter(IStructuredDocumentContext.class) != null;
    }
}

