/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.jdt.dbunit.internal.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.dialogs.ResourceChooserDialog;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.widgets.IDataSelectionValidator;
import org.eclipse.datatools.enablement.jdt.classpath.internal.DriverClasspathContainer;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.BuildPathSupport;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.buildpath.DbUnitHomeInitializer;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.ConnectionProfileGroup;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.ui.DbUnitMessages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.DbUnitStatus;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.DbUnitStubUtility;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.LayoutUtil;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.util.Messages;
import org.eclipse.datatools.enablement.jdt.dbunit.internal.wizards.MethodStubsSelectionButtonGroup;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageOne;
import org.eclipse.jdt.junit.wizards.NewTestCaseWizardPageTwo;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class NewDbUnitTestCaseWizardPage1
extends NewTestCaseWizardPageOne {
    public static final String DEFAULT_DBUNIT_SUPERCLASS = "org.dbunit.DBTestCase";
    public static final String PROFILE_CHANGED = "profileChanged";
    private static final String BUILD_PATH_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
    private static final Object BUILD_PATH_KEY_ADD_ENTRY = "add_classpath_entry";
    private static final Object BUILD_PATH_BLOCK = "block_until_buildpath_applied";
    private static final int IDX_GETSETUPOPERATION = 0;
    private static final int IDX_GETTEARDOWNOPERATION = 1;
    private Link fLink;
    private Link fDriverLink;
    private Label fImage;
    private Label fDriverImage;
    private MethodStubsSelectionButtonGroup fMethodStubsButtons;
    private ConnectionProfileGroup fProfileGroup;
    private IConnectionProfile fSelectedProfile = null;
    private Text fInitialDataSetText;
    private IStatus fProfileUnderTestStatus;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewDbUnitTestCaseWizardPage1(NewTestCaseWizardPageTwo page2) {
        super(page2);
        String[] buttonNames = new String[]{DbUnitMessages.NewTestCaseWizardPageOne_methodStub_getSetUpOperation, DbUnitMessages.NewTestCaseWizardPageOne_methodStub_getTearDownOperation};
        this.fMethodStubsButtons = new MethodStubsSelectionButtonGroup(32, buttonNames, 2);
        this.fMethodStubsButtons.setLabelText(DbUnitMessages.NewTestCaseWizardPageOne_method_Stub_label);
    }

    protected IStatus[] getStatusList() {
        ArrayList<IStatus> list = new ArrayList<IStatus>();
        list.addAll(Arrays.asList(super.getStatusList()));
        list.add(this.fProfileUnderTestStatus);
        return list.toArray(new IStatus[list.size()]);
    }

    protected IStatus profileUnderTestChanged() {
        File testFile;
        DbUnitStatus status = new DbUnitStatus();
        String datasetName = this.fInitialDataSetText.getText();
        if (!(datasetName != null && datasetName.length() != 0 || (testFile = new File(datasetName)).canRead())) {
            status.setError(DbUnitMessages.ExportDBUDataSetObjectSelectionPage_Error_Must_Select_Valid_File);
        }
        return status;
    }

    protected void createClassUnderTestControls(Composite composite, int nColumns) {
        Label profileToTestAgainstLabel = new Label(composite, 16448);
        profileToTestAgainstLabel.setFont(composite.getFont());
        profileToTestAgainstLabel.setText(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Profile_Under_Test_Label);
        profileToTestAgainstLabel.setLayoutData((Object)new GridData());
        this.fProfileGroup = new ConnectionProfileGroup(composite, false, true, false, nColumns);
        this.fProfileGroup.setCategory("org.eclipse.datatools.connectivity.db.category");
        this.fProfileGroup.fillConnectionProfiles();
        Label noteAboutProperties = new Label(composite, 16448);
        noteAboutProperties.setFont(composite.getFont());
        noteAboutProperties.setText(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Profile_Note);
        GridData napGridData = new GridData();
        napGridData.horizontalSpan = nColumns;
        noteAboutProperties.setLayoutData((Object)napGridData);
        this.fProfileGroup.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                String profileName = NewDbUnitTestCaseWizardPage1.this.fProfileGroup.getSelectedProfile();
                if (ProfileManager.getInstance().getProfileByName(profileName) != null) {
                    NewDbUnitTestCaseWizardPage1.this.fSelectedProfile = ProfileManager.getInstance().getProfileByName(profileName);
                    NewDbUnitTestCaseWizardPage1.this.updateBuildPathMessage2();
                    NewDbUnitTestCaseWizardPage1.this.handleFieldChanged(NewDbUnitTestCaseWizardPage1.PROFILE_CHANGED);
                }
            }
        });
        Label spacerLabel = new Label(composite, 4);
        spacerLabel.setFont(composite.getFont());
        spacerLabel.setText("");
        GridData spLabelGD = new GridData();
        spLabelGD.horizontalSpan = nColumns;
        spacerLabel.setLayoutData((Object)spLabelGD);
        Label initialDataSetLabel = new Label(composite, 16448);
        initialDataSetLabel.setFont(composite.getFont());
        initialDataSetLabel.setText(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Initial_Dataset_Text_Label);
        initialDataSetLabel.setLayoutData((Object)new GridData());
        this.fInitialDataSetText = new Text(composite, 2048);
        this.fInitialDataSetText.setFont(composite.getFont());
        this.fInitialDataSetText.setText("dataset.xml");
        GridData idsGridData = new GridData(768);
        idsGridData.horizontalSpan = 2;
        this.fInitialDataSetText.setLayoutData((Object)idsGridData);
        this.fInitialDataSetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDbUnitTestCaseWizardPage1.this.handleFieldChanged(NewDbUnitTestCaseWizardPage1.PROFILE_CHANGED);
            }
        });
        Button browseFile = new Button(composite, 8);
        browseFile.setText(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Browse_Button_Label);
        browseFile.setLayoutData((Object)new GridData(256));
        browseFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                String newLocation = NewDbUnitTestCaseWizardPage1.this.handleLocationEditButtonPressed(NewDbUnitTestCaseWizardPage1.this.fInitialDataSetText.getText());
                if (newLocation != null && !newLocation.equals(NewDbUnitTestCaseWizardPage1.this.fInitialDataSetText.getText())) {
                    NewDbUnitTestCaseWizardPage1.this.fInitialDataSetText.setText(newLocation);
                }
                NewDbUnitTestCaseWizardPage1.this.handleFieldChanged(NewDbUnitTestCaseWizardPage1.PROFILE_CHANGED);
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        this.profileUnderTestChanged();
    }

    public void init(IStructuredSelection selection) {
        super.init(selection);
        this.setSuperClass(DEFAULT_DBUNIT_SUPERCLASS, true);
        this.setAddComments(true, true);
    }

    protected void createBuildPathConfigureControls(Composite composite, int nColumns) {
        super.createBuildPathConfigureControls(composite, nColumns);
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 4, false, false, nColumns, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        inner.setLayout((Layout)layout);
        this.fImage = new Label(inner, 0);
        this.fImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.fImage.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        this.fLink = new Link(inner, 64);
        this.fLink.setText("\n\n");
        this.fLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewDbUnitTestCaseWizardPage1.this.performBuildpathConfiguration(e.text);
            }
        });
        GridData gd = new GridData(4, 1, true, false, 1, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fLink.setLayoutData((Object)gd);
        this.updateBuildPathMessage();
        this.fDriverImage = new Label(inner, 0);
        this.fDriverImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        this.fDriverImage.setLayoutData((Object)new GridData(1, 1, false, false, 1, 1));
        this.fDriverLink = new Link(inner, 64);
        this.fDriverLink.setText("\n\n");
        this.fDriverLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewDbUnitTestCaseWizardPage1.this.performBuildpathConfiguration(e.text);
            }
        });
        gd = new GridData(4, 1, true, false, 1, 1);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        this.fDriverLink.setLayoutData((Object)gd);
        this.updateBuildPathMessage2();
    }

    private void performBuildpathConfiguration(Object data) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IJavaProject javaProject = root.getJavaProject();
        if ("ad2".equals(data)) {
            String id = BUILD_PATH_PAGE_ID;
            HashMap<Object, Object> input = new HashMap<Object, Object>();
            IClasspathEntry newEntry = BuildPathSupport.getDbUnit2VariableEntry();
            IPath path = JavaCore.getClasspathVariable((String)DbUnitHomeInitializer.DBUNIT_HOME);
            if (path == null || !path.toFile().exists()) {
                DbUnitHomeInitializer initializer = new DbUnitHomeInitializer();
                initializer.initialize(DbUnitHomeInitializer.DBUNIT_HOME);
                path = JavaCore.getClasspathVariable((String)DbUnitHomeInitializer.DBUNIT_HOME);
                newEntry = BuildPathSupport.getDbUnit2VariableEntry();
                if (path == null || !path.toFile().exists()) {
                    MessageDialog.openError((Shell)this.getShell(), (String)DbUnitMessages.NewDbUnitTestCaseWizardPage1_ErrorInitializingHome_Title, (String)DbUnitMessages.NewDbUnitTestCaseWizardPage1_ErrorInitializingHome_message);
                    return;
                }
            }
            IClasspathEntry updatedEntry = BuildPathSupport.updateNativeLibraryForClassPath(path.makeAbsolute().toOSString(), root, newEntry);
            input.put(BUILD_PATH_KEY_ADD_ENTRY, updatedEntry);
            input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)id, (String[])new String[]{id}, input).open();
        } else if ("adl".equals(data)) {
            String id = BUILD_PATH_PAGE_ID;
            HashMap<Object, Object> input = new HashMap<Object, Object>();
            if (this.fSelectedProfile != null) {
                String driverID = this.fSelectedProfile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
                DriverInstance di = DriverManager.getInstance().getDriverInstanceByID(driverID);
                DriverClasspathContainer container = new DriverClasspathContainer(di.getName());
                try {
                    JavaCore.setClasspathContainer((IPath)container.getPath(), (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
                input.put(BUILD_PATH_KEY_ADD_ENTRY, container.getClasspathEntries()[0]);
                input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
                PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)javaProject, (String)id, (String[])new String[]{id}, input).open();
            }
        }
        this.refreshProject();
        this.updateBuildPathMessage();
        this.updateBuildPathMessage2();
    }

    private void updateBuildPathMessage() {
        if (this.fLink == null || this.fLink.isDisposed()) {
            return;
        }
        String message = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            try {
                IJavaProject project = root.getJavaProject();
                if (project.findType(DEFAULT_DBUNIT_SUPERCLASS) == null) {
                    message = Messages.format(DbUnitMessages.NewTestCaseWizardPageOne_linkedtext_dbunit2_notonbuildpath, project.getElementName());
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.fLink.setVisible(message != null);
        this.fImage.setVisible(message != null);
        if (message != null) {
            this.fLink.setText(message);
        }
    }

    private void updateBuildPathMessage2() {
        if (this.fDriverLink == null || this.fDriverLink.isDisposed()) {
            return;
        }
        String message = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            try {
                IJavaProject project = root.getJavaProject();
                if (this.fSelectedProfile != null) {
                    String driverID = this.fSelectedProfile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
                    DriverInstance di = DriverManager.getInstance().getDriverInstanceByID(driverID);
                    String driverClass = di.getProperty("org.eclipse.datatools.connectivity.db.driverClass");
                    if (project.findType(driverClass) == null) {
                        message = Messages.format(DbUnitMessages.NewTestCaseWizardPageOne_linkedtext_driver_library_notonbuildpath, project.getElementName());
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        this.fDriverLink.setVisible(message != null);
        this.fDriverImage.setVisible(message != null);
        if (message != null) {
            this.fDriverLink.setText(message);
        }
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getLabelControl(composite), nColumns);
        LayoutUtil.createEmptySpace(composite, 1);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodStubsButtons.getSelectionButtonsGroup(composite), nColumns - 1);
    }

    private void createSetupStubs(IType type, String methodName, boolean isStatic, String annotationType, NewTypeWizardPage.ImportsManager imports, Class returnClass, boolean callSuper) throws CoreException {
        this.createSetupStubs(type, methodName, isStatic, annotationType, imports, returnClass, callSuper, null);
    }

    private void createSetupStubs(IType type, String methodName, boolean isStatic, String annotationType, NewTypeWizardPage.ImportsManager imports, Class returnClass, boolean callSuper, String extraReturnClause) throws CoreException {
        String content = null;
        IMethod methodTemplate = this.findInHierarchy(type, methodName);
        String annotation = null;
        if (this.isJUnit4()) {
            annotation = String.valueOf('@') + imports.addImport(annotationType);
        }
        DbUnitStubUtility.GenStubSettings settings = DbUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
        settings.createComments = this.isAddComments();
        if (methodTemplate != null) {
            settings.callSuper = callSuper;
            settings.methodOverwrites = true;
            content = extraReturnClause != null ? DbUnitStubUtility.genStub(type.getCompilationUnit(), this.getTypeName(), methodTemplate, settings, annotation, imports, extraReturnClause) : DbUnitStubUtility.genStub(type.getCompilationUnit(), this.getTypeName(), methodTemplate, settings, annotation, imports);
        } else {
            String delimiter = this.getLineDelimiter();
            StringBuffer buffer = new StringBuffer();
            if (settings.createComments) {
                String[] excSignature = new String[]{Signature.createTypeSignature((String)"java.lang.Exception", (boolean)true)};
                String comment = CodeGeneration.getMethodComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getElementName(), (String)methodName, (String[])new String[0], (String[])excSignature, (String)"V", null, (String)delimiter);
                if (comment != null) {
                    buffer.append(comment);
                }
            }
            if (annotation != null) {
                buffer.append(annotation).append(delimiter);
            }
            if (this.isJUnit4()) {
                buffer.append("public ");
            } else {
                buffer.append("protected ");
            }
            if (isStatic) {
                buffer.append("static ");
            }
            if (returnClass == null) {
                buffer.append("void ");
            }
            buffer.append(methodName);
            buffer.append("() throws ");
            buffer.append(imports.addImport("java.lang.Exception"));
            buffer.append(" {}");
            buffer.append(delimiter);
            content = buffer.toString();
        }
        type.createMethod(content, null, false, null);
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.refreshProject();
        this.createConstructor(type, imports);
        this.createGetDataSet(type, imports);
        if (this.fMethodStubsButtons.isSelected(0)) {
            this.createGetSetupOperation(type, imports);
        }
        if (this.fMethodStubsButtons.isSelected(1)) {
            this.createGetTeardownOperation(type, imports);
        }
        if (this.isJUnit4()) {
            imports.addStaticImport("org.junit.Assert", "*", false);
        }
    }

    private void createConstructor(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        String content = "";
        IMethod methodTemplate = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            superTypes = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < superTypes.length) {
                IMethod constrMethod;
                if (superTypes[i].exists() && (constrMethod = superTypes[i].getMethod(superTypes[i].getElementName(), new String[]{"Ljava.lang.String;"})).exists() && constrMethod.isConstructor()) {
                    methodTemplate = constrMethod;
                    break;
                }
                ++i;
            }
        }
        DbUnitStubUtility.GenStubSettings settings = DbUnitStubUtility.getCodeGenerationSettings(type.getJavaProject());
        settings.createComments = this.isAddComments();
        String delimiter = this.getLineDelimiter();
        StringBuffer buffer = new StringBuffer(32);
        if (methodTemplate != null) {
            settings.callSuper = true;
            settings.methodOverwrites = true;
            content = DbUnitStubUtility.genStub(type.getCompilationUnit(), this.getTypeName(), methodTemplate, settings, null, imports);
        } else {
            buffer.append("public ");
            buffer.append(this.getTypeName());
            buffer.append('(');
            if (!this.isJUnit4()) {
                buffer.append(imports.addImport("java.lang.String")).append(" name");
            }
            buffer.append(") {");
            buffer.append(delimiter);
            if (!this.isJUnit4()) {
                buffer.append("super(name);").append(delimiter);
            }
            if (this.fSelectedProfile == null) {
                buffer.append('}');
                buffer.append(delimiter);
                content = buffer.toString();
            }
        }
        if (this.fSelectedProfile != null) {
            imports.addImport("org.dbunit.PropertiesBasedJdbcDatabaseTester");
            String driverClass = this.fSelectedProfile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
            String driverURL = this.fSelectedProfile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
            driverURL = this.sanitizeURL(driverURL);
            String userName = this.fSelectedProfile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.username");
            String dcLine = "\t\tSystem.setProperty( PropertiesBasedJdbcDatabaseTester.DBUNIT_DRIVER_CLASS, \"" + driverClass + "\" );" + delimiter;
            String urlLine = "\t\tSystem.setProperty( PropertiesBasedJdbcDatabaseTester.DBUNIT_CONNECTION_URL, \"" + driverURL + "\" );" + delimiter;
            String uidLine = "\t\tSystem.setProperty( PropertiesBasedJdbcDatabaseTester.DBUNIT_USERNAME, \"" + userName + "\" );" + delimiter;
            String pwdLine = "\t\tSystem.setProperty( PropertiesBasedJdbcDatabaseTester.DBUNIT_PASSWORD, \"\" );" + delimiter;
            if (content != null && content.lastIndexOf("}") > -1) {
                StringBuffer buffer2 = new StringBuffer(content);
                buffer2.insert(buffer2.lastIndexOf("}") - 2, delimiter);
                buffer2.insert(buffer2.lastIndexOf("}") - 2, dcLine);
                buffer2.insert(buffer2.lastIndexOf("}") - 2, urlLine);
                buffer2.insert(buffer2.lastIndexOf("}") - 2, uidLine);
                buffer2.insert(buffer2.lastIndexOf("}") - 2, pwdLine);
                content = buffer2.toString();
            } else {
                buffer.append(dcLine);
                buffer.append(urlLine);
                buffer.append(uidLine);
                buffer.append(pwdLine);
                buffer.append('}');
                content = buffer.toString();
            }
        }
        type.createMethod(content, null, true, null);
    }

    private String sanitizeURL(String inURL) {
        String outURL = "";
        int i = 0;
        while (i < inURL.length()) {
            char ch = inURL.charAt(i);
            switch (ch) {
                case '\\': {
                    outURL = String.valueOf(outURL) + "\\\\";
                    break;
                }
                case '\"': {
                    outURL = String.valueOf(outURL) + "\"\"";
                    break;
                }
                default: {
                    outURL = String.valueOf(outURL) + ch;
                }
            }
            ++i;
        }
        return outURL;
    }

    private void createGetDataSet(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        Class<?> clazz;
        imports.addImport("java.io.FileInputStream");
        imports.addImport("org.dbunit.dataset.xml.FlatXmlDataSet");
        String returnClause = "return new FlatXmlDataSet(new FileInputStream(";
        if (this.fInitialDataSetText != null && this.fInitialDataSetText.getText().length() > 0) {
            String fileName = this.sanitizeURL(this.fInitialDataSetText.getText());
            returnClause = String.valueOf(returnClause) + "\"" + fileName + "\"));";
        } else {
            returnClause = String.valueOf(returnClause) + "\"dataset.xml\"));";
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.dbunit.dataset.IDataSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.createSetupStubs(type, "getDataSet", false, "org.junit.Before", imports, clazz, false, returnClause);
    }

    private void createGetSetupOperation(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.dbunit.operation.DatabaseOperation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.createSetupStubs(type, "getSetUpOperation", false, "org.junit.Before", imports, clazz, true);
    }

    private void createGetTeardownOperation(IType type, NewTypeWizardPage.ImportsManager imports) throws CoreException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.dbunit.operation.DatabaseOperation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.createSetupStubs(type, "getTearDownOperation", true, "org.junit.Before", imports, clazz, true);
    }

    private String getLineDelimiter() throws JavaModelException {
        IType classToTest = this.getClassUnderTest();
        if (classToTest != null && classToTest.exists() && classToTest.getCompilationUnit() != null) {
            return classToTest.getCompilationUnit().findRecommendedLineSeparator();
        }
        return this.getPackageFragment().findRecommendedLineSeparator();
    }

    private IMethod findInHierarchy(IType type, String methodName) throws JavaModelException {
        ITypeHierarchy typeHierarchy = null;
        IType[] superTypes = null;
        if (type.exists()) {
            typeHierarchy = type.newSupertypeHierarchy(null);
            superTypes = typeHierarchy.getAllSuperclasses(type);
            int i = 0;
            while (i < superTypes.length) {
                IMethod testMethod;
                if (superTypes[i].exists() && (testMethod = superTypes[i].getMethod(methodName, new String[0])).exists()) {
                    return testMethod;
                }
                ++i;
            }
        }
        return null;
    }

    private String handleLocationEditButtonPressed(String editLocation) {
        Object[] selectedDirectory;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.refreshProject();
        ResourceChooserDialog rsDialog = new ResourceChooserDialog(this.getShell(), (IContainer)root, true, DbUnitMessages.NewDbUnitTestCaseWizardPage1_Dialog_Text, true);
        rsDialog.setTitle(DbUnitMessages.NewDbUnitTestCaseWizardPage1_Dialog_Title);
        rsDialog.showClosedProjects(false);
        rsDialog.setValidator(new IDataSelectionValidator(){

            public String isValid(IStructuredSelection selection) {
                if (selection.isEmpty()) {
                    return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Select_Dataset;
                }
                if (selection.size() > 1) {
                    return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Select_One_Dataset;
                }
                if (selection.getFirstElement() instanceof IProject) {
                    return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Only_Select_Dataset;
                }
                if (!(selection.getFirstElement() instanceof IFile)) {
                    return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Only_Select_Dataset;
                }
                IFile testFile = (IFile)selection.getFirstElement();
                if (!testFile.getFileExtension().equals("xml")) {
                    return DbUnitMessages.NewDbUnitTestCaseWizardPage1_Please_Only_Select_Dataset;
                }
                return null;
            }
        });
        int rtn = rsDialog.open();
        if (rtn == 0 && (selectedDirectory = rsDialog.getResult()) != null && selectedDirectory.length > 0) {
            StructuredSelection selection = (StructuredSelection)selectedDirectory[0];
            IResource resource = (IResource)selection.getFirstElement();
            return resource.getLocation().toOSString();
        }
        return null;
    }

    protected IStatus superClassChanged() {
        this.refreshProject();
        return super.superClassChanged();
    }

    protected IStatus typeNameChanged() {
        this.fSuperClassStatus = this.superClassChanged();
        return super.typeNameChanged();
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals("NewTestCaseCreationWizardPage.junit4toggle")) {
            this.setSuperClass(DEFAULT_DBUNIT_SUPERCLASS, true);
        }
        if (fieldName.equals(PROFILE_CHANGED)) {
            this.fProfileUnderTestStatus = this.profileUnderTestChanged();
        }
        this.updateStatus(this.getStatusList());
    }

    public void refreshProject() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root != null) {
            IJavaProject jproject = root.getJavaProject();
            IProject project = jproject.getProject();
            try {
                project.refreshLocal(1, null);
                jproject.makeConsistent(null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

