/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.orm;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.core.internal.IJpaFileContentProvider;
import org.eclipse.jpt.core.internal.IJpaRootContentNode;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmXmlResource;
import org.eclipse.jpt.core.internal.content.orm.XmlRootContentNode;
import org.eclipse.jpt.core.internal.content.orm.resource.OrmXmlResourceFactory;

public class OrmXmlJpaFileContentProvider
implements IJpaFileContentProvider {
    public static OrmXmlJpaFileContentProvider INSTANCE = new OrmXmlJpaFileContentProvider();

    private OrmXmlJpaFileContentProvider() {
    }

    public IJpaRootContentNode buildRootContent(IFile resourceFile) {
        OrmXmlResourceFactory.register();
        URI fileURI = URI.createPlatformResourceURI((String)resourceFile.getFullPath().toString());
        OrmXmlResource resource = (OrmXmlResource)this.getResourceSet(resourceFile).getResource(fileURI, true);
        XmlRootContentNode root = OrmFactory.eINSTANCE.createXmlRootContentNode();
        root.setEntityMappings(resource.getXmlFileContent());
        resource.eAdapters().add((Object)this.buildRootNodeListener(root));
        return root;
    }

    private Adapter buildRootNodeListener(XmlRootContentNode root) {
        return new RootAdapter(root);
    }

    protected ResourceSet getResourceSet(IFile file) {
        return WorkbenchResourceHelperBase.getResourceSet((IProject)file.getProject());
    }

    public String contentType() {
        return "org.eclipse.jpt.core.content.orm";
    }

    private class RootAdapter
    extends AdapterImpl {
        XmlRootContentNode root;

        private RootAdapter(XmlRootContentNode rootContentNode) {
            this.root = rootContentNode;
        }

        public void notifyChanged(Notification notification) {
            int featureId = notification.getFeatureID(Resource.class);
            if (featureId == 2) {
                if (notification.getEventType() == 3 || notification.getEventType() == 4) {
                    OrmXmlResource resource = (OrmXmlResource)notification.getNotifier();
                    this.root.setEntityMappings(resource.getXmlFileContent());
                }
            } else if (featureId == 4 && !notification.getNewBooleanValue()) {
                OrmXmlResource resource = (OrmXmlResource)notification.getNotifier();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException ioe) {
                    JptCorePlugin.log(ioe);
                }
            }
        }
    }
}

