/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.persistence;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.core.internal.IJpaFileContentProvider;
import org.eclipse.jpt.core.internal.IJpaRootContentNode;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceFactory;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceXmlRootContentNode;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceResource;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceXmlResourceFactory;

public class PersistenceXmlJpaFileContentProvider
implements IJpaFileContentProvider {
    public static PersistenceXmlJpaFileContentProvider INSTANCE = new PersistenceXmlJpaFileContentProvider();

    private PersistenceXmlJpaFileContentProvider() {
    }

    public IJpaRootContentNode buildRootContent(IFile resourceFile) {
        PersistenceXmlResourceFactory.register();
        URI fileURI = URI.createPlatformResourceURI((String)resourceFile.getFullPath().toString());
        PersistenceResource resource = (PersistenceResource)this.getResourceSet(resourceFile).getResource(fileURI, true);
        PersistenceXmlRootContentNode root = PersistenceFactory.eINSTANCE.createPersistenceXmlRootContentNode();
        root.setPersistence(resource.getPersistence());
        resource.eAdapters().add((Object)this.buildRootNodeListener(root));
        return root;
    }

    private Adapter buildRootNodeListener(PersistenceXmlRootContentNode root) {
        return new RootAdapter(root);
    }

    protected ResourceSet getResourceSet(IFile file) {
        return WorkbenchResourceHelperBase.getResourceSet((IProject)file.getProject());
    }

    public String contentType() {
        return "org.eclipse.jpt.core.content.persistence";
    }

    private class RootAdapter
    extends AdapterImpl {
        PersistenceXmlRootContentNode root;

        private RootAdapter(PersistenceXmlRootContentNode rootContentNode) {
            this.root = rootContentNode;
        }

        public void notifyChanged(Notification notification) {
            int featureId = notification.getFeatureID(Resource.class);
            if (featureId == 2) {
                if (notification.getEventType() == 3 || notification.getEventType() == 4) {
                    PersistenceResource resource = (PersistenceResource)((Object)notification.getNotifier());
                    this.root.setPersistence(resource.getPersistence());
                }
            } else if (featureId == 4 && !notification.getNewBooleanValue()) {
                PersistenceResource resource = (PersistenceResource)((Object)notification.getNotifier());
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException ioe) {
                    JptCorePlugin.log(ioe);
                }
            }
        }
    }
}

