/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;
import org.eclipse.jpt.core.internal.jdtutility.NameStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.StringArrayExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumArrayDeclarationAnnotationElementAdapter
implements DeclarationAnnotationElementAdapter<String[]> {
    private final ConversionDeclarationAnnotationElementAdapter<String[], ArrayInitializer> adapter;

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter) {
        this(annotationAdapter, "value");
    }

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        this(annotationAdapter, elementName, true);
    }

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty) {
        this(new ConversionDeclarationAnnotationElementAdapter<String[], ArrayInitializer>(annotationAdapter, elementName, removeAnnotationWhenEmpty, EnumArrayDeclarationAnnotationElementAdapter.buildExpressionConverter()));
    }

    private static ExpressionConverter<String[], ArrayInitializer> buildExpressionConverter() {
        return new StringArrayExpressionConverter<Name>(NameStringExpressionConverter.instance());
    }

    protected EnumArrayDeclarationAnnotationElementAdapter(ConversionDeclarationAnnotationElementAdapter<String[], ArrayInitializer> adapter) {
        this.adapter = adapter;
    }

    @Override
    public String[] getValue(ModifiedDeclaration declaration) {
        return this.resolve(this.adapter.expression(declaration), declaration);
    }

    @Override
    public void setValue(String[] value, ModifiedDeclaration declaration) {
        this.adapter.setValue(this.convertToShortNames(value, declaration), declaration);
    }

    @Override
    public Expression expression(ModifiedDeclaration declaration) {
        return this.adapter.expression(declaration);
    }

    @Override
    public ASTNode astNode(ModifiedDeclaration declaration) {
        return this.adapter.astNode(declaration);
    }

    protected String[] resolve(Expression enumsExpression, ModifiedDeclaration declaration) {
        if (enumsExpression == null) {
            return null;
        }
        ArrayInitializer ai = (ArrayInitializer)enumsExpression;
        List<Expression> expressions = this.expressions(ai);
        int len = expressions.size();
        String[] enums = new String[len];
        int i = len;
        while (i-- > 0) {
            enums[i] = JDTTools.resolveEnum(declaration.iCompilationUnit(), expressions.get(i));
        }
        return enums;
    }

    private List<Expression> expressions(ArrayInitializer arrayInitializer) {
        return arrayInitializer.expressions();
    }

    protected String[] convertToShortNames(String[] enums, ModifiedDeclaration declaration) {
        if (enums == null) {
            return null;
        }
        int len = enums.length;
        String[] shortNames = new String[len];
        int i = len;
        while (i-- > 0) {
            declaration.addStaticImport(enums[i]);
            shortNames[i] = this.shortName(enums[i]);
        }
        return shortNames;
    }

    protected String shortTypeName(String name) {
        return name.substring(0, name.lastIndexOf(46));
    }

    protected String shortName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

