/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DefaultTrueBoolean implements Enumerator
{
    DEFAULT(0, "Default", "Default (False)"),
    TRUE(1, "true", "True"),
    FALSE(2, "false", "False");

    public static final int DEFAULT_VALUE = 0;
    public static final int TRUE_VALUE = 1;
    public static final int FALSE_VALUE = 2;
    private static final DefaultTrueBoolean[] VALUES_ARRAY;
    public static final List<DefaultTrueBoolean> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DefaultTrueBoolean[]{DEFAULT, TRUE, FALSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DefaultTrueBoolean get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DefaultTrueBoolean result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DefaultTrueBoolean getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DefaultTrueBoolean result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DefaultTrueBoolean get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return TRUE;
            }
            case 2: {
                return FALSE;
            }
        }
        return null;
    }

    private DefaultTrueBoolean(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static DefaultTrueBoolean fromJavaAnnotationValue(Object javaAnnotationValue) {
        if (javaAnnotationValue == null) {
            return DEFAULT;
        }
        if (javaAnnotationValue.equals("true")) {
            return TRUE;
        }
        if (javaAnnotationValue.equals("false")) {
            return FALSE;
        }
        return DEFAULT;
    }

    public String convertToJavaAnnotationValue() {
        switch (this.getValue()) {
            case 0: {
                return null;
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "false";
            }
        }
        throw new IllegalArgumentException("unknown boolean type: " + (Object)((Object)this));
    }
}

