/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaEmbedded;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.XmlEmbedded;
import org.eclipse.jpt.core.internal.content.orm.XmlOverride;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.mappings.IAttributeOverride;
import org.eclipse.jpt.core.internal.mappings.IEmbedded;
import org.eclipse.jpt.core.internal.platform.AttributeOverrideContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.XmlAttributeContext;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlEmbeddedContext
extends XmlAttributeContext {
    private Collection<AttributeOverrideContext> attributeOverrideContexts = this.buildAttributeOverrideContexts();

    public XmlEmbeddedContext(IContext parentContext, XmlEmbedded mapping) {
        super(parentContext, mapping);
    }

    protected Collection<AttributeOverrideContext> buildAttributeOverrideContexts() {
        ArrayList<AttributeOverrideContext> contexts = new ArrayList<AttributeOverrideContext>();
        for (IAttributeOverride attributeOverride : this.getEmbedded().getAttributeOverrides()) {
            contexts.add(new AttributeOverrideContext(this, attributeOverride));
        }
        return contexts;
    }

    @Override
    public void refreshDefaults(DefaultsContext parentDefaults) {
        super.refreshDefaults(parentDefaults);
        this.refreshDefaultAttributeOverrides();
        for (AttributeOverrideContext context : this.attributeOverrideContexts) {
            context.refreshDefaults(parentDefaults);
        }
    }

    protected void refreshDefaultAttributeOverrides() {
        Iterator<String> i = this.getEmbedded().allOverridableAttributeNames();
        while (i.hasNext()) {
            String override = i.next();
            if (this.getEmbedded().containsAttributeOverride(override)) continue;
            IAttributeOverride attributeOverride = OrmFactory.eINSTANCE.createXmlAttributeOverride(new IEmbedded.AttributeOverrideOwner(this.getEmbedded()));
            this.getEmbedded().getDefaultAttributeOverrides().add((Object)attributeOverride);
            ((XmlOverride)((Object)attributeOverride)).setName(override);
        }
        Collection attributeNames = CollectionTools.collection(this.getEmbedded().allOverridableAttributeNames());
        ArrayList<IAttributeOverride> overridesToRemove = new ArrayList<IAttributeOverride>();
        for (IAttributeOverride attributeOverride : this.getEmbedded().getDefaultAttributeOverrides()) {
            if (attributeNames.contains(attributeOverride.getName()) && !this.getEmbedded().containsSpecifiedAttributeOverride(attributeOverride.getName())) continue;
            overridesToRemove.add(attributeOverride);
        }
        this.getEmbedded().getDefaultAttributeOverrides().removeAll(overridesToRemove);
    }

    protected XmlTypeMapping getXmlTypeMapping() {
        return (XmlTypeMapping)this.getEmbedded().getPersistentAttribute().typeMapping();
    }

    private IEmbedded getEmbedded() {
        return (IEmbedded)((Object)this.attributeMapping());
    }

    protected JavaEmbedded getJavaEmbedded() {
        IAttributeMapping javaAttributeMapping = this.javaAttributeMapping();
        if (javaAttributeMapping != null && javaAttributeMapping.getKey() == "embedded") {
            return (JavaEmbedded)javaAttributeMapping;
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        for (AttributeOverrideContext aoContext : this.attributeOverrideContexts) {
            aoContext.addToMessages(messages);
        }
    }
}

