/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.IPersistentType;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.mappings.IEntity;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.XmlAttributeContext;

public abstract class XmlRelationshipMappingContext
extends XmlAttributeContext {
    protected XmlRelationshipMappingContext(IContext parentContext, XmlRelationshipMapping mapping) {
        super(parentContext, mapping);
    }

    protected IEntity targetEntity(DefaultsContext defaultsContext) {
        String targetEntity = this.relationshipMapping().fullyQualifiedTargetEntity();
        if (targetEntity == null) {
            return null;
        }
        IPersistentType persistentType = defaultsContext.persistentType(targetEntity);
        if (persistentType == null) {
            return null;
        }
        ITypeMapping typeMapping = persistentType.getMapping();
        if (typeMapping instanceof IEntity) {
            return (IEntity)typeMapping;
        }
        return null;
    }

    protected XmlRelationshipMapping relationshipMapping() {
        return (XmlRelationshipMapping)this.attributeMapping();
    }

    public void refreshDefaults(DefaultsContext defaultsContext) {
        super.refreshDefaults(defaultsContext);
        this.relationshipMapping().refreshDefaults(defaultsContext);
    }

    protected IRelationshipMapping javaRelationshipMapping() {
        IAttributeMapping javaAttributeMapping = this.javaAttributeMapping();
        if (javaAttributeMapping instanceof IRelationshipMapping) {
            return (IRelationshipMapping)javaAttributeMapping;
        }
        return null;
    }

    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        if (key.equals("oneToMany.targetEntity")) {
            IRelationshipMapping javaMapping = this.javaRelationshipMapping();
            if (javaMapping != null) {
                if (!this.relationshipMapping().isVirtual() && this.relationshipMapping().getPersistentType().getMapping().isXmlMetadataComplete()) {
                    return javaMapping.getDefaultTargetEntity();
                }
                return javaMapping.getTargetEntity();
            }
            Attribute attribute = this.relationshipMapping().getPersistentAttribute().getAttribute();
            if (attribute != null) {
                return JavaRelationshipMapping.buildReferenceEntityTypeName(attribute.typeSignature(), this.relationshipMapping().getPersistentType().findJdtType());
            }
        }
        return super.getDefault(key, defaultsContext);
    }
}

