/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.facet.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.axis2.core.plugin.messages.Axis2CoreUIMessages;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;
import org.eclipse.jst.ws.axis2.core.utils.FacetContainerUtils;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.jst.ws.axis2.core.utils.RuntimePropertyUtils;
import org.eclipse.jst.ws.axis2.facet.utils.Axis2RuntimeUtils;
import org.eclipse.jst.ws.axis2.facet.utils.Axis2WebappUtils;
import org.eclipse.jst.ws.axis2.facet.utils.ContentCopyUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class Axis2WebservicesServerCommand
extends AbstractDataModelOperation {
    String project;
    Axis2EmitterContext context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();

    public Axis2WebservicesServerCommand(String project) {
        this.project = project;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.OK_STATUS;
    }

    public IStatus exexuteOverrride(IProgressMonitor monitor) {
        IStatus status = null;
        String runtimeLocation = null;
        ContentCopyUtils contentCopyUtils = new ContentCopyUtils();
        try {
            runtimeLocation = this.context.isAxis2ServerPathRepresentsWar() || RuntimePropertyUtils.getWarStatusFromPropertiesFile() ? Axis2RuntimeUtils.copyAxis2War(monitor, "path") : Axis2WebappUtils.copyAxis2War(monitor, "path");
        }
        catch (FileNotFoundException e) {
            return this.handleExceptionStatus(e);
        }
        catch (IOException e) {
            return this.handleExceptionStatus(e);
        }
        catch (Exception e) {
            return this.handleExceptionStatus(e);
        }
        status = contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(runtimeLocation, FacetContainerUtils.pathToWebProjectContainer(this.project), monitor);
        status = Status.OK_STATUS;
        File tempFacetDirectory = new File(runtimeLocation);
        if (tempFacetDirectory.exists() && this.context.isAxis2ServerPathRepresentsWar()) {
            FileUtils.deleteDir(tempFacetDirectory);
        }
        return status;
    }

    private void cleanupIfFacetStatusFailed(String runtimeLocation) {
        File tempFacetDirectory = new File(runtimeLocation);
        if (tempFacetDirectory.exists()) {
            FileUtils.deleteDir(tempFacetDirectory);
        }
    }

    private IStatus handleExceptionStatus(Exception e) {
        Status status = null;
        status = new Status(1, this.project, 1, Axis2CoreUIMessages.ERROR_SERVER_IS_NOT_SET, (Throwable)e);
        this.cleanupIfFacetStatusFailed(Axis2CoreUtils.tempAxis2Directory());
        return status;
    }
}

