/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.commands.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.commands.IDebugCommandHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.internal.ui.commands.actions.ActionsUpdater;
import org.eclipse.debug.internal.ui.commands.actions.ExecuteActionRequest;
import org.eclipse.debug.internal.ui.commands.actions.ICommandParticipant;
import org.eclipse.debug.internal.ui.commands.actions.UpdateActionsRequest;
import org.eclipse.debug.internal.ui.commands.actions.UpdateHandlerRequest;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebugCommandService
implements IDebugContextListener {
    private Map fCommandUpdates = new HashMap();
    private IWorkbenchWindow fWindow = null;
    private IDebugContextService fContextService = null;
    private static Map fgServices = new HashMap();

    public static synchronized DebugCommandService getService(IWorkbenchWindow window) {
        DebugCommandService service = (DebugCommandService)fgServices.get(window);
        if (service == null) {
            service = new DebugCommandService(window);
            fgServices.put(window, service);
        }
        return service;
    }

    public DebugCommandService(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fContextService = DebugUITools.getDebugContextManager().getContextService(window);
        this.fContextService.addPostDebugContextListener(this);
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowOpened(IWorkbenchWindow w) {
            }

            public void windowDeactivated(IWorkbenchWindow w) {
            }

            public void windowClosed(IWorkbenchWindow w) {
                if (DebugCommandService.this.fWindow == w) {
                    DebugCommandService.this.dispose();
                }
            }

            public void windowActivated(IWorkbenchWindow w) {
            }
        });
    }

    private void dispose() {
        this.fContextService.removeDebugContextListener(this);
        fgServices.remove(this.fWindow);
        this.fCommandUpdates.clear();
        this.fWindow = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUpdateCommand(Class commandType, Action action) {
        Map map = this.fCommandUpdates;
        synchronized (map) {
            ArrayList<Action> actions = (ArrayList<Action>)this.fCommandUpdates.get(commandType);
            if (actions == null) {
                actions = new ArrayList<Action>();
                this.fCommandUpdates.put(commandType, actions);
            }
            actions.add(action);
        }
    }

    public void updateCommand(Class commandType, IAction action) {
        ISelection context = this.fContextService.getActiveContext();
        if (context instanceof IStructuredSelection && !context.isEmpty()) {
            Object[] elements = ((IStructuredSelection)context).toArray();
            this.updateCommand(commandType, elements, new IAction[]{action});
        } else {
            action.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postUpdate(ISelection context) {
        Map commands = null;
        Map map = this.fCommandUpdates;
        synchronized (map) {
            commands = this.fCommandUpdates;
            this.fCommandUpdates = new HashMap(commands.size());
        }
        if (context instanceof IStructuredSelection && !context.isEmpty()) {
            Object[] elements = ((IStructuredSelection)context).toArray();
            Iterator iterator = commands.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Class commandType = (Class)entry.getKey();
                List actions = (List)entry.getValue();
                this.updateCommand(commandType, elements, actions.toArray(new IAction[actions.size()]));
            }
        } else {
            Iterator iterator = commands.values().iterator();
            while (iterator.hasNext()) {
                List actionList = (List)iterator.next();
                Iterator actions = actionList.iterator();
                while (actions.hasNext()) {
                    ((IAction)actions.next()).setEnabled(false);
                }
            }
        }
        commands.clear();
    }

    private void updateCommand(Class handlerType, Object[] elements, IAction[] actions) {
        if (elements.length == 1) {
            Object element = elements[0];
            IDebugCommandHandler handler = this.getHandler(element, handlerType);
            if (handler != null) {
                UpdateActionsRequest request = new UpdateActionsRequest(elements, actions);
                handler.canExecute((IEnabledStateRequest)request);
                return;
            }
        } else {
            Map map = this.collate(elements, handlerType);
            if (map != null) {
                ActionsUpdater updater = new ActionsUpdater(actions, map.size());
                Iterator entries = map.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    IDebugCommandHandler handler = (IDebugCommandHandler)entry.getKey();
                    List list = (List)entry.getValue();
                    UpdateHandlerRequest request = new UpdateHandlerRequest(list.toArray(), updater);
                    handler.canExecute((IEnabledStateRequest)request);
                }
                return;
            }
        }
        int i = 0;
        while (i < actions.length) {
            actions[i].setEnabled(false);
            ++i;
        }
    }

    public boolean executeCommand(Class handlerType, Object[] elements, ICommandParticipant participant) {
        if (elements.length == 1) {
            Object element = elements[0];
            IDebugCommandHandler handler = this.getHandler(element, handlerType);
            if (handler != null) {
                ExecuteActionRequest request = new ExecuteActionRequest(elements);
                request.setCommandParticipant(participant);
                return handler.execute((IDebugCommandRequest)request);
            }
        } else {
            Map map = this.collate(elements, handlerType);
            if (map != null) {
                boolean enabled = true;
                Iterator entries = map.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    IDebugCommandHandler handler = (IDebugCommandHandler)entry.getKey();
                    List list = (List)entry.getValue();
                    ExecuteActionRequest request = new ExecuteActionRequest(list.toArray());
                    request.setCommandParticipant(participant);
                    enabled &= handler.execute((IDebugCommandRequest)request);
                }
                return enabled;
            }
        }
        return false;
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.postUpdate(event.getContext());
    }

    private Map collate(Object[] elements, Class handlerType) {
        HashMap<IDebugCommandHandler, ArrayList<Object>> map = new HashMap<IDebugCommandHandler, ArrayList<Object>>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            IDebugCommandHandler handler = this.getHandler(element, handlerType);
            if (handler == null) {
                return null;
            }
            ArrayList<Object> list = (ArrayList<Object>)map.get(handler);
            if (list == null) {
                list = new ArrayList<Object>();
                map.put(handler, list);
            }
            list.add(element);
            ++i;
        }
        return map;
    }

    private IDebugCommandHandler getHandler(Object element, Class handlerType) {
        IDebugCommandHandler handler = null;
        if (handlerType.isInstance(element)) {
            handler = (IDebugCommandHandler)element;
        } else if (element instanceof IAdaptable) {
            handler = (IDebugCommandHandler)((IAdaptable)element).getAdapter(handlerType);
        }
        return handler;
    }
}

