/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class LaunchShortcutSelectionDialog
extends ListDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.debug.ui.SELECT_LAUNCH_SHORTCUT_DIALOG";
    private String fMode = null;
    private IResource fResource = null;
    private Text fDescriptionText = null;

    public LaunchShortcutSelectionDialog(IResource resource, String mode) {
        super(DebugUIPlugin.getShell());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fResource = resource;
        this.fMode = mode;
        ILaunchMode lmode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.fMode);
        String modename = this.fMode;
        if (lmode != null) {
            modename = DebugUIPlugin.removeAccelerators(lmode.getLabel());
        }
        this.setTitle(MessageFormat.format((String)LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_0, (Object[])new String[]{modename}));
        this.setAddCancelButton(true);
        if (this.fResource == null) {
            this.setMessage(MessageFormat.format((String)LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_4, (Object[])new String[]{modename.toLowerCase()}));
        } else {
            this.setMessage(MessageFormat.format((String)LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_1, (Object[])new String[]{modename.toLowerCase(), this.fResource.getName()}));
        }
        this.setLabelProvider(new DefaultLabelProvider());
        this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.debug.ui.select_launch_method_dialog");
        return comp;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS);
        }
        return section;
    }

    protected Point getInitialSize() {
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings != null) {
            try {
                int width = settings.getInt("DIALOG_WIDTH");
                int height = settings.getInt("DIALOG_HEIGHT");
                if (width > 0 & height > 0) {
                    return new Point(width, height);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return new Point(450, 450);
            }
        }
        return new Point(450, 450);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(false);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchShortcutSelectionDialog.this.getOkButton().setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    protected Control createDialogArea(Composite container) {
        Composite comp = (Composite)super.createDialogArea(container);
        if (this.fResource != null) {
            ArrayList input = new ArrayList(DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchShortcuts(this.fResource));
            this.getTableViewer().setInput(input);
        }
        Group group = SWTFactory.createGroup(comp, LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_2, 1, 1, 1808);
        GridData gd = (GridData)group.getLayoutData();
        gd.heightHint = 175;
        this.fDescriptionText = SWTFactory.createText((Composite)group, 72, 1, 1808);
        this.fDescriptionText.setBackground(group.getBackground());
        this.getTableViewer().getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Object o = e.item.getData();
                if (o instanceof LaunchShortcutExtension) {
                    String txt = ((LaunchShortcutExtension)o).getShortcutDescription(LaunchShortcutSelectionDialog.this.fMode);
                    LaunchShortcutSelectionDialog.this.fDescriptionText.setText(txt == null ? LaunchConfigurationsMessages.LaunchShortcutSelectionDialog_3 : txt);
                }
            }
        });
        return comp;
    }
}

